/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.oppo;

import android.content.Context;
import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVOPPOPushAdapter;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.callback.ICallBackResultService;
import io.reactivex.Observer;
import java.util.List;

public class AVMixPushManager {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVMixPushManager.class);
    public static final String MIXPUSH_PROFILE = "deviceProfile";
    public static String oppoDeviceProfile = "";

    public static boolean registerOppoPush(Context context, String appKey, String appSecret, AVOPPOPushAdapter callback) {
        if (null == context || StringUtil.isEmpty((String)appKey) || StringUtil.isEmpty((String)appSecret)) {
            LOGGER.e("invalid parameter. context=" + context + ", appKey=" + appKey);
            return false;
        }
        HeytapPushManager.init((Context)context, (boolean)true);
        if (!AVMixPushManager.isSupportOppoPush(context)) {
            LOGGER.e("current device doesn't support OPPO Push.");
            return false;
        }
        HeytapPushManager.register((Context)context, (String)appKey, (String)appSecret, (ICallBackResultService)callback);
        HeytapPushManager.requestNotificationPermission();
        return true;
    }

    public static boolean registerOppoPush(Context context, String appKey, String appSecret, String profile, AVOPPOPushAdapter callback) {
        oppoDeviceProfile = profile;
        return AVMixPushManager.registerOppoPush(context, appKey, appSecret, callback);
    }

    public static boolean isSupportOppoPush(Context context) {
        return HeytapPushManager.isSupportPush();
    }

    public static void pauseOppoPush() {
        HeytapPushManager.pausePush();
    }

    public static void resumeOppoPush() {
        HeytapPushManager.resumePush();
    }

    public static void setOppoPushTime(List<Integer> weekDays, int startHour, int startMinute, int endHour, int endMinute) {
        HeytapPushManager.setPushTime(weekDays, (int)startHour, (int)startMinute, (int)endHour, (int)endMinute);
    }

    @Deprecated
    public static void setOppoAliases(List<String> aliases) {
    }

    @Deprecated
    public static void unsetOppoAlias(String alias) {
    }

    @Deprecated
    public static void getOppoAliases() {
    }

    @Deprecated
    public static void setOppoUserAccount(String account) {
    }

    @Deprecated
    public static void unsetOppoUserAccouts(List<String> accounts) {
    }

    @Deprecated
    public static void getOppoUserAccounts() {
    }

    @Deprecated
    public static void setOppoTags(List<String> tags) {
    }

    @Deprecated
    public static void unsetOppoTags(List<String> tags) {
    }

    @Deprecated
    public static void getOppoTags() {
    }

    public static void getOppoPushStatus() {
        HeytapPushManager.getPushStatus();
    }

    public static void getOppoNotificationStatus() {
        HeytapPushManager.getNotificationStatus();
    }

    public static void unRegisterMixPush() {
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        String vendor = installation.getString("vendor");
        if (!StringUtil.isEmpty((String)vendor)) {
            installation.put("vendor", (Object)"lc");
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        AVMixPushManager.printErrorLog("unRegisterMixPush error!");
                    } else {
                        LOGGER.d("Registration canceled successfully!");
                    }
                }
            }));
            HeytapPushManager.unRegister();
        }
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

