/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.oppo.AVMixPushManager;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.heytap.mcssdk.callback.PushAdapter;
import io.reactivex.Observer;

public class AVOPPOPushAdapter
extends PushAdapter {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVOPPOPushAdapter.class);
    private static final String VENDOR_OPPO = "oppo";

    private void updateAVInstallation(String registerId) {
        if (!StringUtil.isEmpty((String)registerId)) {
            String localProfile;
            AVInstallation installation = AVInstallation.getCurrentInstallation();
            if (!VENDOR_OPPO.equals(installation.getString("vendor"))) {
                installation.put("vendor", (Object)VENDOR_OPPO);
            }
            if (!registerId.equals(installation.getString("registrationId"))) {
                installation.put("registrationId", (Object)registerId);
            }
            String string = localProfile = null != (localProfile = installation.getString("deviceProfile")) ? localProfile : "";
            if (!localProfile.equals(AVMixPushManager.oppoDeviceProfile)) {
                installation.put("deviceProfile", (Object)AVMixPushManager.oppoDeviceProfile);
            }
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        LOGGER.e("update installation error!", (Throwable)e);
                    } else {
                        LOGGER.d("oppo push registration successful!");
                    }
                }
            }));
        }
    }

    public void onRegister(int responseCode, String registerID) {
        if (responseCode != 0) {
            LOGGER.e("failed to register device. errorCode: " + responseCode);
            return;
        }
        if (StringUtil.isEmpty((String)registerID)) {
            LOGGER.e("oppo register id is empty.");
            return;
        }
        this.updateAVInstallation(registerID);
    }
}

