/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.oppo;

import android.content.Context;
import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVOPPOPushAdapter;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.heytap.mcssdk.PushManager;
import com.heytap.mcssdk.callback.PushCallback;
import io.reactivex.Observer;
import java.util.List;

public class AVMixPushManager {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVMixPushManager.class);
    public static final String MIXPUSH_PROFILE = "deviceProfile";
    public static String oppoDeviceProfile = "";

    public static boolean registerOppoPush(Context context, String appKey, String appSecret, AVOPPOPushAdapter callback) {
        if (!AVMixPushManager.isSupportOppoPush(context)) {
            return false;
        }
        PushManager.getInstance().register(context, appKey, appSecret, (PushCallback)callback);
        return true;
    }

    public static boolean registerOppoPush(Context context, String appKey, String appSecret, String profile, AVOPPOPushAdapter callback) {
        oppoDeviceProfile = profile;
        return AVMixPushManager.registerOppoPush(context, appKey, appSecret, callback);
    }

    public static boolean isSupportOppoPush(Context context) {
        return PushManager.isSupportPush((Context)context);
    }

    public static void pauseOppoPush() {
        PushManager.getInstance().pausePush();
    }

    public static void resumeOppoPush() {
        PushManager.getInstance().resumePush();
    }

    public static void setOppoPushTime(List<Integer> weekDays, int startHour, int startMinute, int endHour, int endMinute) {
        PushManager.getInstance().setPushTime(weekDays, startHour, startMinute, endHour, endMinute);
    }

    public static void setOppoAliases(List<String> aliases) {
        PushManager.getInstance().setAliases(aliases);
    }

    public static void unsetOppoAlias(String alias) {
        PushManager.getInstance().unsetAlias(alias);
    }

    public static void getOppoAliases() {
        PushManager.getInstance().getAliases();
    }

    public static void setOppoUserAccount(String account) {
        PushManager.getInstance().setUserAccount(account);
    }

    public static void unsetOppoUserAccouts(List<String> accounts) {
        PushManager.getInstance().unsetUserAccounts(accounts);
    }

    public static void getOppoUserAccounts() {
        PushManager.getInstance().getUserAccounts();
    }

    public static void setOppoTags(List<String> tags) {
        PushManager.getInstance().setTags(tags);
    }

    public static void unsetOppoTags(List<String> tags) {
        PushManager.getInstance().unsetTags(tags);
    }

    public static void getOppoTags() {
        PushManager.getInstance().getTags();
    }

    public static void getOppoPushStatus() {
        PushManager.getInstance().getPushStatus();
    }

    public static void getOppoNotificationStatus() {
        PushManager.getInstance().getNotificationStatus();
    }

    public static void unRegisterMixPush() {
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        String vendor = installation.getString("vendor");
        if (!StringUtil.isEmpty((String)vendor)) {
            installation.put("vendor", (Object)"lc");
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        AVMixPushManager.printErrorLog("unRegisterMixPush error!");
                    } else {
                        LOGGER.d("Registration canceled successfully!");
                    }
                }
            }));
        }
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

