/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.content.Context;
import android.content.Intent;
import cn.leancloud.LCException;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.flyme.LCMixPushManager;
import cn.leancloud.push.AndroidNotificationManager;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.meizu.cloud.pushsdk.MzPushMessageReceiver;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import io.reactivex.Observer;

public class LCFlymePushMessageReceiver
extends MzPushMessageReceiver {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCFlymePushMessageReceiver.class);
    private static final String AV_MIXPUSH_FLYME_NOTIFICATION_ACTION = "com.avos.avoscloud.flyme_notification_action";
    private final String FLYME_VERDOR = "mz";

    private void updateAVInstallation(String flymePushId) {
        if (!StringUtil.isEmpty((String)flymePushId)) {
            String localProfile;
            LCInstallation installation = LCInstallation.getCurrentInstallation();
            if (!"mz".equals(installation.getString("vendor"))) {
                installation.put("vendor", (Object)"mz");
            }
            if (!flymePushId.equals(installation.getString("registrationId"))) {
                installation.put("registrationId", (Object)flymePushId);
            }
            String string = localProfile = null != (localProfile = installation.getString("deviceProfile")) ? localProfile : "";
            if (!localProfile.equals(LCMixPushManager.flymeDeviceProfile)) {
                installation.put("deviceProfile", (Object)LCMixPushManager.flymeDeviceProfile);
            }
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(LCException e) {
                    if (null != e) {
                        LOGGER.e("update installation error!", (Throwable)e);
                    } else {
                        LOGGER.d("flyme push registration successful!");
                    }
                }
            }));
        }
    }

    public void onMessage(Context context, String s) {
        if (null == context || null == s) {
            return;
        }
        LOGGER.d("throughMessage coming, message=" + s);
        AndroidNotificationManager androidNotificationManager = AndroidNotificationManager.getInstance();
        androidNotificationManager.processMixPushMessage(s);
    }

    public void onMessage(Context var1, String message, String platformExtra) {
    }

    public void onMessage(Context context, Intent intent) {
    }

    public void onPushStatus(Context context, PushSwitchStatus pushSwitchStatus) {
        if (null == context || null == pushSwitchStatus) {
            return;
        }
        LOGGER.d("switchNotificationMessage=" + pushSwitchStatus.isSwitchNotificationMessage() + ", switchThroughMessage=" + pushSwitchStatus.isSwitchThroughMessage() + ", pushId=" + pushSwitchStatus.getPushId());
        String pushId = pushSwitchStatus.getPushId();
        if (!StringUtil.isEmpty((String)pushId) && (pushSwitchStatus.isSwitchNotificationMessage() || pushSwitchStatus.isSwitchThroughMessage())) {
            this.updateAVInstallation(pushId);
        }
    }

    public void onRegisterStatus(Context context, RegisterStatus registerStatus) {
        if (null == context || null == registerStatus) {
            return;
        }
        LOGGER.d("register successed, pushId=" + registerStatus.getPushId());
        String pushId = registerStatus.getPushId();
        if (!StringUtil.isEmpty((String)pushId)) {
            this.updateAVInstallation(pushId);
        }
    }

    public void onUnRegisterStatus(Context context, UnRegisterStatus unRegisterStatus) {
        if (null == context || null == unRegisterStatus) {
            return;
        }
        LOGGER.d("unregister successed, message=" + unRegisterStatus.getMessage());
    }

    public void onSubTagsStatus(Context context, SubTagsStatus subTagsStatus) {
    }

    public void onSubAliasStatus(Context context, SubAliasStatus subAliasStatus) {
    }

    public void onUnRegister(Context var1, boolean var2) {
    }

    public void onRegister(Context var1, String var2) {
    }

    public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
        if (LCMixPushManager.flymeMStatusBarIcon != 0) {
            pushNotificationBuilder.setmStatusbarIcon(LCMixPushManager.flymeMStatusBarIcon);
        }
    }

    public void onNotificationArrived(Context context, MzPushMessage var2) {
    }

    public void onNotificationClicked(Context context, MzPushMessage var2) {
        if (null == context || null == var2) {
            return;
        }
        LOGGER.d("notificationClicked, message=" + var2.getSelfDefineContentString());
        String selfDefineContentString = var2.getSelfDefineContentString();
        AndroidNotificationManager androidNotificationManager = AndroidNotificationManager.getInstance();
        androidNotificationManager.processMixNotification(selfDefineContentString, AV_MIXPUSH_FLYME_NOTIFICATION_ACTION);
    }

    public void onNotificationDeleted(Context context, MzPushMessage var2) {
    }

    public void onNotifyMessageArrived(Context context, String message) {
    }
}

