/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.hms;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import cn.leancloud.LCException;
import cn.leancloud.LCHMSMessageService;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.LCManifestUtils;
import cn.leancloud.callback.LCCallback;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hmf.tasks.OnCompleteListener;
import com.huawei.hmf.tasks.Task;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.push.HmsMessaging;
import io.reactivex.Observer;

public class LCMixPushManager {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCMixPushManager.class);
    public static final String MIXPUSH_PROFILE = "deviceProfile";
    public static String hwDeviceProfile = "";
    static Class hwMessageServiceClazz = LCHMSMessageService.class;

    public static void registerHMSPush(Application application) {
        LCMixPushManager.registerHMSPush(application, "");
    }

    public static void registerHMSPush(Application application, String profile) {
        LCMixPushManager.registerHMSPush(application, profile, null);
    }

    public static void registerHMSPush(Application application, String profile, Class customMessageServiceClazz) {
        if (null == application) {
            throw new IllegalArgumentException("[HMS] context cannot be null.");
        }
        if (!LCMixPushManager.isHuaweiPhone()) {
            LCMixPushManager.printErrorLog("[HMS] register error, is not huawei phone!");
            return;
        }
        if (null != customMessageServiceClazz) {
            hwMessageServiceClazz = customMessageServiceClazz;
        }
        if (!LCMixPushManager.checkHuaweiManifest((Context)application)) {
            LCMixPushManager.printErrorLog("[HMS] register error, mainifest is incomplete!");
            return;
        }
        hwDeviceProfile = profile;
        LOGGER.d("[HMS] start register HMS push");
    }

    public static void connectHMS(Activity activity) {
        if (null == activity) {
            throw new IllegalArgumentException("[HMS] activity cannot be null.");
        }
        String appId = AGConnectServicesConfig.fromContext((Context)activity).getString("client/app_id");
        LCMixPushManager.connectHMS(activity, appId);
    }

    public static void connectHMS(final Activity activity, final String huaweiAppId) {
        if (null == activity) {
            throw new IllegalArgumentException("[HMS] activity cannot be null.");
        }
        if (Looper.getMainLooper() == Looper.myLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String token = HmsInstanceId.getInstance((Context)activity).getToken(huaweiAppId, "HCM");
                        LOGGER.d("found HMS appId: " + huaweiAppId + ", token: " + token);
                        LCHMSMessageService.updateAVInstallation(token);
                    }
                    catch (Exception ex) {
                        LOGGER.w("failed to get hms token. cause: " + ex.getMessage());
                    }
                }
            }).start();
        } else {
            try {
                String token = HmsInstanceId.getInstance((Context)activity).getToken(huaweiAppId, "HCM");
                LOGGER.d("found HMS appId: " + huaweiAppId + ", token: " + token);
                LCHMSMessageService.updateAVInstallation(token);
            }
            catch (Exception ex) {
                LOGGER.w("failed to get hms token. cause: " + ex.getMessage());
            }
        }
    }

    public static void turnOnHMSPush(Context context, final LCCallback<Void> callback) {
        HmsMessaging.getInstance((Context)context).turnOnPush().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(Task<Void> task) {
                if (task.isSuccessful()) {
                    callback.internalDone(null);
                } else {
                    callback.internalDone(new LCException((Throwable)task.getException()));
                }
            }
        });
    }

    public static void turnOffHMSPush(Context context, final LCCallback<Void> callback) {
        HmsMessaging.getInstance((Context)context).turnOffPush().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(Task<Void> task) {
                if (task.isSuccessful()) {
                    callback.internalDone(null);
                } else {
                    callback.internalDone(new LCException((Throwable)task.getException()));
                }
            }
        });
    }

    public static void setAutoInitEnabled(Context context, boolean isEnabled) {
        if (null == context) {
            return;
        }
        HmsMessaging.getInstance((Context)context).setAutoInitEnabled(isEnabled);
    }

    public static boolean isAutoInitEnabled(Context context) {
        if (null == context) {
            return false;
        }
        return HmsMessaging.getInstance((Context)context).isAutoInitEnabled();
    }

    public static void unRegisterMixPush() {
        LCInstallation installation = LCInstallation.getCurrentInstallation();
        String vendor = installation.getString("vendor");
        if (!StringUtil.isEmpty((String)vendor)) {
            installation.put("vendor", (Object)"lc");
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(LCException e) {
                    if (null != e) {
                        LCMixPushManager.printErrorLog("unRegisterMixPush error!");
                    } else {
                        LOGGER.d("Registration canceled successfully!");
                    }
                }
            }));
        }
    }

    private static boolean isHuaweiPhone() {
        String phoneBrand = Build.BRAND;
        try {
            return phoneBrand.equalsIgnoreCase("huawei") || phoneBrand.equalsIgnoreCase("honor");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkHuaweiManifest(Context context) {
        boolean result = false;
        try {
            result = LCManifestUtils.checkPermission((Context)context, (String)"android.permission.INTERNET") && LCManifestUtils.checkService((Context)context, (Class)hwMessageServiceClazz);
        }
        catch (Exception e) {
            LOGGER.d(e.getMessage());
        }
        return result;
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

