/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCException;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.hms.LCMixPushManager;
import cn.leancloud.json.JSON;
import cn.leancloud.push.AndroidNotificationManager;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.huawei.hms.push.HmsMessageService;
import com.huawei.hms.push.RemoteMessage;
import io.reactivex.Observer;

public class LCHMSMessageService
extends HmsMessageService {
    static final LCLogger LOGGER = LogUtil.getLogger(LCHMSMessageService.class);
    static final String MIXPUSH_PRIFILE = "deviceProfile";
    static final String VENDOR = "HMS";

    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            AndroidNotificationManager androidNotificationManager = AndroidNotificationManager.getInstance();
            String message = remoteMessage.getData();
            if (!StringUtil.isEmpty((String)message)) {
                LOGGER.d("received passthrough(data) message: " + message);
                androidNotificationManager.processMixPushMessage(message);
            } else if (null != remoteMessage.getNotification()) {
                RemoteMessage.Notification notification = remoteMessage.getNotification();
                String notifyString = JSON.toJSONString((Object)notification);
                LOGGER.d("received passthrough(notification) message: " + notifyString);
                androidNotificationManager.processMixPushMessage(notifyString);
            } else {
                LOGGER.e("unknown passthrough message: " + remoteMessage.toString());
            }
        }
        catch (Exception ex) {
            LOGGER.e("failed to process PushMessage.", (Throwable)ex);
        }
    }

    public void onNewToken(String token) {
        LCHMSMessageService.updateAVInstallation(token);
    }

    public void onTokenError(Exception exception) {
        LOGGER.w("failed to apply token. cause: " + exception.getMessage());
    }

    public static void updateAVInstallation(String hwToken) {
        String localProfile;
        if (StringUtil.isEmpty((String)hwToken)) {
            return;
        }
        LCInstallation installation = LCInstallation.getCurrentInstallation();
        if (!VENDOR.equals(installation.getString("vendor"))) {
            installation.put("vendor", (Object)VENDOR);
        }
        if (!hwToken.equals(installation.getString("registrationId"))) {
            installation.put("registrationId", (Object)hwToken);
        }
        if (null == (localProfile = installation.getString(MIXPUSH_PRIFILE))) {
            localProfile = "";
        }
        if (!localProfile.equals(LCMixPushManager.hwDeviceProfile)) {
            installation.put(MIXPUSH_PRIFILE, (Object)LCMixPushManager.hwDeviceProfile);
        }
        installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

            public void done(LCException e) {
                if (null != e) {
                    LOGGER.e("update installation error!", (Throwable)e);
                } else {
                    LOGGER.d("Huawei push registration successful!");
                }
            }
        }));
    }
}

