/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import cn.leancloud.AVException;
import cn.leancloud.AVFlymePushMessageReceiver;
import cn.leancloud.AVHMSMessageService;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVManifestUtils;
import cn.leancloud.AVMiPushMessageReceiver;
import cn.leancloud.AVOPPOPushAdapter;
import cn.leancloud.AVOSCloud;
import cn.leancloud.callback.AVCallback;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.heytap.mcssdk.callback.PushCallback;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hmf.tasks.OnCompleteListener;
import com.huawei.hmf.tasks.Task;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.push.HmsMessaging;
import com.huawei.hms.support.api.push.service.HmsMsgService;
import com.meizu.cloud.pushsdk.PushManager;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.vivo.push.IPushActionListener;
import com.vivo.push.PushClient;
import com.vivo.push.util.VivoPushException;
import com.xiaomi.mipush.sdk.MiPushClient;
import io.reactivex.Observer;
import java.util.List;

public class AVMixPushManager {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVMixPushManager.class);
    static final String MIXPUSH_PROFILE = "deviceProfile";
    static String miDeviceProfile = "";
    static Class miPushReceiverClazz = AVMiPushMessageReceiver.class;
    static String hwDeviceProfile = "";
    static Class hwMessageServiceClazz = AVHMSMessageService.class;
    static String flymeDeviceProfile = "";
    static int flymeMStatusBarIcon = 0;
    static Class flymePushReceiverClazz = AVFlymePushMessageReceiver.class;
    static String vivoDeviceProfile = "";
    static String oppoDeviceProfile = "";

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey) {
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, "");
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, Class customizedReceiver) {
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, "", customizedReceiver);
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, String profile) {
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, profile, null);
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, String profile, Class customizedReceiver) {
        if (null == context) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        if (StringUtil.isEmpty((String)miAppId)) {
            throw new IllegalArgumentException("miAppId cannot be null.");
        }
        if (StringUtil.isEmpty((String)miAppKey)) {
            throw new IllegalArgumentException("miAppKey cannot be null.");
        }
        if (null != customizedReceiver) {
            miPushReceiverClazz = customizedReceiver;
        }
        if (!AVMixPushManager.isXiaomiPhone()) {
            AVMixPushManager.printErrorLog("register error, current device is not a xiaomi phone!");
        }
        if (!AVMixPushManager.checkXiaomiManifest(context)) {
            AVMixPushManager.printErrorLog("register error, mainifest is incomplete(receiver not found: " + miPushReceiverClazz.getSimpleName() + ")!");
            return;
        }
        miDeviceProfile = profile;
        MiPushClient.registerPush((Context)context, (String)miAppId, (String)miAppKey);
        LOGGER.d("finished to register mi push");
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, String profile, boolean isInternationalVendor) {
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, profile, isInternationalVendor, null);
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, String profile, boolean isInternationalVendor, Class customizedReceiver) {
        AVMiPushMessageReceiver.setInternationalVendor(isInternationalVendor);
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, profile, customizedReceiver);
    }

    public static void registerHMSPush(Application application) {
        AVMixPushManager.registerHMSPush(application, "");
    }

    public static void registerHMSPush(Application application, String profile) {
        AVMixPushManager.registerHMSPush(application, profile, null);
    }

    public static void registerHMSPush(Application application, String profile, Class customMessageServiceClazz) {
        if (null == application) {
            throw new IllegalArgumentException("[HMS] context cannot be null.");
        }
        if (!AVMixPushManager.isHuaweiPhone()) {
            AVMixPushManager.printErrorLog("[HMS] register error, is not huawei phone!");
            return;
        }
        if (null != customMessageServiceClazz) {
            hwMessageServiceClazz = customMessageServiceClazz;
        }
        if (!AVMixPushManager.checkHuaweiManifest((Context)application)) {
            AVMixPushManager.printErrorLog("[HMS] register error, mainifest is incomplete!");
            return;
        }
        hwDeviceProfile = profile;
        LOGGER.d("[HMS] start register HMS push");
    }

    public static void connectHMS(Activity activity) {
        if (null == activity) {
            throw new IllegalArgumentException("[HMS] activity cannot be null.");
        }
        String appId = AGConnectServicesConfig.fromContext((Context)activity).getString("client/app_id");
        AVMixPushManager.connectHMS(activity, appId);
    }

    public static void connectHMS(final Activity activity, final String huaweiAppId) {
        if (null == activity) {
            throw new IllegalArgumentException("[HMS] activity cannot be null.");
        }
        if (Looper.getMainLooper() == Looper.myLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String token = HmsInstanceId.getInstance((Context)activity).getToken(huaweiAppId, "HCM");
                        LOGGER.d("found HMS appId: " + huaweiAppId + ", token: " + token);
                        AVHMSMessageService.updateAVInstallation(token);
                    }
                    catch (Exception ex) {
                        LOGGER.w("failed to get hms token. cause: " + ex.getMessage());
                    }
                }
            }).start();
        } else {
            try {
                String token = HmsInstanceId.getInstance((Context)activity).getToken(huaweiAppId, "HCM");
                LOGGER.d("found HMS appId: " + huaweiAppId + ", token: " + token);
                AVHMSMessageService.updateAVInstallation(token);
            }
            catch (Exception ex) {
                LOGGER.w("failed to get hms token. cause: " + ex.getMessage());
            }
        }
    }

    public static void turnOnHMSPush(Context context, final AVCallback<Void> callback) {
        HmsMessaging.getInstance((Context)context).turnOnPush().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(Task<Void> task) {
                if (task.isSuccessful()) {
                    callback.internalDone(null);
                } else {
                    callback.internalDone(new AVException((Throwable)task.getException()));
                }
            }
        });
    }

    public static void turnOffHMSPush(Context context, final AVCallback<Void> callback) {
        HmsMessaging.getInstance((Context)context).turnOffPush().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(Task<Void> task) {
                if (task.isSuccessful()) {
                    callback.internalDone(null);
                } else {
                    callback.internalDone(new AVException((Throwable)task.getException()));
                }
            }
        });
    }

    public static boolean registerFlymePush(Context context, String flymeId, String flymeKey, String profile) {
        return AVMixPushManager.registerFlymePush(context, flymeId, flymeKey, profile, null);
    }

    public static boolean registerFlymePush(Context context, String flymeId, String flymeKey, String profile, Class customizedReceiver) {
        if (null == context) {
            AVMixPushManager.printErrorLog("register error, context is null!");
            return false;
        }
        boolean result = false;
        if (!MzSystemUtils.isBrandMeizu((Context)context)) {
            AVMixPushManager.printErrorLog("register error, is not flyme phone!");
        } else {
            if (null != customizedReceiver) {
                flymePushReceiverClazz = customizedReceiver;
            }
            if (!AVMixPushManager.checkFlymeManifest(context)) {
                AVMixPushManager.printErrorLog("register error, mainifest is incomplete!");
            } else {
                flymeDeviceProfile = profile;
                PushManager.register((Context)context, (String)flymeId, (String)flymeKey);
                result = true;
                LOGGER.d("start register flyme push");
            }
        }
        return result;
    }

    public static boolean registerFlymePush(Context context, String flymeId, String flymeKey) {
        return AVMixPushManager.registerFlymePush(context, flymeId, flymeKey, "", null);
    }

    public static boolean registerFlymePush(Context context, String flymeId, String flymeKey, Class customizedReceiver) {
        return AVMixPushManager.registerFlymePush(context, flymeId, flymeKey, "", customizedReceiver);
    }

    public static void setFlymeMStatusbarIcon(int icon) {
        flymeMStatusBarIcon = icon;
    }

    public static boolean registerVIVOPush(Application application) {
        return AVMixPushManager.registerVIVOPush(application, "");
    }

    public static boolean registerVIVOPush(Application application, String profile) {
        vivoDeviceProfile = profile;
        PushClient client = PushClient.getInstance((Context)application.getApplicationContext());
        try {
            client.checkManifest();
            client.initialize();
            return true;
        }
        catch (VivoPushException ex) {
            AVMixPushManager.printErrorLog("register error, mainifest is incomplete! details=" + ex.getMessage());
            return false;
        }
    }

    public static void turnOffVIVOPush(final AVCallback<Boolean> callback) {
        PushClient.getInstance((Context)AVOSCloud.getContext()).turnOffPush(new IPushActionListener(){

            public void onStateChanged(int state) {
                if (null == callback) {
                    AVException exception = null;
                    if (0 != state) {
                        exception = new AVException(999, "VIVO server internal error, state=" + state);
                    }
                    callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                }
            }
        });
    }

    public static void turnOnVIVOPush(final AVCallback<Boolean> callback) {
        PushClient.getInstance((Context)AVOSCloud.getContext()).turnOnPush(new IPushActionListener(){

            public void onStateChanged(int state) {
                if (null == callback) {
                    AVException exception = null;
                    if (0 != state) {
                        exception = new AVException(999, "VIVO server internal error, state=" + state);
                    }
                    callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                }
            }
        });
    }

    public static boolean isSupportVIVOPush(Context context) {
        PushClient client = PushClient.getInstance((Context)context);
        if (null == client) {
            return false;
        }
        return client.isSupport();
    }

    public static void bindVIVOAlias(Context context, String alias, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).bindAlias(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static void unbindVIVOAlias(Context context, String alias, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).unBindAlias(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static String getVIVOAlias(Context context) {
        if (null == context) {
            return null;
        }
        return PushClient.getInstance((Context)context).getAlias();
    }

    public static void setVIVOTopic(Context context, String topic, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).setTopic(topic, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static void delVIVOTopic(Context context, String alias, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).delTopic(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static List<String> getVIVOTopics(Context context) {
        if (null == context) {
            return null;
        }
        return PushClient.getInstance((Context)context).getTopics();
    }

    public static boolean registerOppoPush(Context context, String appKey, String appSecret, AVOPPOPushAdapter callback) {
        if (!AVMixPushManager.isSupportOppoPush(context)) {
            return false;
        }
        com.heytap.mcssdk.PushManager.getInstance().register(context, appKey, appSecret, (PushCallback)callback);
        return true;
    }

    public static boolean registerOppoPush(Context context, String appKey, String appSecret, String profile, AVOPPOPushAdapter callback) {
        oppoDeviceProfile = profile;
        return AVMixPushManager.registerOppoPush(context, appKey, appSecret, callback);
    }

    public static boolean isSupportOppoPush(Context context) {
        return com.heytap.mcssdk.PushManager.isSupportPush((Context)context);
    }

    public static void pauseOppoPush() {
        com.heytap.mcssdk.PushManager.getInstance().pausePush();
    }

    public static void resumeOppoPush() {
        com.heytap.mcssdk.PushManager.getInstance().resumePush();
    }

    public static void setOppoPushTime(List<Integer> weekDays, int startHour, int startMinute, int endHour, int endMinute) {
        com.heytap.mcssdk.PushManager.getInstance().setPushTime(weekDays, startHour, startMinute, endHour, endMinute);
    }

    public static void setOppoAliases(List<String> aliases) {
        com.heytap.mcssdk.PushManager.getInstance().setAliases(aliases);
    }

    public static void unsetOppoAlias(String alias) {
        com.heytap.mcssdk.PushManager.getInstance().unsetAlias(alias);
    }

    public static void getOppoAliases() {
        com.heytap.mcssdk.PushManager.getInstance().getAliases();
    }

    public static void setOppoUserAccount(String account) {
        com.heytap.mcssdk.PushManager.getInstance().setUserAccount(account);
    }

    public static void unsetOppoUserAccouts(List<String> accounts) {
        com.heytap.mcssdk.PushManager.getInstance().unsetUserAccounts(accounts);
    }

    public static void getOppoUserAccounts() {
        com.heytap.mcssdk.PushManager.getInstance().getUserAccounts();
    }

    public static void setOppoTags(List<String> tags) {
        com.heytap.mcssdk.PushManager.getInstance().setTags(tags);
    }

    public static void unsetOppoTags(List<String> tags) {
        com.heytap.mcssdk.PushManager.getInstance().unsetTags(tags);
    }

    public static void getOppoTags() {
        com.heytap.mcssdk.PushManager.getInstance().getTags();
    }

    public static void getOppoPushStatus() {
        com.heytap.mcssdk.PushManager.getInstance().getPushStatus();
    }

    public static void getOppoNotificationStatus() {
        com.heytap.mcssdk.PushManager.getInstance().getNotificationStatus();
    }

    public static void unRegisterMixPush() {
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        String vendor = installation.getString("vendor");
        if (!StringUtil.isEmpty((String)vendor)) {
            installation.put("vendor", (Object)"lc");
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        AVMixPushManager.printErrorLog("unRegisterMixPush error!");
                    } else {
                        LOGGER.d("Registration canceled successfully!");
                    }
                }
            }));
        }
    }

    private static boolean isHuaweiPhone() {
        String phoneBrand = Build.BRAND;
        try {
            return phoneBrand.equalsIgnoreCase("huawei") || phoneBrand.equalsIgnoreCase("honor");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isXiaomiPhone() {
        String phoneManufacturer = Build.MANUFACTURER;
        return !StringUtil.isEmpty((String)phoneManufacturer) && phoneManufacturer.toLowerCase().contains("xiaomi");
    }

    private static boolean checkXiaomiManifest(Context context) {
        try {
            return AVManifestUtils.checkReceiver((Context)context, (Class)miPushReceiverClazz);
        }
        catch (Exception e) {
            LOGGER.d(e.getMessage());
            return false;
        }
    }

    private static boolean checkHuaweiManifest(Context context) {
        boolean result = false;
        try {
            result = AVManifestUtils.checkPermission((Context)context, (String)"android.permission.INTERNET") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.ACCESS_WIFI_STATE") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") && AVManifestUtils.checkService((Context)context, HmsMsgService.class) && AVManifestUtils.checkService((Context)context, (Class)hwMessageServiceClazz);
        }
        catch (Exception e) {
            LOGGER.d(e.getMessage());
        }
        return result;
    }

    private static boolean checkFlymeManifest(Context context) {
        boolean result = false;
        try {
            result = AVManifestUtils.checkPermission((Context)context, (String)"android.permission.INTERNET") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") && AVManifestUtils.checkReceiver((Context)context, (Class)flymePushReceiverClazz);
        }
        catch (Exception e) {
            LOGGER.d(e.getMessage());
        }
        return result;
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

