/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.content.Context;
import android.text.TextUtils;
import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVMixPushManager;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.push.AndroidNotificationManager;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import io.reactivex.Observer;
import java.util.List;

public class AVMiPushMessageReceiver
extends PushMessageReceiver {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVMiPushMessageReceiver.class);
    private static final String AV_MIXPUSH_MI_NOTIFICATION_ACTION = "com.avos.avoscloud.mi_notification_action";
    private static final String AV_MIXPUSH_MI_NOTIFICATION_ARRIVED_ACTION = "com.avos.avoscloud.mi_notification_arrived_action";
    public static final String VENDOR_XIAOMI = "mi";
    public static final String VENDOR_XIAOMI_INTERNATIONAL = "mi-intl";
    private static String defaultVendor = "mi";

    public static void setInternationalVendor(boolean isInternationalVendor) {
        defaultVendor = isInternationalVendor ? VENDOR_XIAOMI_INTERNATIONAL : VENDOR_XIAOMI;
    }

    private void updateAVInstallation(String miRegId) {
        if (!StringUtil.isEmpty((String)miRegId)) {
            String localProfile;
            AVInstallation installation = AVInstallation.getCurrentInstallation();
            if (!defaultVendor.equals(installation.getString("vendor"))) {
                installation.put("vendor", (Object)defaultVendor);
            }
            if (!miRegId.equals(installation.getString("registrationId"))) {
                installation.put("registrationId", (Object)miRegId);
            }
            String string = localProfile = null != (localProfile = installation.getString("deviceProfile")) ? localProfile : "";
            if (!localProfile.equals(AVMixPushManager.miDeviceProfile)) {
                installation.put("deviceProfile", (Object)AVMixPushManager.miDeviceProfile);
            }
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        LOGGER.e("update installation error!", (Throwable)e);
                    } else {
                        LOGGER.d("Xiaomi push registration successful!");
                    }
                }
            }));
        }
    }

    private void processMiPushMessage(MiPushMessage miPushMessage) {
        if (null != miPushMessage) {
            String title = miPushMessage.getTitle();
            String description = miPushMessage.getDescription();
            String content = miPushMessage.getContent();
            JSONObject jsonObject = null;
            if (!TextUtils.isEmpty((CharSequence)content)) {
                try {
                    jsonObject = JSON.parseObject((String)content);
                }
                catch (Exception exception) {
                    LOGGER.e("Parsing json data error, " + content, (Throwable)exception);
                }
            }
            if (null == jsonObject) {
                jsonObject = new JSONObject();
            }
            if (!StringUtil.isEmpty((String)title)) {
                jsonObject.put("title", (Object)title);
            }
            if (!StringUtil.isEmpty((String)description)) {
                jsonObject.put("alert", (Object)description);
            }
            AndroidNotificationManager androidNotificationManager = AndroidNotificationManager.getInstance();
            androidNotificationManager.processMixPushMessage(jsonObject.toJSONString());
        }
    }

    private void processMiNotification(MiPushMessage miPushMessage) {
        String content;
        if (null != miPushMessage && !StringUtil.isEmpty((String)(content = miPushMessage.getContent()))) {
            AndroidNotificationManager androidNotificationManager = AndroidNotificationManager.getInstance();
            androidNotificationManager.processMixNotification(content, AV_MIXPUSH_MI_NOTIFICATION_ACTION);
        }
    }

    public void onReceiveRegisterResult(Context context, MiPushCommandMessage miPushCommandMessage) {
        String cmdArg1;
        super.onReceiveRegisterResult(context, miPushCommandMessage);
        String command = miPushCommandMessage.getCommand();
        List arguments = miPushCommandMessage.getCommandArguments();
        String string = cmdArg1 = arguments != null && arguments.size() > 0 ? (String)arguments.get(0) : null;
        if ("register".equals(command)) {
            if (miPushCommandMessage.getResultCode() == 0L) {
                this.updateAVInstallation(cmdArg1);
            } else {
                LOGGER.d("register error, " + miPushCommandMessage.toString());
            }
        }
    }

    public void onCommandResult(Context context, MiPushCommandMessage message) {
        String cmdArg2;
        super.onCommandResult(context, message);
        String command = message.getCommand();
        List arguments = message.getCommandArguments();
        String cmdArg1 = arguments != null && arguments.size() > 0 ? (String)arguments.get(0) : null;
        String string = cmdArg2 = arguments != null && arguments.size() > 1 ? (String)arguments.get(1) : null;
        if ("register".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.updateAVInstallation(cmdArg1);
            }
        } else if ("set-alias".equals(command) || "unset-alias".equals(command) || "subscribe-topic".equals(command) || "unsubscibe-topic".equals(command) || "accept-time".equals(command)) {
            // empty if block
        }
    }

    public void onNotificationMessageArrived(Context context, MiPushMessage miPushMessage) {
        String content;
        if (null != miPushMessage && !StringUtil.isEmpty((String)(content = miPushMessage.getContent()))) {
            AndroidNotificationManager androidNotificationManager = AndroidNotificationManager.getInstance();
            androidNotificationManager.porcessMixNotificationArrived(content, AV_MIXPUSH_MI_NOTIFICATION_ARRIVED_ACTION);
        }
    }

    public void onReceivePassThroughMessage(Context context, MiPushMessage miPushMessage) {
        this.processMiPushMessage(miPushMessage);
    }

    public void onNotificationMessageClicked(Context context, MiPushMessage miPushMessage) {
        this.processMiNotification(miPushMessage);
    }
}

