/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.content.Context;
import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVMixPushManager;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.vivo.push.model.UPSNotificationMessage;
import com.vivo.push.sdk.OpenClientPushMessageReceiver;
import io.reactivex.Observer;

public abstract class AVVIVOPushMessageReceiver
extends OpenClientPushMessageReceiver {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVVIVOPushMessageReceiver.class);
    private final String VIVO_VERDOR = "vivo";

    public abstract void onNotificationMessageClicked(Context var1, UPSNotificationMessage var2);

    public void onReceiveRegId(Context var1, final String regId) {
        if (StringUtil.isEmpty((String)regId)) {
            LOGGER.e("received empty regId from VIVO server.");
        } else {
            String localProfile;
            AVInstallation installation = AVInstallation.getCurrentInstallation();
            if (!"vivo".equals(installation.getString("vendor"))) {
                installation.put("vendor", (Object)"vivo");
            }
            if (!regId.equals(installation.getString("registrationId"))) {
                installation.put("registrationId", (Object)regId);
            }
            String string = localProfile = null != (localProfile = installation.getString("deviceProfile")) ? localProfile : "";
            if (!localProfile.equals(AVMixPushManager.vivoDeviceProfile)) {
                installation.put("deviceProfile", (Object)AVMixPushManager.vivoDeviceProfile);
            }
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        LOGGER.e("update installation(for vivo) error!", (Throwable)e);
                    } else {
                        LOGGER.d("vivo push registration successful! regId=" + regId);
                    }
                }
            }));
        }
    }
}

