/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import cn.leancloud.AVException;
import cn.leancloud.AVFlymePushMessageReceiver;
import cn.leancloud.AVHMSPushMessageReceiver;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVManifestUtils;
import cn.leancloud.AVMiPushMessageReceiver;
import cn.leancloud.AVOSCloud;
import cn.leancloud.callback.AVCallback;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.huawei.android.hms.agent.HMSAgent;
import com.huawei.android.hms.agent.common.handler.ConnectHandler;
import com.huawei.android.hms.agent.push.handler.EnableReceiveNormalMsgHandler;
import com.huawei.android.hms.agent.push.handler.EnableReceiveNotifyMsgHandler;
import com.huawei.android.hms.agent.push.handler.GetTokenHandler;
import com.huawei.android.hms.agent.push.handler.QueryAgreementHandler;
import com.meizu.cloud.pushsdk.PushManager;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.vivo.push.IPushActionListener;
import com.vivo.push.PushClient;
import com.vivo.push.util.VivoPushException;
import com.xiaomi.mipush.sdk.MiPushClient;
import io.reactivex.Observer;
import java.util.List;

public class AVMixPushManager {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVMixPushManager.class);
    static final String MIXPUSH_PROFILE = "deviceProfile";
    static String miDeviceProfile = "";
    static String hwDeviceProfile = "";
    static String flymeDeviceProfile = "";
    static int flymeMStatusBarIcon = 0;
    static String vivoDeviceProfile = "";

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey) {
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, "");
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, String profile) {
        if (null == context) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        if (StringUtil.isEmpty((String)miAppId)) {
            throw new IllegalArgumentException("miAppId cannot be null.");
        }
        if (StringUtil.isEmpty((String)miAppKey)) {
            throw new IllegalArgumentException("miAppKey cannot be null.");
        }
        if (!AVMixPushManager.isXiaomiPhone()) {
            AVMixPushManager.printErrorLog("register error, is not xiaomi phone!");
            return;
        }
        if (!AVMixPushManager.checkXiaomiManifest(context)) {
            AVMixPushManager.printErrorLog("register error, mainifest is incomplete!");
            return;
        }
        miDeviceProfile = profile;
        MiPushClient.registerPush((Context)context, (String)miAppId, (String)miAppKey);
        LOGGER.d("start register mi push");
    }

    public static void registerHMSPush(Application application) {
        AVMixPushManager.registerHMSPush(application, "");
    }

    public static void registerHMSPush(Application application, String profile) {
        if (null == application) {
            throw new IllegalArgumentException("[HMS] context cannot be null.");
        }
        if (!AVMixPushManager.isHuaweiPhone()) {
            AVMixPushManager.printErrorLog("[HMS] register error, is not huawei phone!");
            return;
        }
        if (!AVMixPushManager.checkHuaweiManifest((Context)application)) {
            AVMixPushManager.printErrorLog("[HMS] register error, mainifest is incomplete!");
            return;
        }
        hwDeviceProfile = profile;
        boolean hmsInitResult = HMSAgent.init((Application)application);
        if (!hmsInitResult) {
            LOGGER.e("failed to init HMSAgent.");
        }
        LOGGER.d("[HMS] start register HMS push");
    }

    public static void connectHMS(Activity activity) {
        if (null == activity) {
            throw new IllegalArgumentException("[HMS] activity cannot be null.");
        }
        HMSAgent.connect((Activity)activity, (ConnectHandler)new ConnectHandler(){

            public void onConnect(int rst) {
                LOGGER.d("[HMS] connect end:" + rst);
                HMSAgent.Push.getToken((GetTokenHandler)new GetTokenHandler(){

                    public void onResult(int rst) {
                        LOGGER.d("[HMS] get token: end. returnCode=" + rst);
                    }
                });
            }
        });
    }

    public static void setHMSReceiveNormalMsg(final boolean enable) {
        HMSAgent.Push.enableReceiveNormalMsg((boolean)enable, (EnableReceiveNormalMsgHandler)new EnableReceiveNormalMsgHandler(){

            public void onResult(int rst) {
                LOGGER.d("[HMS] enableReceiveNormalMsg(flag=" + enable + ") returnCode=" + rst);
            }
        });
    }

    public static void setHMSReceiveNotifyMsg(final boolean enable) {
        HMSAgent.Push.enableReceiveNotifyMsg((boolean)enable, (EnableReceiveNotifyMsgHandler)new EnableReceiveNotifyMsgHandler(){

            public void onResult(int rst) {
                LOGGER.d("[HMS] enableReceiveNotifyMsg(flag=" + enable + ") returnCode=" + rst);
            }
        });
    }

    public static void showHMSAgreement() {
        HMSAgent.Push.queryAgreement((QueryAgreementHandler)new QueryAgreementHandler(){

            public void onResult(int rst) {
                LOGGER.d("[HMS] query agreement result: " + rst);
            }
        });
    }

    public static boolean registerFlymePush(Context context, String flymeId, String flymeKey, String profile) {
        if (null == context) {
            AVMixPushManager.printErrorLog("register error, context is null!");
            return false;
        }
        boolean result = false;
        if (!MzSystemUtils.isBrandMeizu((Context)context)) {
            AVMixPushManager.printErrorLog("register error, is not flyme phone!");
        } else if (!AVMixPushManager.checkFlymeManifest(context)) {
            AVMixPushManager.printErrorLog("register error, mainifest is incomplete!");
        } else {
            flymeDeviceProfile = profile;
            PushManager.register((Context)context, (String)flymeId, (String)flymeKey);
            result = true;
            LOGGER.d("start register flyme push");
        }
        return result;
    }

    public static boolean registerFlymePush(Context context, String flymeId, String flymeKey) {
        return AVMixPushManager.registerFlymePush(context, flymeId, flymeKey, "");
    }

    public static void setFlymeMStatusbarIcon(int icon) {
        flymeMStatusBarIcon = icon;
    }

    public static boolean registerVIVOPush(Application application) {
        return AVMixPushManager.registerVIVOPush(application, "");
    }

    public static boolean registerVIVOPush(Application application, String profile) {
        vivoDeviceProfile = profile;
        PushClient client = PushClient.getInstance((Context)application.getApplicationContext());
        try {
            client.checkManifest();
            client.initialize();
            return true;
        }
        catch (VivoPushException ex) {
            AVMixPushManager.printErrorLog("register error, mainifest is incomplete! details=" + ex.getMessage());
            return false;
        }
    }

    public static void turnOffVIVOPush(final AVCallback<Boolean> callback) {
        PushClient.getInstance((Context)AVOSCloud.getContext()).turnOffPush(new IPushActionListener(){

            public void onStateChanged(int state) {
                if (null == callback) {
                    AVException exception = null;
                    if (0 != state) {
                        exception = new AVException(999, "VIVO server internal error, state=" + state);
                    }
                    callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                }
            }
        });
    }

    public static void turnOnVIVOPush(final AVCallback<Boolean> callback) {
        PushClient.getInstance((Context)AVOSCloud.getContext()).turnOnPush(new IPushActionListener(){

            public void onStateChanged(int state) {
                if (null == callback) {
                    AVException exception = null;
                    if (0 != state) {
                        exception = new AVException(999, "VIVO server internal error, state=" + state);
                    }
                    callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                }
            }
        });
    }

    public static boolean isSupportVIVOPush(Context context) {
        PushClient client = PushClient.getInstance((Context)context);
        if (null == client) {
            return false;
        }
        return client.isSupport();
    }

    public static void bindVIVOAlias(Context context, String alias, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).bindAlias(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static void unbindVIVOAlias(Context context, String alias, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).unBindAlias(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static String getVIVOAlias(Context context) {
        if (null == context) {
            return null;
        }
        return PushClient.getInstance((Context)context).getAlias();
    }

    public static void setVIVOTopic(Context context, String alias, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).setTopic(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static void delVIVOTopic(Context context, String alias, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).delTopic(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static List<String> getVIVOTopics(Context context) {
        if (null == context) {
            return null;
        }
        return PushClient.getInstance((Context)context).getTopics();
    }

    public static void unRegisterMixPush() {
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        String vendor = installation.getString("vendor");
        if (!StringUtil.isEmpty((String)vendor)) {
            installation.put("vendor", (Object)"lc");
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        AVMixPushManager.printErrorLog("unRegisterMixPush error!");
                    } else {
                        LOGGER.d("Registration canceled successfully!");
                    }
                }
            }));
        }
    }

    private static boolean isHuaweiPhone() {
        String phoneBrand = Build.BRAND;
        try {
            return phoneBrand.equalsIgnoreCase("huawei") || phoneBrand.equalsIgnoreCase("honor");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isXiaomiPhone() {
        String phoneManufacturer = Build.MANUFACTURER;
        return !StringUtil.isEmpty((String)phoneManufacturer) && phoneManufacturer.toLowerCase().contains("xiaomi");
    }

    private static boolean checkXiaomiManifest(Context context) {
        try {
            return AVManifestUtils.checkReceiver((Context)context, AVMiPushMessageReceiver.class);
        }
        catch (Exception e) {
            LOGGER.d(e.getMessage());
            return false;
        }
    }

    private static boolean checkHuaweiManifest(Context context) {
        boolean result = false;
        try {
            result = AVManifestUtils.checkPermission((Context)context, (String)"android.permission.INTERNET") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.ACCESS_WIFI_STATE") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") && AVManifestUtils.checkReceiver((Context)context, AVHMSPushMessageReceiver.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static boolean checkFlymeManifest(Context context) {
        boolean result = false;
        try {
            result = AVManifestUtils.checkPermission((Context)context, (String)"android.permission.INTERNET") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") && AVManifestUtils.checkReceiver((Context)context, AVFlymePushMessageReceiver.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

