/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.app.NotificationManager;
import android.content.Context;
import android.os.Bundle;
import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVMixPushManager;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.push.AndroidNotificationManager;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.huawei.hms.support.api.push.PushReceiver;
import io.reactivex.Observer;

public class AVHMSPushMessageReceiver
extends PushReceiver {
    static final AVLogger LOGGER = LogUtil.getLogger(AVHMSPushMessageReceiver.class);
    static final String MIXPUSH_PRIFILE = "deviceProfile";
    static final String VENDOR = "HMS";

    private void updateAVInstallation(String hwToken) {
        String localProfile;
        if (StringUtil.isEmpty((String)hwToken)) {
            return;
        }
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        if (!VENDOR.equals(installation.getString("vendor"))) {
            installation.put("vendor", (Object)VENDOR);
        }
        if (!hwToken.equals(installation.getString("registrationId"))) {
            installation.put("registrationId", (Object)hwToken);
        }
        if (null == (localProfile = installation.getString(MIXPUSH_PRIFILE))) {
            localProfile = "";
        }
        if (!localProfile.equals(AVMixPushManager.hwDeviceProfile)) {
            installation.put(MIXPUSH_PRIFILE, (Object)AVMixPushManager.hwDeviceProfile);
        }
        installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

            public void done(AVException e) {
                if (null != e) {
                    LOGGER.e("update installation error!", (Throwable)e);
                } else {
                    LOGGER.d("Huawei push registration successful!");
                }
            }
        }));
    }

    public void onToken(Context context, String token, Bundle bundle) {
        this.updateAVInstallation(token);
    }

    public void onPushMsg(Context var1, byte[] var2, String var3) {
        try {
            String message = new String(var2, "UTF-8");
            AndroidNotificationManager androidNotificationManager = AndroidNotificationManager.getInstance();
            androidNotificationManager.processMixPushMessage(message);
        }
        catch (Exception ex) {
            LOGGER.e("failed to process PushMessage.", (Throwable)ex);
        }
    }

    public void onEvent(Context context, PushReceiver.Event event, Bundle extras) {
        LOGGER.d("received Notify Event. Event=" + event);
        if (PushReceiver.Event.NOTIFICATION_CLICK_BTN.equals((Object)event) || PushReceiver.Event.NOTIFICATION_OPENED.equals((Object)event)) {
            int notifyId = extras.getInt("pushNotifyId", 0);
            LOGGER.d("received Push Event. notifyId:" + notifyId);
            if (0 != notifyId) {
                NotificationManager manager = (NotificationManager)context.getSystemService("notification");
                manager.cancel(notifyId);
            }
        } else {
            LOGGER.d("unknow event.");
        }
        super.onEvent(context, event, extras);
    }

    public void onPushState(Context context, boolean pushState) {
        LOGGER.d("pushState changed, current=" + pushState);
    }
}

