/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.internal.impl;

import cn.leancloud.AVUserCookieSign;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class DefaultAVUserCookieSign
implements AVUserCookieSign {
    private static final String SESSION_TOKEN = "_sessionToken";
    private static final String UID = "_uid";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    String sessionKey;
    String secret;
    int maxAge;

    public DefaultAVUserCookieSign(String secret, int maxAge) {
        this(secret, "avos.sess", maxAge);
    }

    public DefaultAVUserCookieSign(String secret, String sessionKey, int maxAge) {
        this.sessionKey = sessionKey;
        this.secret = secret;
        this.maxAge = maxAge;
    }

    @Override
    public AVUser decodeUser(HttpServletRequest request) {
        String userInfoStr;
        Map userInfo;
        Cookie cookie = DefaultAVUserCookieSign.getCookie(request, this.sessionKey);
        if (cookie != null && (userInfo = (Map)JSON.parseObject((String)(userInfoStr = new String(Base64.getDecoder().decode(cookie.getValue()))), Map.class)).containsKey(UID) && userInfo.containsKey(SESSION_TOKEN)) {
            try {
                AVUser user = (AVUser)AVUser.createWithoutData(AVUser.class, (String)((String)userInfo.get(UID)));
                HashMap value = new HashMap();
                value.put("sessionToken", userInfo.get(SESSION_TOKEN));
                AVUtils.copyPropertiesFromMapToAVObject(value, (AVObject)user);
                return user;
            }
            catch (AVException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Cookie encodeUser(AVUser user) {
        if (user != null) {
            String cookieValue = this.getUserCookieValue(user);
            Cookie cookie = new Cookie(this.sessionKey, cookieValue);
            cookie.setMaxAge(this.maxAge);
            cookie.setPath("/");
            return cookie;
        }
        Cookie cookie = new Cookie(this.sessionKey, null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        return cookie;
    }

    @Override
    public Cookie getCookieSign(AVUser user) {
        Cookie cookie = new Cookie(this.sessionKey + ".sig", null);
        cookie.setPath("/");
        if (user != null) {
            String cookieValue = this.getUserCookieValue(user);
            String text = this.sessionKey + "=" + cookieValue;
            try {
                cookie.setValue(DefaultAVUserCookieSign.encrypt(this.secret, text));
                cookie.setMaxAge(this.maxAge);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
        } else {
            cookie.setMaxAge(0);
        }
        return cookie;
    }

    @Override
    public boolean validateCookieSign(HttpServletRequest request) {
        Cookie userCookie = DefaultAVUserCookieSign.getCookie(request, this.sessionKey);
        Cookie cookieSign = DefaultAVUserCookieSign.getCookie(request, this.sessionKey + ".sig");
        if (userCookie != null && cookieSign != null && cookieSign.getValue() != null && userCookie.getValue() != null) {
            try {
                String encryptedCookieValue = DefaultAVUserCookieSign.encrypt(this.secret, this.sessionKey + "=" + userCookie.getValue());
                return cookieSign.getValue().equals(encryptedCookieValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String encrypt(String secret, String text) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec signingKey = new SecretKeySpec(secret.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(text.getBytes());
        return Base64.getUrlEncoder().withoutPadding().encodeToString(rawHmac);
    }

    private String getUserCookieValue(AVUser user) {
        HashMap<String, String> userInfo = new HashMap<String, String>();
        userInfo.put(UID, user.getObjectId());
        userInfo.put(SESSION_TOKEN, user.getSessionToken());
        String userInfoStr = JSON.toJSONString(userInfo);
        String cookieValue = Base64.getEncoder().encodeToString(userInfoStr.getBytes());
        return cookieValue;
    }

    private static Cookie getCookie(HttpServletRequest req, String cookieName) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    static {
        System.setProperty("org.glassfish.web.rfc2109_cookie_names_enforced", "false");
    }
}

