/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVUserCookieSign;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.internal.impl.DefaultAVUserCookieSign;
import java.net.URL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EngineSessionCookie {
    boolean fetchUser;
    ThreadLocal<HttpServletResponse> responseHolder = new ThreadLocal();
    ThreadLocal<HttpServletRequest> requestHolder = new ThreadLocal();
    AVUserCookieSign sign;

    public EngineSessionCookie(String secret, int maxAge, boolean fetchUser) {
        this(new DefaultAVUserCookieSign(secret, maxAge), fetchUser);
    }

    public EngineSessionCookie(String secret, String sessionKey, int maxAge, boolean fetchUser) {
        this(new DefaultAVUserCookieSign(secret, sessionKey, maxAge), fetchUser);
    }

    public EngineSessionCookie(AVUserCookieSign sign, boolean fetchUser) {
        this.fetchUser = fetchUser;
        this.sign = sign;
    }

    protected void parseCookie(HttpServletRequest req, HttpServletResponse response) {
        this.responseHolder.set(response);
        this.requestHolder.set(req);
        if (this.sign.validateCookieSign(req)) {
            AVUser user = this.sign.decodeUser(req);
            if (this.fetchUser && user != null && !user.isDataAvailable()) {
                try {
                    user.fetch();
                }
                catch (AVException e) {
                    e.printStackTrace();
                }
            }
            if (user != null) {
                AVUser.changeCurrentUser((AVUser)user, (boolean)true);
            }
        }
    }

    public void wrappCookie(boolean inResponse) {
        if (inResponse) {
            HttpServletResponse resp = this.responseHolder.get();
            HttpServletRequest req = this.requestHolder.get();
            if (resp != null) {
                AVUser u = AVUser.getCurrentUser();
                String host = null;
                try {
                    URL requestURL = new URL(req.getRequestURL().toString());
                    host = requestURL.getHost();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EngineSessionCookie.addCookie(req, resp, this.sign.encodeUser(u));
                EngineSessionCookie.addCookie(req, resp, this.sign.getCookieSign(u));
            }
        } else {
            this.responseHolder.set(null);
        }
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, Cookie cookie) {
        Cookie[] cookies = request.getCookies();
        boolean contains = false;
        if (cookies != null && cookies.length > 0) {
            for (Cookie existingCookie : cookies) {
                if (!cookie.getName().equals(existingCookie.getName())) continue;
                String cookieValue = cookie.getValue();
                contains = cookieValue == null ? existingCookie.getValue() == null : cookieValue.equals(existingCookie.getValue());
            }
        }
        if (!contains) {
            response.addCookie(cookie);
        }
    }
}

