/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.internal.impl;

import cn.leancloud.EngineAppConfiguration;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSServices;
import com.avos.avoscloud.FunctionCallback;
import com.avos.avoscloud.internal.AppRouter;
import com.avos.avoscloud.internal.impl.DefaultAppRouter;
import java.util.HashMap;
import java.util.Map;

public class EnvAppRouter
extends AppRouter {
    private boolean isLocalEngineCall = false;
    private EngineAppConfiguration appConf;

    public EnvAppRouter(EngineAppConfiguration appConf) {
        this.appConf = appConf;
    }

    protected void fetchServerHosts(boolean sync, final FunctionCallback<Map<AVOSServices, String>> cb) {
        HashMap<AVOSServices, String> result = new HashMap<AVOSServices, String>();
        String apiServer = this.appConf.getEnvOrProperty("LEANCLOUD_API_SERVER");
        if (apiServer != null) {
            result.put(AVOSServices.API, apiServer);
            result.put(AVOSServices.PUSH, apiServer);
            result.put(AVOSServices.RTM, apiServer);
            if (this.isLocalEngineCall) {
                result.put(AVOSServices.ENGINE, "http://0.0.0.0:" + this.appConf.getPort());
            } else {
                result.put(AVOSServices.ENGINE, apiServer);
            }
            result.put(AVOSServices.STATS, apiServer);
            cb.done(result, null);
            return;
        }
        DefaultAppRouter.instance().fetchServerHosts(sync, (FunctionCallback)new FunctionCallback<Map<AVOSServices, String>>(){

            public void done(Map<AVOSServices, String> hosts, AVException e) {
                if (e != null) {
                    cb.done(null, e);
                    return;
                }
                if (EnvAppRouter.this.isLocalEngineCall) {
                    hosts.put(AVOSServices.ENGINE, "http://0.0.0.0:" + EnvAppRouter.this.appConf.getPort());
                }
                cb.done(hosts, null);
            }
        });
    }

    public void setLocalEngineCallEnabled(boolean enabled) {
        this.isLocalEngineCall = enabled;
    }
}

