/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.EngineAppConfiguration;
import cn.leancloud.EngineFunction;
import cn.leancloud.EngineHandlerInfo;
import cn.leancloud.EngineHook;
import cn.leancloud.EngineSessionCookie;
import cn.leancloud.IMHook;
import com.avos.avoscloud.internal.AppConfiguration;
import com.avos.avoscloud.internal.AppRouter;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.internal.InternalLogger;
import com.avos.avoscloud.internal.InternalPersistence;
import com.avos.avoscloud.internal.InternalRequestSign;
import com.avos.avoscloud.internal.impl.EnginePersistenceImplementation;
import com.avos.avoscloud.internal.impl.EnvAppRouter;
import com.avos.avoscloud.internal.impl.JavaRequestSignImplementation;
import com.avos.avoscloud.internal.impl.Log4j2Implementation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class LeanEngine {
    static volatile boolean httpsRedirectionEnabled = false;
    static EngineAppConfiguration appConf;
    private static EnvAppRouter appRouter;
    static final String JSON_CONTENT_TYPE = "application/json; charset=UTF-8";
    private static Map<String, EngineHandlerInfo> funcs;
    private static EngineSessionCookie sessionCookie;

    public static void initialize(String applicationId, String clientKey, String masterKey) {
        appConf = EngineAppConfiguration.instance(applicationId, clientKey, masterKey);
        appRouter = new EnvAppRouter(appConf);
        InternalConfigurationController.Builder builder = new InternalConfigurationController.Builder();
        builder.setInternalPersistence((InternalPersistence)EnginePersistenceImplementation.instance()).setInternalLogger((InternalLogger)Log4j2Implementation.instance()).setAppConfiguration((AppConfiguration)appConf).setInternalRequestSign((InternalRequestSign)JavaRequestSignImplementation.instance()).setAppRouter((AppRouter)appRouter).build();
        InternalConfigurationController.globalInstance().getAppRouter().updateServerHosts();
    }

    public static void register(Class<?> clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            EngineHandlerInfo info;
            IMHook imHook;
            EngineHandlerInfo info2;
            EngineFunction func = m.getAnnotation(EngineFunction.class);
            if (func != null) {
                EngineHandlerInfo info3 = EngineHandlerInfo.getEngineHandlerInfo(m, func);
                if (info3 == null) continue;
                funcs.put(info3.getEndPoint(), info3);
                continue;
            }
            EngineHook hook = m.getAnnotation(EngineHook.class);
            if (hook != null && (info2 = EngineHandlerInfo.getEngineHandlerInfo(m, hook)) != null) {
                funcs.put(info2.getEndPoint(), info2);
            }
            if ((imHook = m.getAnnotation(IMHook.class)) == null || (info = EngineHandlerInfo.getEngineHandlerInfo(m, imHook)) == null) continue;
            funcs.put(info.getEndPoint(), info);
        }
    }

    static EngineHandlerInfo getHandler(String key) {
        return funcs.get(key);
    }

    public static void addSessionCookie(EngineSessionCookie sessionCookie) {
        LeanEngine.sessionCookie = sessionCookie;
    }

    public static EngineSessionCookie getSessionCookie() {
        return sessionCookie;
    }

    public static void setLocalEngineCallEnabled(boolean enabled) {
        appRouter.setLocalEngineCallEnabled(enabled);
        InternalConfigurationController.globalInstance().getAppRouter().updateServerHosts();
    }

    public static void setHttpsRedirectEnabled(boolean enabled) {
        httpsRedirectionEnabled = enabled;
    }

    public static String hmacSha1(String value, String key) {
        try {
            byte[] keyBytes = key.getBytes();
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(value.getBytes());
            byte[] hexBytes = new Hex().encode(rawHmac);
            return new String(hexBytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setUseMasterKey(boolean useMasterKey) {
        JavaRequestSignImplementation.instance().setUseMasterKey(useMasterKey);
    }

    protected static Set<String> getMetaData() {
        return funcs.keySet();
    }

    public static String getAppId() {
        return appConf.getApplicationId();
    }

    public static String getAppKey() {
        return appConf.getClientKey();
    }

    public static String getMasterKey() {
        return appConf.getMasterKey();
    }

    public static String getAppEnv() {
        return appConf.getAppEnv();
    }

    public static void useAVCloudUS() {
        appConf.setIsCN(false);
    }

    public static void useAVCloudCN() {
        appConf.setIsCN(true);
    }

    static {
        funcs = new HashMap<String, EngineHandlerInfo>();
    }
}

