/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EngineRequestContext {
    private static final String UPDATED_KEYS = "_updatedKeys";
    private static final String REMOTE_ADDRESS = "_remoteAddress";
    private static final String BEFORE_KEYS = "__before";
    private static final String AFTER_KEYS = "__after";
    static ThreadLocal<Map<String, Object>> localMeta = new ThreadLocal();

    public static Map<String, Object> getMeta() {
        return localMeta.get();
    }

    public static List<String> getUpdateKeys() {
        Map<String, Object> meta = EngineRequestContext.getMeta();
        if (meta != null && meta.containsKey(UPDATED_KEYS)) {
            return (List)meta.get(UPDATED_KEYS);
        }
        return null;
    }

    public static String getRemoteAddress() {
        Map<String, Object> meta = EngineRequestContext.getMeta();
        if (meta != null && meta.containsKey(REMOTE_ADDRESS)) {
            return (String)meta.get(REMOTE_ADDRESS);
        }
        return null;
    }

    protected static void parseMetaData(Map<String, Object> objectProperties) {
        Map<String, Object> existingMeta;
        HashMap<String, Object> meta = new HashMap<String, Object>();
        if (objectProperties == null) {
            return;
        }
        if (objectProperties.containsKey(UPDATED_KEYS)) {
            Object updateValues = objectProperties.remove(UPDATED_KEYS);
            meta.put(UPDATED_KEYS, updateValues);
        }
        if (objectProperties.containsKey(BEFORE_KEYS)) {
            Object beforeValues = objectProperties.remove(BEFORE_KEYS);
            meta.put(BEFORE_KEYS, beforeValues);
        }
        if (objectProperties.containsKey(AFTER_KEYS)) {
            Object afterValues = objectProperties.remove(AFTER_KEYS);
            meta.put(AFTER_KEYS, afterValues);
        }
        if ((existingMeta = localMeta.get()) != null) {
            existingMeta.putAll(meta);
        } else {
            localMeta.set(meta);
        }
    }

    protected static void setRemoteAddress(String ip) {
        Map<String, Object> existingMeta = localMeta.get();
        if (existingMeta != null) {
            existingMeta.put(REMOTE_ADDRESS, ip);
        } else {
            HashMap<String, String> meta = new HashMap<String, String>();
            meta.put(REMOTE_ADDRESS, ip);
            localMeta.set(meta);
        }
    }

    public static void clean() {
        localMeta.set(null);
    }
}

