/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.search;

import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import cn.leancloud.AVException;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.callback.FindCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.json.JSON;
import cn.leancloud.search.AVSearchQuery;
import cn.leancloud.search.Resources;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SearchActivity
extends AppCompatActivity {
    private static AVLogger LOGGER = LogUtil.getLogger(SearchActivity.class);
    ListView listView;
    LinkedList<AVObject> searchResults = new LinkedList();
    SearchResultAdapter adapter;
    AVSearchQuery searchQuery;
    static final int HIGHLIGHTS_MAX_LENGTH = 200;
    FindCallback<AVObject> searchCallback;
    View loadingView;
    View emtpyResult;
    public static String highlightFontStyle = null;

    public void setSearchQuery(AVSearchQuery query) {
        this.searchQuery = query;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(Resources.layout.search_activity((Context)this));
        this.setupActionBar();
        this.listView = (ListView)this.findViewById(Resources.id.search_result_listview((Context)this));
        this.loadingView = LayoutInflater.from((Context)this).inflate(Resources.layout.search_loading((Context)this), null);
        this.emtpyResult = this.findViewById(Resources.id.search_emtpy_result((Context)this));
        this.listView.addFooterView(this.loadingView);
        this.loadingView.setVisibility(4);
        if (this.getIntent().getExtras() != null) {
            String searchString = this.getIntent().getExtras().getString("com.avos.avoscloud.search.key");
            this.searchQuery = (AVSearchQuery)JSON.parseObject((String)searchString, AVSearchQuery.class);
        }
        if (null != this.searchQuery) {
            this.searchCallback = new FindCallback<AVObject>(){

                public void done(List<AVObject> avObjects, AVException avException) {
                    if (avException == null) {
                        SearchActivity.this.searchResults.addAll(avObjects);
                        if (SearchActivity.this.adapter == null) {
                            SearchActivity.this.adapter = new SearchResultAdapter();
                            SearchActivity.this.listView.setAdapter((ListAdapter)SearchActivity.this.adapter);
                            SearchActivity.this.listView.setOnScrollListener((AbsListView.OnScrollListener)SearchActivity.this.adapter);
                        } else {
                            SearchActivity.this.adapter.notifyDataSetChanged();
                            SearchActivity.this.hideLoadingView();
                        }
                        if (SearchActivity.this.searchResults.size() == 0) {
                            SearchActivity.this.emtpyResult.setVisibility(0);
                            SearchActivity.this.listView.setVisibility(8);
                        } else {
                            SearchActivity.this.emtpyResult.setVisibility(8);
                            SearchActivity.this.listView.setVisibility(0);
                        }
                    }
                }
            };
            this.searchQuery.findInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver(this.searchCallback));
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setupActionBar() {
        ActionBar actionBar = this.getActionBar();
        if (actionBar != null) {
            actionBar.setCustomView(Resources.layout.search_actionbar((Context)this));
            actionBar.setDisplayShowCustomEnabled(true);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            View backButton = actionBar.getCustomView().findViewById(Resources.id.search_actionbar_back((Context)this));
            backButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SearchActivity.this.onBackPressed();
                    SearchActivity.this.finish();
                }
            });
        }
    }

    public void showLoadingView() {
        if (this.loadingView != null) {
            this.loadingView.setVisibility(0);
        }
    }

    public void hideLoadingView() {
        if (this.loadingView != null) {
            this.loadingView.setVisibility(4);
        }
    }

    public static String highlightStringMerge(Map<String, List<String>> highlights) {
        if (highlights != null) {
            StringBuilder sb = new StringBuilder();
            for (String key : highlights.keySet()) {
                sb.append(StringUtil.join((CharSequence)"...", (Iterable)highlights.get(key)));
            }
            if (sb.length() > 200) {
                int lastTailTagIndex;
                String tempString = sb.substring(0, 200);
                StringBuilder tempSB = new StringBuilder(tempString).reverse();
                int lastHeadTagIndex = tempSB.indexOf("<me>");
                if (lastHeadTagIndex < (lastTailTagIndex = tempSB.indexOf("<me/>"))) {
                    return SearchActivity.highLightStringStyle(tempSB.reverse().substring(0, 200 - lastTailTagIndex));
                }
                return SearchActivity.highLightStringStyle(tempString);
            }
            return SearchActivity.highLightStringStyle(sb.toString());
        }
        return "";
    }

    public static String highLightStringStyle(String string2) {
        string2 = string2.replaceAll("<em>", StringUtil.isEmpty((String)highlightFontStyle) ? "<font color='#E68A00'>" : highlightFontStyle);
        string2 = string2.replaceAll("</em>", "</font>");
        return string2;
    }

    public static void setHighLightStyle(String style) {
        highlightFontStyle = style;
    }

    public class SearchResultAdapter
    extends BaseAdapter
    implements AbsListView.OnScrollListener {
        Context mContext;
        int lastVisibleItemId;
        volatile boolean loading;

        public SearchResultAdapter() {
            this.mContext = SearchActivity.this;
        }

        public int getCount() {
            return SearchActivity.this.searchResults.size();
        }

        public Object getItem(int position) {
            return SearchActivity.this.searchResults.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            final AVObject item = (AVObject)this.getItem(position);
            ViewHolder holder = null;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)SearchActivity.this).inflate(Resources.layout.search_result_item(this.mContext), null);
                holder = new ViewHolder();
                holder.title = (TextView)convertView.findViewById(Resources.id.search_result_title(this.mContext));
                holder.description = (TextView)convertView.findViewById(Resources.id.search_result_description(this.mContext));
                holder.openApp = (TextView)convertView.findViewById(Resources.id.search_result_open_app(this.mContext));
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            if (!StringUtil.isEmpty((String)SearchActivity.this.searchQuery.getTitleAttribute())) {
                holder.title.setText((CharSequence)Html.fromHtml((String)item.get(SearchActivity.this.searchQuery.getTitleAttribute()).toString()));
                holder.description.setVisibility(0);
                holder.description.setText((CharSequence)Html.fromHtml((String)SearchActivity.highlightStringMerge((Map)item.get("highlight_avoscloud_"))));
            } else {
                holder.title.setText((CharSequence)Html.fromHtml((String)SearchActivity.highlightStringMerge((Map)item.get("highlight_avoscloud_"))));
                holder.description.setVisibility(8);
            }
            if (!StringUtil.isEmpty((String)item.getString("app_url_avoscloud_"))) {
                holder.openApp.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Intent i = new Intent("android.intent.action.VIEW");
                        String link = StringUtil.isEmpty((String)item.getString("deep_link_avoscloud_")) ? item.getString("app_url_avoscloud_") : item.getString("deep_link_avoscloud_");
                        i.setData(Uri.parse((String)link));
                        SearchActivity.this.startActivity(i);
                    }
                });
            }
            return convertView;
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            this.lastVisibleItemId = firstVisibleItem + visibleItemCount;
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (this.lastVisibleItemId >= SearchActivity.this.searchResults.size() && scrollState == 0) {
                SearchActivity.this.showLoadingView();
                if (null != SearchActivity.this.searchQuery) {
                    SearchActivity.this.searchQuery.findInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver(SearchActivity.this.searchCallback));
                }
            } else {
                SearchActivity.this.hideLoadingView();
            }
        }
    }

    public class ViewHolder {
        TextView title;
        TextView description;
        TextView openApp;
    }
}

