/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite.ws;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

abstract class HeartBeatPolicy {
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private Future healthFuture;
    private long lastPongTS;
    private static final long HEART_BEAT_INTERNAL = 180000L;
    private static final long HEALTHY_THRESHOLD = 360000L;
    private Runnable healthMonitor = new Runnable(){

        @Override
        public void run() {
            if (System.currentTimeMillis() - HeartBeatPolicy.this.lastPongTS > 360000L) {
                HeartBeatPolicy.this.onTimeOut();
            } else {
                HeartBeatPolicy.this.sendPing();
            }
        }
    };

    HeartBeatPolicy() {
    }

    synchronized void onPong() {
        this.lastPongTS = System.currentTimeMillis();
    }

    synchronized void start() {
        this.stop();
        this.lastPongTS = System.currentTimeMillis();
        this.healthFuture = executor.scheduleAtFixedRate(this.healthMonitor, 180000L, 180000L, TimeUnit.MILLISECONDS);
    }

    synchronized void stop() {
        if (null != this.healthFuture) {
            this.healthFuture.cancel(true);
        }
    }

    public abstract void onTimeOut();

    public abstract void sendPing();
}

