/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite.ws;

import android.os.Build;
import android.util.Log;
import cn.leancloud.push.lite.AVOSCloud;
import cn.leancloud.push.lite.proto.CommandPacket;
import cn.leancloud.push.lite.utils.StringUtil;
import cn.leancloud.push.lite.ws.HeartBeatPolicy;
import cn.leancloud.push.lite.ws.WebSocketClientMonitor;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.PingFrame;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.protocols.IProtocol;
import org.java_websocket.protocols.Protocol;

public class AVStandardWebSocketClient
extends WebSocketClient {
    public static final String SUB_PROTOCOL_2_3 = "lc.protobuf2.3";
    private static final String HEADER_SUB_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final int PING_TIMEOUT_CODE = 3000;
    private static final String TAG = AVStandardWebSocketClient.class.getSimpleName();
    private SSLSocketFactory socketFactory;
    private HeartBeatPolicy heartBeatPolicy;
    private WebSocketClientMonitor socketClientMonitor;
    private static ArrayList<IProtocol> protocols = new ArrayList();

    public AVStandardWebSocketClient(URI serverUrl, final String subProtocol, boolean secEnabled, boolean sniEnabled, SSLSocketFactory socketFactory, int connectTimeout, WebSocketClientMonitor monitor) {
        super(serverUrl, (Draft)new Draft_6455(Collections.emptyList(), protocols), (Map)new HashMap<String, String>(){
            {
                this.put(AVStandardWebSocketClient.HEADER_SUB_PROTOCOL, subProtocol);
            }
        }, connectTimeout);
        this.socketFactory = socketFactory;
        this.heartBeatPolicy = new HeartBeatPolicy(){

            @Override
            public void onTimeOut() {
                AVStandardWebSocketClient.this.closeConnection(3000, "No response for ping");
            }

            @Override
            public void sendPing() {
                AVStandardWebSocketClient.this.ping();
            }
        };
        this.socketClientMonitor = monitor;
        if (secEnabled) {
            this.setSocket(sniEnabled);
        }
    }

    protected void ping() {
        PingFrame frame = new PingFrame();
        this.sendFrame((Framedata)frame);
    }

    private void setSocket(boolean sniEnabled) {
        block7: {
            try {
                String url = this.getURI().toString();
                if (StringUtil.isEmpty(url)) break block7;
                if (url.startsWith("wss") && null != this.socketFactory) {
                    Socket socket = this.socketFactory.createSocket();
                    if (sniEnabled && Build.VERSION.SDK_INT >= 24) {
                        try {
                            Class<?> sniHostnameClazz = Class.forName("javax.net.ssl.SNIHostName");
                            Class<?> sslSocketClazz = Class.forName("javax.net.ssl.SSLSocket");
                            if (null != sniHostnameClazz && null != sslSocketClazz && socket instanceof SSLSocket) {
                                SNIHostName serverName = new SNIHostName(this.getURI().getHost());
                                ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>(1);
                                serverNames.add(serverName);
                                SSLParameters params = ((SSLSocket)socket).getSSLParameters();
                                params.setServerNames(serverNames);
                                ((SSLSocket)socket).setSSLParameters(params);
                            }
                        }
                        catch (Exception ex) {
                            Log.w((String)"WebSocketClient", (String)ex.getMessage());
                        }
                    }
                    this.setSocket(socket);
                    break block7;
                }
                SocketFactory socketFactory = SocketFactory.getDefault();
                this.setSocket(socketFactory.createSocket());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onWebsocketPong(WebSocket conn, Framedata f) {
        super.onWebsocketPong(conn, f);
        this.heartBeatPolicy.onPong();
    }

    public void send(CommandPacket packet) {
        if (AVOSCloud.isDebugLogEnabled()) {
            Log.d((String)TAG, (String)("uplink : " + packet.getGenericCommand().toString()));
        }
        try {
            this.send(packet.getGenericCommand().toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onOpen(ServerHandshake var1) {
        this.heartBeatPolicy.start();
        if (null != this.socketClientMonitor) {
            this.socketClientMonitor.onOpen();
        }
    }

    public void onMessage(String var1) {
    }

    public void onMessage(ByteBuffer bytes) {
        if (null != this.socketClientMonitor) {
            this.socketClientMonitor.onMessage(bytes);
        }
    }

    public void onClose(int var1, String var2, boolean var3) {
        if (AVOSCloud.isDebugLogEnabled()) {
            Log.d((String)TAG, (String)("onClose code=" + var1 + ", message=" + var2));
        }
        this.heartBeatPolicy.stop();
        if (null != this.socketClientMonitor) {
            this.socketClientMonitor.onClose(var1, var2, var3);
        }
    }

    public void onError(Exception var1) {
        Log.w((String)TAG, (String)"onError ", (Throwable)var1);
        if (null != this.socketClientMonitor) {
            this.socketClientMonitor.onError(var1);
        }
    }

    static {
        protocols.add((IProtocol)new Protocol(SUB_PROTOCOL_2_3));
    }
}

