/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite.ws;

import cn.leancloud.push.lite.AVInstallation;
import cn.leancloud.push.lite.AVNotificationManager;
import cn.leancloud.push.lite.AVOSCloud;
import cn.leancloud.push.lite.proto.Messages;
import cn.leancloud.push.lite.proto.PushAckPacket;
import cn.leancloud.push.lite.ws.AVConnectionListener;
import cn.leancloud.push.lite.ws.AVConnectionManager;
import com.google.protobuf.ProtocolStringList;
import java.util.List;

public class AVPushMessageListener
implements AVConnectionListener {
    public static final String DEFAULT_ID = "leancloud_push_default_id";
    private static final AVPushMessageListener instance = new AVPushMessageListener();

    public static AVPushMessageListener getInstance() {
        return instance;
    }

    private AVPushMessageListener() {
    }

    @Override
    public void onWebSocketOpen() {
    }

    @Override
    public void onWebSocketClose() {
    }

    @Override
    public void onMessageArriving(String peerId, Integer requestKey, Messages.GenericCommand genericCommand) {
        if (null == genericCommand || null == genericCommand.getDataMessage()) {
            return;
        }
        switch (genericCommand.getCmd().getNumber()) {
            case 9: {
                Messages.DataCommand dataCommand = genericCommand.getDataMessage();
                this.processDataCommand(dataCommand);
                break;
            }
            case 21: {
                this.processGoawayCommand();
            }
        }
    }

    @Override
    public void onError(Integer requestKey, Messages.ErrorCommand errorCommand) {
        this.processGoawayCommand();
    }

    private void processDataCommand(Messages.DataCommand dataCommand) {
        ProtocolStringList messageIds = dataCommand.getIdsList();
        List<Messages.JsonObjectMessage> messages = dataCommand.getMsgList();
        for (int i = 0; i < messages.size() && i < messageIds.size(); ++i) {
            if (null == messages.get(i)) continue;
            AVNotificationManager.getInstance().processPushMessage(messages.get(i).getData(), (String)messageIds.get(i));
        }
        PushAckPacket pap = new PushAckPacket();
        pap.setInstallationId(AVInstallation.getCurrentInstallation().getInstallationId());
        pap.setMessageIds((List<String>)messageIds);
        AVConnectionManager.getInstance(AVOSCloud.applicationContext).sendPacket(pap);
    }

    private void processGoawayCommand() {
        AVConnectionManager.getInstance(AVOSCloud.applicationContext).cleanup();
        AVConnectionManager.getInstance(AVOSCloud.applicationContext).startConnection();
    }
}

