/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite.ws;

import android.content.Context;
import android.util.Log;
import cn.leancloud.push.lite.AVCallback;
import cn.leancloud.push.lite.AVException;
import cn.leancloud.push.lite.AVInstallation;
import cn.leancloud.push.lite.AVOSCloud;
import cn.leancloud.push.lite.proto.CommandPacket;
import cn.leancloud.push.lite.proto.LoginPacket;
import cn.leancloud.push.lite.proto.Messages;
import cn.leancloud.push.lite.rest.AVHttpClient;
import cn.leancloud.push.lite.utils.PacketAssembler;
import cn.leancloud.push.lite.utils.StringUtil;
import cn.leancloud.push.lite.ws.AVConnectionListener;
import cn.leancloud.push.lite.ws.AVPushMessageListener;
import cn.leancloud.push.lite.ws.AVStandardWebSocketClient;
import cn.leancloud.push.lite.ws.WebSocketClientMonitor;
import com.alibaba.fastjson.JSONObject;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AVConnectionManager
implements WebSocketClientMonitor {
    private static final String TAG = AVConnectionManager.class.getSimpleName();
    private static AVConnectionManager instance = null;
    private AVStandardWebSocketClient webSocketClient = null;
    private Object webSocketClientWatcher = new Object();
    private String currentRTMConnectionServer = null;
    private int retryConnectionCount = 0;
    private boolean connectionEstablished = false;
    private volatile boolean connecting = false;
    private volatile AVCallback pendingCallback = null;
    private Context context;
    private Map<String, AVConnectionListener> connectionListeners = new ConcurrentHashMap<String, AVConnectionListener>(1);

    public static synchronized AVConnectionManager getInstance(Context context) {
        if (instance == null) {
            instance = new AVConnectionManager(context, false);
        }
        return instance;
    }

    private AVConnectionManager(Context context, boolean autoConnection) {
        this.context = context;
        this.connectionListeners.put("leancloud_push_default_id", AVPushMessageListener.getInstance());
        if (autoConnection) {
            this.startConnection();
        }
    }

    private void resetConnectingStatus(boolean succeed) {
        this.connecting = false;
        if (null != this.pendingCallback) {
            if (succeed) {
                this.pendingCallback.internalDone(null);
            } else {
                this.pendingCallback.internalDone(new AVException(124, "network timeout."));
            }
        }
        this.pendingCallback = null;
    }

    private void reConnectionRTMServer() {
        ++this.retryConnectionCount;
        if (this.retryConnectionCount <= 3) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        long sleepMS = (long)Math.pow(2.0, AVConnectionManager.this.retryConnectionCount) * 1000L;
                        Thread.sleep(sleepMS);
                        if (AVOSCloud.isDebugLogEnabled()) {
                            Log.d((String)TAG, (String)("reConnect rtm server. count=" + AVConnectionManager.this.retryConnectionCount));
                        }
                        AVConnectionManager.this.startConnectionInternal();
                    }
                    catch (InterruptedException ex) {
                        Log.w((String)TAG, (String)"failed to start connection.", (Throwable)ex);
                    }
                }
            }).start();
        } else {
            Log.e((String)TAG, (String)("have tried " + (this.retryConnectionCount - 1) + " times, stop connecting..."));
            this.resetConnectingStatus(false);
        }
    }

    private String updateTargetServer(JSONObject rtmConnectionServerResponse) {
        String primaryServer = rtmConnectionServerResponse.getString("server");
        String secondary = rtmConnectionServerResponse.getString("secondary");
        this.currentRTMConnectionServer = StringUtil.isEmpty(this.currentRTMConnectionServer) || this.currentRTMConnectionServer.equalsIgnoreCase(secondary) ? primaryServer : secondary;
        return this.currentRTMConnectionServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWebSocketClient(String targetServer) {
        URI targetURI;
        if (AVOSCloud.isDebugLogEnabled()) {
            Log.d((String)TAG, (String)("try to connect server: " + targetServer));
        }
        SSLSocketFactory sf = null;
        try {
            SSLContext sslContext = SSLContext.getDefault();
            sf = sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException exception) {
            Log.e((String)TAG, (String)("failed to get SSLContext, cause: " + exception.getMessage()));
        }
        try {
            targetURI = URI.create(targetServer);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("failed to parse targetServer:" + targetServer + ", cause:" + ex.getMessage()));
            targetURI = null;
        }
        if (null == targetURI) {
            return;
        }
        Object object = this.webSocketClientWatcher;
        synchronized (object) {
            if (null != this.webSocketClient) {
                try {
                    this.webSocketClient.close();
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)"failed to close websocket client.", (Throwable)ex);
                }
                finally {
                    this.webSocketClient = null;
                }
            }
            int connectTimeout = 30000;
            this.webSocketClient = new AVStandardWebSocketClient(targetURI, "lc.protobuf2.3", true, true, sf, connectTimeout, this);
            this.webSocketClient.connect();
        }
    }

    public void startConnection(AVCallback callback) {
        if (this.connectionEstablished) {
            if (null != callback) {
                callback.internalDone(null);
            }
        } else if (this.connecting) {
            if (null != callback) {
                this.pendingCallback = callback;
            }
        } else {
            this.connecting = true;
            this.pendingCallback = callback;
            this.startConnectionInternal();
        }
    }

    public void startConnection() {
        this.startConnection(null);
    }

    private void startConnectionInternal() {
        String appId = AVOSCloud.applicationId;
        String installationId = AVInstallation.getCurrentInstallation(this.context).getInstallationId();
        AVHttpClient.getInstance().fetchPushWSServer(appId, installationId, 1, new Callback<JSONObject>(){

            public void onResponse(Call<JSONObject> call, Response<JSONObject> response) {
                JSONObject result = (JSONObject)response.body();
                if (null != result) {
                    String targetServer = AVConnectionManager.this.updateTargetServer(result);
                    AVConnectionManager.this.initWebSocketClient(targetServer);
                }
            }

            public void onFailure(Call<JSONObject> call, Throwable t) {
                Log.w((String)TAG, (String)"failed to fetch WebSocket Server.", (Throwable)t);
                AVConnectionManager.this.reConnectionRTMServer();
            }
        });
    }

    public void cleanup() {
        this.resetConnection();
        this.connectionListeners.clear();
        this.pendingCallback = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetConnection() {
        Object object = this.webSocketClientWatcher;
        synchronized (object) {
            if (null != this.webSocketClient) {
                try {
                    this.webSocketClient.closeConnection(1006, "Connectivity broken");
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)"failed to close websocket client.", (Throwable)ex);
                }
                finally {
                    this.webSocketClient = null;
                }
            }
        }
        this.connectionEstablished = false;
        this.retryConnectionCount = 0;
        this.connecting = false;
    }

    public void sendPacket(CommandPacket packet) {
        this.webSocketClient.send(packet);
    }

    public boolean isConnectionEstablished() {
        return this.connectionEstablished;
    }

    @Override
    public void onOpen() {
        if (AVOSCloud.isDebugLogEnabled()) {
            Log.d((String)TAG, (String)"webSocket established...");
        }
        this.connectionEstablished = true;
        this.retryConnectionCount = 0;
        for (AVConnectionListener listener : this.connectionListeners.values()) {
            listener.onWebSocketOpen();
        }
        this.resetConnectingStatus(true);
        LoginPacket lp = new LoginPacket();
        lp.setAppId(AVOSCloud.getApplicationId());
        lp.setInstallationId(AVInstallation.getCurrentInstallation(this.context).getInstallationId());
        this.sendPacket(lp);
    }

    @Override
    public void onClose(int var1, String var2, boolean var3) {
        if (AVOSCloud.isDebugLogEnabled()) {
            Log.d((String)TAG, (String)"webSocket closed...");
        }
        this.connectionEstablished = false;
        for (AVConnectionListener listener : this.connectionListeners.values()) {
            listener.onWebSocketClose();
        }
    }

    @Override
    public void onMessage(ByteBuffer bytes) {
        String peerId;
        Messages.GenericCommand command = PacketAssembler.getInstance().disassemblePacket(bytes);
        if (null == command) {
            return;
        }
        if (AVOSCloud.isDebugLogEnabled()) {
            Log.d((String)TAG, (String)("downlink: " + command.toString()));
        }
        if (StringUtil.isEmpty(peerId = command.getPeerId())) {
            peerId = "leancloud_push_default_id";
        }
        Integer requestKey = command.hasI() ? Integer.valueOf(command.getI()) : null;
        AVConnectionListener listener = this.connectionListeners.get(peerId);
        if (null != listener) {
            listener.onMessageArriving(peerId, requestKey, command);
        } else {
            Log.w((String)TAG, (String)("no peer subscribed message, ignore it. peerId=" + peerId + ", requestKey=" + requestKey));
        }
    }

    @Override
    public void onError(Exception exception) {
        this.connectionEstablished = false;
        this.reConnectionRTMServer();
        for (AVConnectionListener listener : this.connectionListeners.values()) {
            listener.onError(null, null);
        }
    }
}

