/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite.utils;

import android.util.Log;
import cn.leancloud.push.lite.proto.CommandPacket;
import cn.leancloud.push.lite.proto.Messages;
import cn.leancloud.push.lite.proto.PushAckPacket;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.util.List;

public class PacketAssembler {
    private static final String TAG = PacketAssembler.class.getSimpleName();
    private static PacketAssembler instance = new PacketAssembler();

    public static PacketAssembler getInstance() {
        return instance;
    }

    public CommandPacket assemblePushAckPacket(String installationId, List<String> messageIds) {
        PushAckPacket pushAckPacket = new PushAckPacket();
        pushAckPacket.setInstallationId(installationId);
        pushAckPacket.setMessageIds(messageIds);
        return pushAckPacket;
    }

    public Messages.GenericCommand disassemblePacket(ByteBuffer bytes) {
        try {
            return Messages.GenericCommand.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException ex) {
            Log.e((String)TAG, (String)"failed to disassemble packet.", (Throwable)ex);
            return null;
        }
    }
}

