/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import cn.leancloud.push.lite.AVOSCloud;
import cn.leancloud.push.lite.utils.StringUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AVPersistenceUtils {
    private static final String TAG = AVPersistenceUtils.class.getSimpleName();
    private static final String INSTALLATION = "installation";
    private static AVPersistenceUtils instance = null;
    private static String currentAppPrefix = "";
    private static ConcurrentHashMap<String, ReentrantReadWriteLock> fileLocks = new ConcurrentHashMap();

    public static ReentrantReadWriteLock getLock(String path) {
        ReentrantReadWriteLock oldLock;
        ReentrantReadWriteLock lock = fileLocks.get(path);
        if (lock == null && (oldLock = fileLocks.putIfAbsent(path, lock = new ReentrantReadWriteLock())) != null) {
            lock = oldLock;
        }
        return lock;
    }

    public static void removeLock(String path) {
        fileLocks.remove(path);
    }

    private AVPersistenceUtils() {
    }

    public static synchronized AVPersistenceUtils sharedInstance() {
        if (instance == null) {
            instance = new AVPersistenceUtils();
        }
        return instance;
    }

    public static void initAppInfo(String appId, Context ctx) {
        boolean ret;
        if (StringUtil.isEmpty(appId) || null == ctx) {
            return;
        }
        currentAppPrefix = appId.substring(0, 8);
        File oldInstallationFile = AVPersistenceUtils.getInstallationFile_old(ctx);
        File newInstallationFile = AVPersistenceUtils.getInstallationFile(ctx);
        if (oldInstallationFile.exists() && !newInstallationFile.exists() && !(ret = oldInstallationFile.renameTo(newInstallationFile))) {
            Log.w((String)TAG, (String)("failed to rename installation file. old=" + oldInstallationFile.getAbsolutePath() + ", new=" + newInstallationFile.getAbsolutePath()));
        }
    }

    public static String getCurrentAppPrefix() {
        return currentAppPrefix;
    }

    public static File getInstallationFile(Context ctx) {
        return new File(AVPersistenceUtils.getFilesDir(ctx), currentAppPrefix + INSTALLATION);
    }

    private static File getInstallationFile_old(Context ctx) {
        return new File(AVPersistenceUtils.getFilesDir(ctx), INSTALLATION);
    }

    private static File getFilesDir(Context ctx) {
        Context validContext;
        Context context = validContext = null != ctx ? ctx : AVOSCloud.applicationContext;
        if (validContext == null) {
            throw new IllegalStateException("applicationContext is null, Please call AVOSCloud.initialize first");
        }
        return validContext.getFilesDir();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean saveContentToFile(String content, File fileForSave) {
        try {
            return AVPersistenceUtils.saveContentToFile(content.getBytes("utf-8"), fileForSave);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveContentToFile(byte[] content, File fileForSave) {
        ReentrantReadWriteLock.WriteLock writeLock = AVPersistenceUtils.getLock(fileForSave.getAbsolutePath()).writeLock();
        boolean succeed = true;
        FileOutputStream out = null;
        if (writeLock.tryLock()) {
            try {
                out = new FileOutputStream(fileForSave, false);
                out.write(content);
            }
            catch (Exception e) {
                e.printStackTrace();
                succeed = false;
            }
            finally {
                if (out != null) {
                    AVPersistenceUtils.closeQuietly(out);
                }
                writeLock.unlock();
            }
        }
        return succeed;
    }

    public static String readContentFromFile(File fileForRead) {
        byte[] data = AVPersistenceUtils.readContentBytesFromFile(fileForRead);
        if (data == null || data.length == 0) {
            return "";
        }
        return new String(data);
    }

    public static InputStream getInputStreamFromFile(File fileForRead) throws IOException {
        if (fileForRead == null) {
            return null;
        }
        if (!fileForRead.exists() || !fileForRead.isFile()) {
            return null;
        }
        return new BufferedInputStream(new FileInputStream(fileForRead), 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readContentBytesFromFile(File fileForRead) {
        if (fileForRead == null) {
            return null;
        }
        if (!fileForRead.exists() || !fileForRead.isFile()) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = AVPersistenceUtils.getLock(fileForRead.getAbsolutePath()).readLock();
        readLock.lock();
        byte[] data = null;
        BufferedInputStream input = null;
        try {
            data = new byte[(int)fileForRead.length()];
            int totalBytesRead = 0;
            input = new BufferedInputStream(new FileInputStream(fileForRead), 8192);
            while (totalBytesRead < data.length) {
                int bytesRemaining = data.length - totalBytesRead;
                int bytesRead = ((InputStream)input).read(data, totalBytesRead, bytesRemaining);
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
            }
            byte[] byArray = data;
            AVPersistenceUtils.closeQuietly(input);
            readLock.unlock();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            AVPersistenceUtils.closeQuietly(input);
            readLock.unlock();
        }
        return null;
    }

    public void savePersistentSettingBoolean(String keyzone, String key, Boolean value) {
        if (AVOSCloud.applicationContext == null) {
            return;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean(key, value.booleanValue());
        editor.commit();
    }

    public boolean getPersistentSettingBoolean(String keyzone, String key) {
        return this.getPersistentSettingBoolean(keyzone, key, false);
    }

    public Map<String, ?> getPersistentSetting(String keyzone) {
        if (AVOSCloud.applicationContext == null) {
            return null;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        return settings.getAll();
    }

    public boolean getPersistentSettingBoolean(String keyzone, String key, Boolean defaultValue) {
        if (AVOSCloud.applicationContext == null) {
            return defaultValue;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        return settings.getBoolean(key, defaultValue.booleanValue());
    }

    public void savePersistentSettingInteger(String keyzone, String key, Integer value) {
        if (AVOSCloud.applicationContext == null) {
            return;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt(key, value.intValue());
        editor.commit();
    }

    public Integer getPersistentSettingInteger(String keyzone, String key, Integer defaultValue) {
        if (AVOSCloud.applicationContext == null) {
            return defaultValue;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        return settings.getInt(key, defaultValue.intValue());
    }

    public void savePersistentSettingLong(String keyzone, String key, Long value) {
        if (AVOSCloud.applicationContext == null) {
            return;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putLong(key, value.longValue());
        editor.commit();
    }

    public Long getPersistentSettingLong(String keyzone, String key, Long defaultValue) {
        if (AVOSCloud.applicationContext == null) {
            return defaultValue;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        return settings.getLong(key, defaultValue.longValue());
    }

    public void savePersistentSettingString(String keyzone, String key, String value) {
        if (AVOSCloud.applicationContext == null) {
            return;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public String getPersistentSettingString(String keyzone, String key, String defaultValue) {
        if (AVOSCloud.applicationContext == null) {
            return defaultValue;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        return settings.getString(key, defaultValue);
    }

    public void removePersistentSettingString(String keyzone, String key) {
        if (null == AVOSCloud.applicationContext) {
            return;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.remove(key);
        editor.commit();
    }

    public String removePersistentSettingString(String keyzone, String key, String defaultValue) {
        if (null == AVOSCloud.applicationContext) {
            return defaultValue;
        }
        String currentValue = this.getPersistentSettingString(keyzone, key, defaultValue);
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.remove(key);
        editor.commit();
        return currentValue;
    }

    public void removeKeyZonePersistentSettings(String keyzone) {
        if (null == AVOSCloud.applicationContext) {
            return;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.clear();
        editor.commit();
    }
}

