/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite.rest;

import cn.leancloud.push.lite.PushRouterManager;
import cn.leancloud.push.lite.rest.AppRouterAPI;
import cn.leancloud.push.lite.rest.LoggingInterceptor;
import cn.leancloud.push.lite.rest.PushRestAPI;
import cn.leancloud.push.lite.rest.PushRouterRestAPI;
import cn.leancloud.push.lite.rest.RequestPaddingInterceptor;
import cn.leancloud.push.lite.utils.StringUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.fastjson.FastJsonConverterFactory;

public class AVHttpClient {
    private static final String DEFAULT_APP_ROUTER = "https://app-router.leancloud.cn/";
    private static OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)new LoggingInterceptor()).addInterceptor((Interceptor)new RequestPaddingInterceptor()).build();
    private static Retrofit appRouterRetrofit = new Retrofit.Builder().baseUrl("https://app-router.leancloud.cn/").addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).client(okHttpClient).build();
    private static AppRouterAPI appRouterAPI = (AppRouterAPI)appRouterRetrofit.create(AppRouterAPI.class);
    private Retrofit pushRouterRetrofit;
    private PushRouterRestAPI pushRouterAPI;
    private Retrofit pushAPIRetrofit;
    private PushRestAPI pushAPI;
    private volatile boolean initialized = false;
    private static AVHttpClient gInstance = new AVHttpClient();
    private String currentPushAPIServer = "";
    private String currentPushRouterServer = "";

    public static AVHttpClient getInstance() {
        return gInstance;
    }

    private AVHttpClient() {
    }

    public synchronized void initialize(String pushAPIServer, String pushRouterServer) {
        if (this.initialized) {
            return;
        }
        this.createRetrofitClient(pushAPIServer, pushRouterServer);
        this.initialized = true;
    }

    private void createRetrofitClient(String pushAPIServer, String pushRouterServer) {
        if (!StringUtil.isEmpty(pushAPIServer) && !this.currentPushAPIServer.equals(pushAPIServer)) {
            this.pushRouterRetrofit = new Retrofit.Builder().baseUrl(pushRouterServer).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).client(okHttpClient).build();
            this.pushRouterAPI = (PushRouterRestAPI)this.pushRouterRetrofit.create(PushRouterRestAPI.class);
            this.currentPushAPIServer = pushAPIServer;
        }
        if (!StringUtil.isEmpty(pushRouterServer) && !this.currentPushRouterServer.equals(pushRouterServer)) {
            this.pushAPIRetrofit = new Retrofit.Builder().baseUrl(pushAPIServer).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).client(okHttpClient).build();
            this.pushAPI = (PushRestAPI)this.pushAPIRetrofit.create(PushRestAPI.class);
            this.currentPushRouterServer = pushRouterServer;
        }
    }

    private synchronized void makeSurePushRetrofit() {
        if (this.initialized) {
            return;
        }
        String pushAPIServer = PushRouterManager.getInstance().getPushAPIServer();
        String pushRouterServer = PushRouterManager.getInstance().getPushRouterServer();
        this.createRetrofitClient(pushAPIServer, pushRouterServer);
    }

    public static void fetchAccessServers(String appId, Callback<JSONObject> callback) {
        Objects.requireNonNull(appId);
        Objects.requireNonNull(callback);
        Call<JSONObject> call = appRouterAPI.findServers(appId);
        call.enqueue(callback);
    }

    public void fetchPushWSServer(String appId, String installationId, int secure, Callback<JSONObject> callback) {
        Objects.requireNonNull(appId);
        Objects.requireNonNull(callback);
        this.makeSurePushRetrofit();
        Call<JSONObject> call = this.pushRouterAPI.getWSServer(appId, installationId, secure);
        call.enqueue(callback);
    }

    public void saveInstallation(JSONObject param, boolean fetchWhenSave, Callback<JSONObject> callback) {
        Objects.requireNonNull(param);
        Objects.requireNonNull(callback);
        this.makeSurePushRetrofit();
        Call<JSONObject> call = this.pushAPI.saveInstallation(param, fetchWhenSave);
        call.enqueue(callback);
    }

    public void findInstallation(String installationId, Callback<JSONObject> callback) {
        Objects.requireNonNull(installationId);
        Objects.requireNonNull(callback);
        this.makeSurePushRetrofit();
        Call<JSONObject> call = this.pushAPI.findInstallation(installationId);
        call.enqueue(callback);
    }
}

