/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import cn.leancloud.push.lite.AVCallback;
import cn.leancloud.push.lite.AVConnectivityListener;
import cn.leancloud.push.lite.AVConnectivityReceiver;
import cn.leancloud.push.lite.AVException;
import cn.leancloud.push.lite.AVInstallation;
import cn.leancloud.push.lite.AVNotificationManager;
import cn.leancloud.push.lite.AVOSCloud;
import cn.leancloud.push.lite.AVShutdownListener;
import cn.leancloud.push.lite.AVShutdownReceiver;
import cn.leancloud.push.lite.NotifyUtil;
import cn.leancloud.push.lite.utils.StringUtil;
import cn.leancloud.push.lite.ws.AVConnectionManager;
import java.util.Arrays;
import java.util.List;

public class PushService
extends Service {
    private static final String TAG = PushService.class.getSimpleName();
    static final String AV_PUSH_SERVICE_APPLICATION_ID = "AV_APPLICATION_ID";
    static final String AV_PUSH_SERVICE_DEFAULT_CALLBACK = "AV_DEFAULT_CALLBACK";
    static final String SERVICE_RESTART_ACTION = "com.avos.avoscloud.notify.action";
    private static boolean isNeedNotifyApplication = true;
    private AVConnectionManager connectionManager = null;
    private static Object connecting = new Object();
    private static volatile boolean isStarted = false;
    private static boolean isAutoWakeUp = true;
    AVConnectivityReceiver connectivityReceiver;
    AVShutdownReceiver shutdownReceiver;
    public static String DefaultChannelId = "";
    private static Handler _installationSaveHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message m) {
            AVInstallation.getCurrentInstallation().saveInBackground(new AVCallback<Void>(){

                @Override
                protected void internalDone0(Void aVoid, AVException avException) {
                    if (null != avException) {
                        Log.w((String)TAG, (String)("failed to save Installation. cause: " + avException.getMessage()));
                    }
                }
            });
        }
    };

    public void onCreate() {
        super.onCreate();
        Log.d((String)TAG, (String)"PushServer#onCreate");
        this.connectionManager = AVConnectionManager.getInstance((Context)this);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean connected = PushService.this.isConnected();
                if (connected && !PushService.this.connectionManager.isConnectionEstablished()) {
                    Log.d((String)TAG, (String)"networking is fine and try to start connection to leancloud.");
                    Object object = connecting;
                    synchronized (object) {
                        PushService.this.connectionManager.startConnection(new AVCallback<Integer>(){

                            @Override
                            protected void internalDone0(Integer resultCode, AVException exception) {
                                if (null == exception) {
                                    Log.d((String)TAG, (String)"succeed to establish connection.");
                                } else {
                                    Log.w((String)TAG, (String)"failed to start connection. cause:", (Throwable)exception);
                                }
                            }
                        });
                    }
                }
            }
        }).start();
        this.connectivityReceiver = new AVConnectivityReceiver(new AVConnectivityListener(){
            private volatile boolean connectEstablished = false;

            @Override
            public void onMobile(Context context) {
                this.connectEstablished = true;
                PushService.this.connectionManager.startConnection();
                Log.d((String)TAG, (String)"Connection resumed with Mobile...");
            }

            @Override
            public void onWifi(Context context) {
                this.connectEstablished = true;
                PushService.this.connectionManager.startConnection();
                Log.d((String)TAG, (String)"Connection resumed with Wifi...");
            }

            @Override
            public void onOtherConnected(Context context) {
                Log.d((String)TAG, (String)"Connectivity resumed with Others");
                this.connectEstablished = true;
                PushService.this.connectionManager.startConnection();
            }

            @Override
            public void onNotConnected(Context context) {
                if (!this.connectEstablished) {
                    Log.d((String)TAG, (String)"Connectivity isn't established yet.");
                    return;
                }
                Log.d((String)TAG, (String)"Connectivity broken");
                this.connectEstablished = false;
            }
        });
        this.registerReceiver(this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.shutdownReceiver = new AVShutdownReceiver(new AVShutdownListener(){

            @Override
            public void onShutdown(Context context) {
                PushService.this.connectionManager.cleanup();
            }
        });
        this.registerReceiver(this.shutdownReceiver, new IntentFilter("android.intent.action.ACTION_SHUTDOWN"));
        isStarted = true;
    }

    @TargetApi(value=24)
    private boolean isConnected() {
        return PushService.isConnected((Context)this);
    }

    @TargetApi(value=24)
    private static boolean isConnected(Context context) {
        try {
            int hasPermission = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
            if (0 != hasPermission) {
                Log.w((String)TAG, (String)"android.Manifest.permission.ACCESS_NETWORK_STATE is not granted.");
            } else {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (null != networkInfo && networkInfo.isConnected()) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            Log.w((String)TAG, (String)"failed to detect networking status.", (Throwable)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=5)
    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d((String)TAG, (String)"PushService#onStartCommand");
        this.notifyOtherApplication(null != intent ? intent.getAction() : null);
        boolean connected = this.isConnected();
        if (connected && !this.connectionManager.isConnectionEstablished()) {
            if (AVOSCloud.isDebugLogEnabled()) {
                Log.d((String)TAG, (String)"networking is fine and try to start connection to leancloud.");
            }
            Object object = connecting;
            synchronized (object) {
                this.connectionManager.startConnection(new AVCallback<Integer>(){

                    @Override
                    protected void internalDone0(Integer resultCode, AVException exception) {
                        if (null == exception) {
                            Log.d((String)TAG, (String)"succeed to establish connection.");
                        } else {
                            Log.w((String)TAG, (String)"failed to start connection. cause:", (Throwable)exception);
                        }
                    }
                });
            }
        }
        return 1;
    }

    public void onDestroy() {
        Log.d((String)TAG, (String)"PushService#onDestroy");
        this.connectionManager.cleanup();
        this.unregisterReceiver(this.connectivityReceiver);
        this.unregisterReceiver(this.shutdownReceiver);
        isStarted = false;
        if (isAutoWakeUp && Build.VERSION.SDK_INT <= 25) {
            try {
                Intent i = new Intent(AVOSCloud.getContext(), PushService.class);
                i.addFlags(0x10000000);
                this.startService(i);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("failed to start PushService. cause: " + ex.getMessage()));
            }
        }
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        Log.d((String)TAG, (String)"PushService#onBind");
        return null;
    }

    @TargetApi(value=14)
    public void onTaskRemoved(Intent rootIntent) {
        Log.d((String)TAG, (String)"try to restart service on task Removed");
        if (isAutoWakeUp) {
            Intent restartServiceIntent = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
            restartServiceIntent.setPackage(this.getPackageName());
            PendingIntent restartServicePendingIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)restartServiceIntent, (int)0x8000000);
            AlarmManager alarmService = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
            alarmService.set(3, SystemClock.elapsedRealtime() + 500L, restartServicePendingIntent);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            super.onTaskRemoved(rootIntent);
        }
    }

    public static synchronized void subscribe(Context context, String channel, Class<? extends Activity> cls) {
        PushService.startServiceIfRequired(context, cls);
        String finalChannel = channel;
        AVInstallation.getCurrentInstallation().addUnique("channels", finalChannel);
        _installationSaveHandler.sendMessage(Message.obtain());
        if (cls != null) {
            AVNotificationManager manager = AVNotificationManager.getInstance();
            manager.addDefaultPushCallback(channel, cls.getName());
            if (manager.getDefaultPushCallback(AVOSCloud.getApplicationId()) == null) {
                manager.addDefaultPushCallback(AVOSCloud.getApplicationId(), cls.getName());
            }
        }
    }

    public static void setNotificationIcon(int icon) {
        AVNotificationManager.getInstance().setNotificationIcon(icon);
    }

    public static void startIfRequired(Context context) {
        PushService.startServiceIfRequired(context, null);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls) {
        Log.d((String)TAG, (String)("setDefaultPushCallback cls=" + cls.getName()));
        PushService.startServiceIfRequired(context, cls);
        AVNotificationManager.getInstance().addDefaultPushCallback(AVOSCloud.getApplicationId(), cls.getName());
    }

    public static void setAutoWakeUp(boolean isAutoWakeUp) {
        PushService.isAutoWakeUp = isAutoWakeUp;
    }

    @TargetApi(value=26)
    public static void setDefaultChannelId(Context context, String channelId) {
        DefaultChannelId = channelId;
        if (Build.VERSION.SDK_INT <= 25) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            String name = context.getPackageName();
            String description = "PushNotification";
            int importance = 3;
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)name, importance);
            channel.setDescription(description);
            notificationManager.createNotificationChannel(channel);
        }
        catch (Exception ex) {
            Log.w((String)TAG, (String)"failed to create NotificationChannel, then perhaps PushNotification doesn't work well on Android O and newer version.");
        }
    }

    public static synchronized void unsubscribe(Context context, String channel) {
        if (channel == null) {
            return;
        }
        AVNotificationManager.getInstance().removeDefaultPushCallback(channel);
        final String finalChannel = channel;
        if (StringUtil.isEmpty(AVInstallation.getCurrentInstallation().getObjectId())) {
            AVInstallation.getCurrentInstallation().saveInBackground(new AVCallback<Void>(){

                @Override
                protected void internalDone0(Void aVoid, AVException avException) {
                    if (null != avException) {
                        Log.w((String)TAG, (Throwable)avException);
                    } else {
                        AVInstallation.getCurrentInstallation().removeAll("channels", Arrays.asList(finalChannel));
                        _installationSaveHandler.sendMessage(Message.obtain());
                    }
                }
            });
        } else {
            AVInstallation.getCurrentInstallation().removeAll("channels", Arrays.asList(finalChannel));
            _installationSaveHandler.sendMessage(Message.obtain());
        }
    }

    private static void startServiceIfRequired(Context context, Class<? extends Activity> cls) {
        if (isStarted) {
            return;
        }
        if (context == null) {
            Log.e((String)TAG, (String)"context is null");
            return;
        }
        if (0 != context.checkCallingOrSelfPermission("android.permission.INTERNET")) {
            Log.e((String)TAG, (String)"Please add <uses-permission android:name=\"android.permission.INTERNET\"/> in your AndroidManifest file");
            return;
        }
        if (!PushService.isPushServiceAvailable(context, PushService.class)) {
            Log.e((String)TAG, (String)"Please add <service android:name=\"cn.leancloud.push.lite.PushService\"/> in your AndroidManifest file");
            return;
        }
        PushService.startService(context, cls);
    }

    private static boolean isPushServiceAvailable(Context context, Class cls) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent(context, cls), 65536);
        return resolveInfo.size() > 0;
    }

    private static synchronized void startService(final Context context, final Class cls) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"Start service");
                try {
                    Intent intent = new Intent(context, PushService.class);
                    intent.putExtra(PushService.AV_PUSH_SERVICE_APPLICATION_ID, AVOSCloud.getApplicationId());
                    if (cls != null) {
                        intent.putExtra(PushService.AV_PUSH_SERVICE_DEFAULT_CALLBACK, cls.getName());
                    }
                    context.startService(intent);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("failed to start PushService. cause: " + ex.getMessage()));
                }
            }
        }).start();
    }

    private void notifyOtherApplication(String action) {
        block4: {
            if (isNeedNotifyApplication && !SERVICE_RESTART_ACTION.equals(action)) {
                isNeedNotifyApplication = false;
                try {
                    ServiceInfo info = this.getApplicationContext().getPackageManager().getServiceInfo(new ComponentName(this.getApplicationContext(), PushService.class), 0);
                    if (info.exported) {
                        NotifyUtil.notifyHandler.sendEmptyMessage(1024);
                    }
                }
                catch (Exception e) {
                    if (!AVOSCloud.isDebugLogEnabled()) break block4;
                    Log.d((String)TAG, (String)("failed to call notifyOtherApplication. cause: " + e.getMessage()));
                }
            }
        }
    }
}

