/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite;

import android.util.Log;
import cn.leancloud.push.lite.AVCallback;
import cn.leancloud.push.lite.AVException;
import cn.leancloud.push.lite.AVOSCloud;
import cn.leancloud.push.lite.rest.AVHttpClient;
import cn.leancloud.push.lite.utils.AVPersistenceUtils;
import cn.leancloud.push.lite.utils.StringUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PushRouterManager {
    private static final String TAG = PushRouterManager.class.getSimpleName();
    private static final String CN_EAST_PUSH_API_SERVER_FORMAT = "https://%s.push.lncldapi.com";
    private static final String CN_NOTRH_PUSH_API_SERVER_FORMAT = "https://%s.push.lncld.net";
    private static final String US_PUSH_API_SERVER_FORMAT = "https://%s.push.lncldglobal.com";
    private static final String CN_EAST_PUSH_ROUTER_SERVER_FORMAT = "https://%s.rtm.lncldapi.com";
    private static final String CN_NOTRH_PUSH_ROUTER_SERVER_FORMAT = "https://%s.rtm.lncld.net";
    private static final String US_PUSH_ROUTER_SERVER_FORMAT = "https://%s.rtm.lncldglobal.com";
    private static final String RTM_ROUTER_SERVRE_KEY = "rtm_router_server";
    private static final String PUSH_SERVRE_KEY = "push_server";
    private static final String TTL_KEY = "ttl";
    private static final String LATEST_UPDATE_TIME_KEY = "latest_update_time";
    private Map<String, String> apiMaps = new ConcurrentHashMap<String, String>();
    private static Map<String, String> customApiMaps = new ConcurrentHashMap<String, String>();
    private static PushRouterManager pushRouterManager;

    public static PushRouterManager getInstance() {
        if (null == pushRouterManager) {
            pushRouterManager = new PushRouterManager();
        }
        return pushRouterManager;
    }

    private PushRouterManager() {
        String appidPrefix = AVPersistenceUtils.getCurrentAppPrefix();
        String defaultPushServer = "";
        String defaultPushRouterServer = "";
        if (StringUtil.isEmpty(appidPrefix)) {
            Log.w((String)TAG, (String)"invalid appId. AVOSCloud#initialize should be invoke at first!!");
        } else if (AVOSCloud.getRegion() == AVOSCloud.REGION.NorthAmerica) {
            defaultPushRouterServer = String.format(US_PUSH_ROUTER_SERVER_FORMAT, appidPrefix);
            defaultPushServer = String.format(US_PUSH_API_SERVER_FORMAT, appidPrefix);
        } else if (AVOSCloud.getRegion() == AVOSCloud.REGION.NorthChina) {
            defaultPushRouterServer = String.format(CN_NOTRH_PUSH_ROUTER_SERVER_FORMAT, appidPrefix);
            defaultPushServer = String.format(CN_NOTRH_PUSH_API_SERVER_FORMAT, appidPrefix);
        } else if (AVOSCloud.getRegion() == AVOSCloud.REGION.EastChina) {
            defaultPushRouterServer = String.format(CN_EAST_PUSH_ROUTER_SERVER_FORMAT, appidPrefix);
            defaultPushServer = String.format(CN_EAST_PUSH_API_SERVER_FORMAT, appidPrefix);
        } else {
            Log.w((String)TAG, (String)("invalid REGION:" + (Object)((Object)AVOSCloud.getRegion())));
        }
        if (!StringUtil.isEmpty(defaultPushServer)) {
            this.apiMaps.put(AVOSCloud.SERVER_TYPE.PUSH.name, defaultPushServer);
        }
        if (!StringUtil.isEmpty(defaultPushRouterServer)) {
            this.apiMaps.put(AVOSCloud.SERVER_TYPE.RTM.name, defaultPushRouterServer);
        }
    }

    static void setServer(AVOSCloud.SERVER_TYPE server, String host) {
        customApiMaps.put(server.name, host);
    }

    public String getPushAPIServer() {
        String result = customApiMaps.get(AVOSCloud.SERVER_TYPE.PUSH.name);
        if (StringUtil.isEmpty(result)) {
            result = this.apiMaps.get(AVOSCloud.SERVER_TYPE.PUSH.name);
        }
        return result;
    }

    public String getPushRouterServer() {
        String result = customApiMaps.get(AVOSCloud.SERVER_TYPE.RTM.name);
        if (StringUtil.isEmpty(result)) {
            result = this.apiMaps.get(AVOSCloud.SERVER_TYPE.RTM.name);
        }
        return result;
    }

    public void updateRtmRouterServer(String router, boolean persistence) {
        this.apiMaps.put(AVOSCloud.SERVER_TYPE.RTM.name, this.addHttpsPrefix(router));
        if (persistence) {
            AVPersistenceUtils.sharedInstance().savePersistentSettingString(this.getAppRouterSPName(), RTM_ROUTER_SERVRE_KEY, this.apiMaps.get(AVOSCloud.SERVER_TYPE.RTM.name));
        }
    }

    void fetchRouter(boolean force) {
        this.fetchRouter(force, null);
    }

    void fetchRouter(boolean force, final AVCallback<Void> callback) {
        if (force || this.apiMaps.size() < 1) {
            String pushServer;
            String keyZone = this.getAppRouterSPName();
            AVPersistenceUtils persistenceUtils = AVPersistenceUtils.sharedInstance();
            String routerServer = persistenceUtils.getPersistentSettingString(keyZone, RTM_ROUTER_SERVRE_KEY, "");
            if (!StringUtil.isEmpty(routerServer)) {
                this.apiMaps.put(AVOSCloud.SERVER_TYPE.RTM.name, routerServer);
            }
            if (!StringUtil.isEmpty(pushServer = persistenceUtils.getPersistentSettingString(keyZone, PUSH_SERVRE_KEY, ""))) {
                this.apiMaps.put(AVOSCloud.SERVER_TYPE.PUSH.name, pushServer);
            }
            Long lastTime = persistenceUtils.getPersistentSettingLong(keyZone, LATEST_UPDATE_TIME_KEY, 0L);
            int ttl = persistenceUtils.getPersistentSettingInteger(keyZone, TTL_KEY, 0);
            if (force || System.currentTimeMillis() - lastTime > (long)(ttl * 1000)) {
                if (AVOSCloud.isDebugLogEnabled()) {
                    Log.d((String)TAG, (String)"begin to fetch app router.");
                }
                AVHttpClient.fetchAccessServers(AVOSCloud.applicationId, new Callback<JSONObject>(){

                    public void onResponse(Call<JSONObject> call, Response<JSONObject> response) {
                        JSONObject result = (JSONObject)response.body();
                        PushRouterManager.this.saveRouterResult(result);
                        if (AVOSCloud.isDebugLogEnabled()) {
                            Log.d((String)TAG, (String)("fetch app router result: " + result.toJSONString()));
                        }
                        if (null != callback) {
                            callback.internalDone(null);
                        }
                    }

                    public void onFailure(Call<JSONObject> call, Throwable t) {
                        Log.w((String)TAG, (String)"failed to fetch app router. cause: ", (Throwable)t);
                        if (null != callback) {
                            callback.internalDone(new AVException(t));
                        }
                    }
                });
            } else if (null != callback) {
                callback.internalDone(null);
            }
        } else if (null != callback) {
            callback.internalDone(null);
        }
    }

    private void saveRouterResult(JSONObject response) {
        if (null != response) {
            AVPersistenceUtils persistenceUtils = AVPersistenceUtils.sharedInstance();
            this.updateMapAndSaveLocal(persistenceUtils, this.apiMaps, response, AVOSCloud.SERVER_TYPE.RTM.name, RTM_ROUTER_SERVRE_KEY);
            this.updateMapAndSaveLocal(persistenceUtils, this.apiMaps, response, AVOSCloud.SERVER_TYPE.PUSH.name, PUSH_SERVRE_KEY);
            if (response.containsKey((Object)TTL_KEY)) {
                persistenceUtils.savePersistentSettingInteger(this.getAppRouterSPName(), TTL_KEY, response.getIntValue(TTL_KEY));
            }
            persistenceUtils.savePersistentSettingLong(this.getAppRouterSPName(), LATEST_UPDATE_TIME_KEY, System.currentTimeMillis());
        }
    }

    private void updateMapAndSaveLocal(AVPersistenceUtils persistenceUtils, Map<String, String> maps, JSONObject jsonObject, String mapKey, String jsonKey) {
        if (jsonObject.containsKey((Object)jsonKey)) {
            String value = this.addHttpsPrefix(jsonObject.getString(jsonKey));
            persistenceUtils.savePersistentSettingString(this.getAppRouterSPName(), jsonKey, value);
            if (!StringUtil.isEmpty(value)) {
                maps.put(mapKey, value);
            }
        }
    }

    private String getAppRouterSPName() {
        return "com.avos.avoscloud.approuter." + AVOSCloud.applicationId;
    }

    private String addHttpsPrefix(String url) {
        if (!StringUtil.isEmpty(url) && !url.startsWith("http")) {
            return "https://" + url;
        }
        return url;
    }
}

