/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite;

import android.content.Intent;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import cn.leancloud.push.lite.AVOSCloud;
import cn.leancloud.push.lite.PushService;
import cn.leancloud.push.lite.utils.AVPersistenceUtils;
import cn.leancloud.push.lite.utils.Base64Decoder;
import cn.leancloud.push.lite.utils.Base64Encoder;
import cn.leancloud.push.lite.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class NotifyUtil {
    private static final String TAG = NotifyUtil.class.getSimpleName();
    protected static HandlerThread thread = new HandlerThread("com.avos.avoscloud.notify");
    static final int SERVICE_RESTART = 1024;
    static final String SERVICE_RESTART_ACTION = "com.avos.avoscloud.notify.action";
    static Handler notifyHandler;

    private static void registerApp() {
        Set<String> appSet = NotifyUtil.getRegisteredApps();
        if (appSet != null) {
            appSet.add(Base64Encoder.encode(AVOSCloud.applicationContext.getPackageName()));
            AVPersistenceUtils.sharedInstance();
            AVPersistenceUtils.saveContentToFile(JSON.toJSONString(appSet), NotifyUtil.getRegisterAppsFile());
        }
    }

    private static Set<String> getRegisteredApps() {
        if (AVOSCloud.applicationContext == null) {
            return null;
        }
        File registerFile = NotifyUtil.getRegisterAppsFile();
        HashSet<String> appSet = new HashSet<String>();
        if (registerFile.exists()) {
            AVPersistenceUtils.sharedInstance();
            String registerApps = AVPersistenceUtils.readContentFromFile(registerFile);
            if (!StringUtil.isEmpty(registerApps)) {
                block5: {
                    try {
                        appSet.addAll((Collection)JSON.parseObject((String)registerApps, Set.class));
                    }
                    catch (Exception e) {
                        if (!AVOSCloud.showInternalDebugLog()) break block5;
                        Log.e((String)TAG, (String)"getRegisteredApps", (Throwable)e);
                    }
                }
                return appSet;
            }
        }
        return appSet;
    }

    private static File getRegisterAppsFile() {
        File file = new File(Environment.getExternalStorageDirectory() + "/Android/data/leancloud/", "dontpanic.cp");
        if (file.exists()) {
            return file;
        }
        File folder = new File(Environment.getExternalStorageDirectory() + "/Android/data/leancloud/");
        folder.mkdirs();
        return file;
    }

    static {
        thread.start();
        notifyHandler = new Handler(thread.getLooper()){

            public void handleMessage(Message m) {
                if (m.what == 1024 && AVOSCloud.applicationContext != null) {
                    this.removeMessages(1024);
                    try {
                        Set registeredApps = NotifyUtil.getRegisteredApps();
                        for (String encodedAppPackage : registeredApps) {
                            String appPackage = Base64Decoder.decode(encodedAppPackage);
                            if (AVOSCloud.applicationContext.getPackageName().equals(appPackage)) continue;
                            Intent intent = new Intent();
                            intent.setClassName(appPackage, PushService.class.getName());
                            intent.setAction(NotifyUtil.SERVICE_RESTART_ACTION);
                            if (AVOSCloud.showInternalDebugLog()) {
                                Log.d((String)TAG, (String)("try to start:" + appPackage + " from:" + AVOSCloud.applicationContext.getPackageName()));
                            }
                            try {
                                AVOSCloud.applicationContext.startService(intent);
                            }
                            catch (Exception ex) {
                                Log.e((String)TAG, (String)("failed to startService. cause: " + ex.getMessage()));
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    NotifyUtil.registerApp();
                }
            }
        };
    }
}

