/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite;

import android.content.Context;
import android.os.Handler;
import cn.leancloud.push.lite.AVCallback;
import cn.leancloud.push.lite.AVException;
import cn.leancloud.push.lite.PushRouterManager;
import cn.leancloud.push.lite.rest.AVHttpClient;
import cn.leancloud.push.lite.utils.AVPersistenceUtils;
import cn.leancloud.push.lite.utils.AVUtils;
import cn.leancloud.push.lite.utils.StringUtil;

public class AVOSCloud {
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DEBUG = 4;
    public static final int LOG_LEVEL_INFO = 8;
    public static final int LOG_LEVEL_WARNING = 16;
    public static final int LOG_LEVEL_ERROR = 32;
    public static final int LOG_LEVEL_NONE = 65536;
    private static final String SDK_VERSION = "5.0.15";
    private static final String DEFAULT_USER_AGENT = "LeanCloud Push(lite) SDK v5.0.15";
    private static int logLevel = 65536;
    public static Context applicationContext = null;
    public static String applicationId = null;
    public static String clientKey = null;
    protected static Handler handler = null;
    private static REGION defaultRegion = REGION.NorthChina;
    public static final int DEFAULT_NETWORK_TIMEOUT = 15000;
    private static int networkTimeoutInMills = 15000;

    public static void setNetworkTimeout(int timeoutInMills) {
        networkTimeoutInMills = timeoutInMills;
    }

    static void setServer(SERVER_TYPE serverType, String host) {
        PushRouterManager.setServer(serverType, host);
    }

    public static void setRegion(REGION region) {
        defaultRegion = region;
    }

    public static REGION getRegion() {
        return defaultRegion;
    }

    public static void initialize(Context context, String applicationId, String clientKey) {
        if (handler == null && !AVUtils.isMainThread()) {
            throw new IllegalStateException("Please call AVOSCloud.initialize in main thread.");
        }
        if (null == context || StringUtil.isEmpty(applicationId) || StringUtil.isEmpty(clientKey)) {
            throw new IllegalArgumentException("Parameter(context or applicationId or clientKey) is illegal.");
        }
        if (null != applicationContext) {
            if (applicationId.equals(AVOSCloud.applicationId) && clientKey.equals(AVOSCloud.clientKey)) {
                return;
            }
            throw new IllegalStateException("Can't initialize more than once.");
        }
        AVOSCloud.applicationId = applicationId;
        AVOSCloud.clientKey = clientKey;
        applicationContext = context;
        if (handler == null) {
            handler = new Handler();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                AVOSCloud.initialize();
            }
        }).start();
    }

    private static void initialize() {
        AVPersistenceUtils.initAppInfo(applicationId, applicationContext);
        final PushRouterManager pushRouterManager = PushRouterManager.getInstance();
        pushRouterManager.fetchRouter(false, new AVCallback<Void>(){

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }

            @Override
            protected void internalDone0(Void o, AVException avException) {
                String pushAPIServer = pushRouterManager.getPushAPIServer();
                String pushRouterServer = pushRouterManager.getPushRouterServer();
                AVHttpClient.getInstance().initialize(pushAPIServer, pushRouterServer);
            }
        });
    }

    public static String getApplicationId() {
        return applicationId;
    }

    public static Context getContext() {
        return applicationContext;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(int logLevel) {
        AVOSCloud.logLevel = logLevel;
    }

    public static void setDebugLogEnabled(boolean enable) {
        if (enable) {
            AVOSCloud.setLogLevel(4);
        } else {
            AVOSCloud.setLogLevel(8);
        }
    }

    public static boolean isDebugLogEnabled() {
        return logLevel <= 4;
    }

    public static boolean showInternalDebugLog() {
        return AVOSCloud.isDebugLogEnabled();
    }

    public static String getUserAgent() {
        return DEFAULT_USER_AGENT;
    }

    static enum SERVER_TYPE {
        API("api"),
        PUSH("push"),
        RTM("rtm"),
        STATS("stats"),
        ENGINE("engine");

        public final String name;

        private SERVER_TYPE(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum REGION {
        EastChina,
        NorthChina,
        NorthAmerica;

    }
}

