/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import cn.leancloud.push.lite.AVOSCloud;
import cn.leancloud.push.lite.PushService;
import cn.leancloud.push.lite.utils.AVPersistenceUtils;
import cn.leancloud.push.lite.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AVNotificationManager {
    private static final String TAG = AVNotificationManager.class.getSimpleName();
    private static final String PUSH_INTENT_KEY = "com.avoscloud.push";
    private static final String AV_PUSH_SERVICE_APP_DATA = "AV_PUSH_SERVICE_APP_DATA";
    private static final String ICON_KEY = "_notification_icon";
    private static final Random random = new Random();
    private final ConcurrentMap<String, String> defaultPushCallback = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> processedMessages = new ConcurrentHashMap<String, String>();
    private int notificationIcon = 0;
    private Context context = null;
    private static AVNotificationManager INSTANCE = null;

    public static synchronized AVNotificationManager getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new AVNotificationManager(AVOSCloud.applicationContext);
        }
        return INSTANCE;
    }

    private AVNotificationManager(Context context) {
        if (null != context) {
            this.notificationIcon = context.getApplicationInfo().icon;
            this.context = context;
            this.readDataFromCache();
        } else {
            Log.w((String)TAG, (String)"Context is null, please call AVOSCloud#initialize at first.");
        }
    }

    private void readDataFromCache() {
        Map<String, ?> data = AVPersistenceUtils.sharedInstance().getPersistentSetting(AV_PUSH_SERVICE_APP_DATA);
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            String channel = entry.getKey();
            if (channel.equals(ICON_KEY)) {
                try {
                    this.notificationIcon = Integer.parseInt((String)entry.getValue());
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                continue;
            }
            String defaultCls = String.valueOf(entry.getValue());
            this.defaultPushCallback.put(channel, defaultCls);
        }
    }

    int getNotificationIcon() {
        return this.notificationIcon;
    }

    void setNotificationIcon(int icon) {
        this.notificationIcon = icon;
        AVPersistenceUtils.sharedInstance().savePersistentSettingString(AV_PUSH_SERVICE_APP_DATA, ICON_KEY, String.valueOf(icon));
    }

    void addDefaultPushCallback(String channel, String clsName) {
        this.defaultPushCallback.put(channel, clsName);
        AVPersistenceUtils.sharedInstance().savePersistentSettingString(AV_PUSH_SERVICE_APP_DATA, channel, String.valueOf(clsName));
    }

    void removeDefaultPushCallback(String channel) {
        this.defaultPushCallback.remove(channel);
        AVPersistenceUtils.sharedInstance().removePersistentSettingString(AV_PUSH_SERVICE_APP_DATA, channel);
    }

    boolean containsDefaultPushCallback(String channel) {
        return this.defaultPushCallback.containsKey(channel);
    }

    String getDefaultPushCallback(String channel) {
        return StringUtil.isEmpty(channel) ? null : (String)this.defaultPushCallback.get(channel);
    }

    public int size() {
        return this.defaultPushCallback.size();
    }

    static String getJSONValue(String msg, String key) {
        Map jsonMap = (Map)JSON.parseObject((String)msg, HashMap.class);
        if (jsonMap == null || jsonMap.isEmpty()) {
            return null;
        }
        Object action = jsonMap.get(key);
        return action != null ? action.toString() : null;
    }

    static String getChannel(String msg) {
        return AVNotificationManager.getJSONValue(msg, "_channel");
    }

    static String getAction(String msg) {
        return AVNotificationManager.getJSONValue(msg, "action");
    }

    String getTitle(String msg) {
        return this.getValue(msg, "title");
    }

    String getSound(String msg) {
        return this.getValue(msg, "sound");
    }

    private String getValue(String msg, String key) {
        String result = AVNotificationManager.getJSONValue(msg, key);
        if (!StringUtil.isEmpty(result)) {
            return result;
        }
        Map jsonMap = (Map)JSON.parseObject((String)msg, HashMap.class);
        if (jsonMap == null || jsonMap.isEmpty()) {
            return this.getApplicationName();
        }
        Map data = (Map)jsonMap.get("data");
        if (data == null || data.isEmpty()) {
            return this.getApplicationName();
        }
        Object val = data.get(key);
        if (val != null) {
            return val.toString();
        }
        return this.getApplicationName();
    }

    static String getText(String msg) {
        String text = AVNotificationManager.getJSONValue(msg, "alert");
        if (text != null && text.trim().length() > 0) {
            return text;
        }
        Map jsonMap = (Map)JSON.parseObject((String)msg, HashMap.class);
        if (jsonMap == null || jsonMap.isEmpty()) {
            return null;
        }
        Map data = (Map)jsonMap.get("data");
        if (data == null || data.isEmpty()) {
            return null;
        }
        Object val = data.get("message");
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    static boolean getSilent(String message) {
        if (!StringUtil.isEmpty(message)) {
            try {
                JSONObject object = JSON.parseObject((String)message);
                return object.containsKey((Object)"silent") ? object.getBooleanValue("silent") : false;
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"failed to parse JSON.", (Throwable)e);
            }
        }
        return false;
    }

    static Date getExpiration(String msg) {
        String result = "";
        try {
            JSONObject object = JSON.parseObject((String)msg);
            result = object.getString("_expiration_time");
        }
        catch (JSONException object) {
            // empty catch block
        }
        if (StringUtil.isEmpty(result)) {
            return null;
        }
        Date date = StringUtil.dateFromString(result);
        return date;
    }

    public void processPushMessage(String message, String messageId) {
        if (this.processedMessages.containsKey(messageId)) {
            Log.w((String)TAG, (String)("duplicated push message: " + message));
            return;
        }
        this.processedMessages.put(messageId, "");
        try {
            Date expiration;
            String channel = AVNotificationManager.getChannel(message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = AVOSCloud.getApplicationId();
            }
            if ((expiration = AVNotificationManager.getExpiration(message)) != null && expiration.before(new Date())) {
                Log.d((String)TAG, (String)("message expired:" + message));
                return;
            }
            String action = AVNotificationManager.getAction(message);
            if (AVOSCloud.isDebugLogEnabled()) {
                Log.d((String)TAG, (String)("process push message:" + message + ", channel:" + channel + ", action:" + action));
            }
            if (action != null) {
                this.sendBroadcast(channel, message, action);
            } else {
                this.sendNotification(channel, message);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Process notification failed. cause: " + e.getMessage()));
        }
    }

    private Intent buildUpdateIntent(String channel, String msg, String action) {
        Intent updateIntent = new Intent();
        if (action != null) {
            updateIntent.setAction(action);
        }
        updateIntent.putExtra(PUSH_INTENT_KEY, 1);
        updateIntent.putExtra("com.avos.avoscloud.Channel", channel);
        updateIntent.putExtra("com.avoscloud.Channel", channel);
        updateIntent.putExtra("com.avos.avoscloud.Data", msg);
        updateIntent.putExtra("com.avoscloud.Data", msg);
        updateIntent.setPackage(this.context.getPackageName());
        return updateIntent;
    }

    void sendNotification(String from, String msg) throws IllegalArgumentException {
        Intent resultIntent = this.buildUpdateIntent(from, msg, null);
        this.sendNotification(from, msg, resultIntent);
    }

    @TargetApi(value=26)
    private void sendNotification(String from, String msg, Intent resultIntent) {
        String clsName = this.getDefaultPushCallback(from);
        if (StringUtil.isEmpty(clsName)) {
            throw new IllegalArgumentException("No default callback found, did you forget to invoke setDefaultPushCallback?");
        }
        int lastIndex = clsName.lastIndexOf(".");
        if (lastIndex != -1) {
            int notificationId = random.nextInt();
            ComponentName cn = new ComponentName(this.context, clsName);
            resultIntent.setComponent(cn);
            PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)notificationId, (Intent)resultIntent, (int)0);
            String sound = this.getSound(msg);
            Notification notification = null;
            if (Build.VERSION.SDK_INT <= 25) {
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context).setSmallIcon(this.getNotificationIcon()).setContentTitle((CharSequence)this.getTitle(msg)).setAutoCancel(true).setContentIntent(contentIntent).setDefaults(3).setContentText((CharSequence)AVNotificationManager.getText(msg));
                notification = mBuilder.build();
            } else {
                Notification.Builder builder = new Notification.Builder(this.context).setSmallIcon(this.getNotificationIcon()).setContentTitle((CharSequence)this.getTitle(msg)).setAutoCancel(true).setContentIntent(contentIntent).setDefaults(3).setContentText((CharSequence)AVNotificationManager.getText(msg)).setChannelId(PushService.DefaultChannelId);
                notification = builder.build();
            }
            if (sound != null && sound.trim().length() > 0) {
                notification.sound = Uri.parse((String)("android.resource://" + sound));
            }
            NotificationManager manager = (NotificationManager)this.context.getSystemService("notification");
            manager.notify(notificationId, notification);
        } else {
            Log.e((String)TAG, (String)("Class name is invalid, which must contain '.': " + clsName));
        }
    }

    String getApplicationName() {
        ApplicationInfo ai;
        PackageManager pm = this.context.getPackageManager();
        try {
            ai = pm.getApplicationInfo(this.context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        String applicationName = ai != null ? pm.getApplicationLabel(ai) : "Notification";
        return applicationName;
    }

    void sendBroadcast(String channel, String msg, String action) {
        Intent updateIntent = this.buildUpdateIntent(channel, msg, action);
        Log.d((String)TAG, (String)("action: " + updateIntent.getAction()));
        this.context.sendBroadcast(updateIntent);
        Log.d((String)TAG, (String)"sent broadcast");
    }
}

