/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import cn.leancloud.push.lite.AVCallback;
import cn.leancloud.push.lite.AVException;
import cn.leancloud.push.lite.AVOSCloud;
import cn.leancloud.push.lite.ObjectValueFilter;
import cn.leancloud.push.lite.rest.AVHttpClient;
import cn.leancloud.push.lite.utils.AVPersistenceUtils;
import cn.leancloud.push.lite.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AVInstallation
implements Parcelable {
    private static final String CLASSNAME = "_Installation";
    private static final String CREATED_AT = "createdAt";
    private static final String UPDATED_AT = "updatedAt";
    private static final String OBJECT_ID = "objectId";
    private static final int UUID_LEN = UUID.randomUUID().toString().length();
    private static final String DEVICETYPETAG = "deviceType";
    private static final String CHANNELSTAG = "channel";
    private static final String INSTALLATIONIDTAG = "installationId";
    public static final String REGISTRATION_ID = "registrationId";
    public static final String VENDOR = "vendor";
    private static final String TAG = AVInstallation.class.getSimpleName();
    private static final JSONObject deleteOP = JSON.parseObject((String)"{\"__op\":\"Delete\"}");
    private static volatile AVInstallation currentInstallation;
    protected String objectId = null;
    protected String updatedAt = null;
    protected String createdAt = null;
    Map<String, Object> serverData = new ConcurrentHashMap<String, Object>();
    Map<String, JSONObject> removedAttr = new ConcurrentHashMap<String, JSONObject>();
    public static final Parcelable.Creator CREATOR;

    public static AVInstallation getCurrentInstallation() {
        return AVInstallation.getCurrentInstallation(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AVInstallation getCurrentInstallation(Context ctx) {
        Context usingCtx;
        Context context = usingCtx = null == ctx ? AVOSCloud.applicationContext : ctx;
        if (currentInstallation != null) return currentInstallation;
        Class<AVInstallation> clazz = AVInstallation.class;
        synchronized (AVInstallation.class) {
            if (currentInstallation != null || AVInstallation.readInstallationFile(usingCtx) != null) return currentInstallation;
            AVInstallation.createNewInstallation(usingCtx);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return currentInstallation;
        }
    }

    private static void createNewInstallation(Context ctx) {
        String id = AVInstallation.genInstallationId(ctx);
        currentInstallation = new AVInstallation();
        currentInstallation.setInstallationId(id);
        currentInstallation.put(INSTALLATIONIDTAG, id);
        AVInstallation.saveCurrentInstalationToLocal(ctx);
    }

    private static String genInstallationId(Context ctx) {
        String packageName = ctx.getPackageName();
        String additionalStr = UUID.randomUUID().toString();
        return StringUtil.md5(packageName + additionalStr);
    }

    private static void saveCurrentInstalationToLocal(Context ctx) {
        try {
            AVInstallation.writeInstallationFile(ctx, currentInstallation);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("failed to save installation cache. cause: " + e.getMessage()));
        }
    }

    private static String deviceType() {
        return "android";
    }

    private static String timezone() {
        TimeZone defaultTimezone = TimeZone.getDefault();
        return defaultTimezone != null ? defaultTimezone.getID() : "unknown";
    }

    protected static AVInstallation readInstallationFile(Context usingCtx) {
        if (null == usingCtx) {
            Log.w((String)TAG, (String)"Context is null, Please call AVOSCloud.initialize at first in Application");
            return null;
        }
        String json = "";
        try {
            File installationFile = AVPersistenceUtils.getInstallationFile(usingCtx);
            if (installationFile.exists()) {
                json = AVPersistenceUtils.readContentFromFile(installationFile);
                if (json.indexOf("{") >= 0) {
                    JSONObject serverDataJson;
                    json = json.replaceAll("^\\{\\s*\"@type\":\\s*\"[A-Za-z\\.]+\",", "{");
                    JSONObject installationJson = JSON.parseObject((String)json, (Feature[])new Feature[]{Feature.SupportAutoType});
                    currentInstallation = new AVInstallation();
                    if (installationJson.containsKey((Object)UPDATED_AT)) {
                        currentInstallation.setUpdatedAt(installationJson.getString(UPDATED_AT));
                    }
                    if (installationJson.containsKey((Object)OBJECT_ID)) {
                        currentInstallation.setObjectId(installationJson.getString(OBJECT_ID));
                    }
                    if (installationJson.containsKey((Object)CREATED_AT)) {
                        currentInstallation.setCreatedAt(installationJson.getString(CREATED_AT));
                    }
                    if (installationJson.containsKey((Object)"serverData") && null != (serverDataJson = installationJson.getJSONObject("serverData"))) {
                        for (String key : serverDataJson.keySet()) {
                            if (key.startsWith("@")) continue;
                            currentInstallation.put(key, serverDataJson.get((Object)key));
                        }
                    }
                } else if (json.length() == UUID_LEN) {
                    currentInstallation = new AVInstallation();
                    currentInstallation.setInstallationId(json);
                    AVInstallation.saveCurrentInstalationToLocal(usingCtx);
                }
                return currentInstallation;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("failed to read installation cache file. cause: " + e.getMessage()));
        }
        return null;
    }

    private static void writeInstallationFile(Context ctx, AVInstallation installation) throws IOException {
        if (null != ctx && null != installation) {
            installation.initialize();
            File installationFile = AVPersistenceUtils.getInstallationFile(ctx);
            String jsonString = JSON.toJSONString((Object)installation, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect});
            AVPersistenceUtils.saveContentToFile(jsonString, installationFile);
        }
    }

    public AVInstallation() {
        this.initialize();
    }

    public AVInstallation(Parcel in) {
        String className = in.readString();
        this.setCreatedAt(in.readString());
        this.setUpdatedAt(in.readString());
        this.setObjectId(in.readString());
        String serverDataStr = in.readString();
        Map serverDataMap = (Map)JSON.parse((String)serverDataStr);
        if (serverDataMap != null && !serverDataMap.isEmpty()) {
            this.serverData.putAll(serverDataMap);
        }
    }

    private void initialize() {
        try {
            if (currentInstallation != null) {
                this.put(INSTALLATIONIDTAG, currentInstallation.getInstallationId());
            }
            this.put(DEVICETYPETAG, AVInstallation.deviceType());
            this.put("timeZone", AVInstallation.timezone());
        }
        catch (IllegalArgumentException exception) {
            Log.w((String)TAG, (String)("failed to initialize Installation. cause: " + exception.getMessage()));
        }
    }

    public String getInstallationId() {
        return this.getString(INSTALLATIONIDTAG);
    }

    void setInstallationId(String id) {
        this.put(INSTALLATIONIDTAG, id);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String id) {
        this.objectId = id;
        this.serverData.put(OBJECT_ID, id);
    }

    Map<String, Object> getServerData() {
        return this.serverData;
    }

    void setServerData(Map<String, Object> serverData) {
        this.serverData.clear();
        this.serverData.putAll(serverData);
    }

    void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        this.serverData.put(UPDATED_AT, updatedAt);
    }

    void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        this.serverData.put(CREATED_AT, createdAt);
    }

    public String getClassName() {
        return CLASSNAME;
    }

    public void remove(String key) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("key should not be null or empty.");
        }
        this.serverData.remove(key);
        this.removedAttr.put(key, deleteOP);
    }

    public void removeAll(String key, Collection<?> values) {
        List val = this.getList(key);
        if (null != val) {
            val.removeAll(values);
            this.put(key, val);
        }
    }

    public void put(String key, Object value) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("key should not be null or empty.");
        }
        this.serverData.put(key, value);
    }

    public void increment(String key, Number amount) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("key should not be null or empty.");
        }
        Number oldValue = this.getNumber(key);
        oldValue = null == oldValue ? (Number)amount : (Number)(oldValue.longValue() + amount.longValue());
        this.put(key, oldValue);
    }

    public void increment(String key) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("key should not be null or empty.");
        }
        this.increment(key, 1);
    }

    public void addUnique(String key, Object value) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("key should not be null or empty.");
        }
        this.addObjectToArray(key, value, true);
    }

    public void addAllUnique(String key, Collection<?> values) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("key should not be null or empty.");
        }
        for (Object item : values) {
            this.addObjectToArray(key, item, true);
        }
    }

    public void addAll(String key, Collection<?> values) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("key should not be null or empty.");
        }
        for (Object item : values) {
            this.addObjectToArray(key, item, false);
        }
    }

    public void add(String key, Object value) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("key should not be null or empty.");
        }
        this.addObjectToArray(key, value, false);
    }

    private void addObjectToArray(String key, Object value, boolean unique) {
        ArrayList<Object> oldValue = this.getList(key);
        if (null == oldValue) {
            oldValue = new ArrayList<Object>(1);
            oldValue.add(value);
            this.put(key, oldValue);
        } else {
            boolean needAdd = true;
            if (unique) {
                for (Object e : oldValue) {
                    if (null == e || !e.equals(value)) continue;
                    needAdd = false;
                    break;
                }
            }
            if (needAdd) {
                oldValue.add(value);
                this.put(key, oldValue);
            }
        }
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public Object get(String key) {
        if (CREATED_AT.equals(key)) {
            return this.getCreatedAt();
        }
        if (UPDATED_AT.equals(key)) {
            return this.getUpdatedAt();
        }
        return this.serverData.get(key);
    }

    public boolean getBoolean(String key) {
        Boolean b = (Boolean)this.get(key);
        return b == null ? false : b;
    }

    public byte[] getBytes(String key) {
        return (byte[])this.get(key);
    }

    public String getString(String key) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public Number getNumber(String key) {
        Number number = (Number)this.get(key);
        return number;
    }

    public long getLong(String key) {
        Number number = (Number)this.get(key);
        if (number != null) {
            return number.longValue();
        }
        return 0L;
    }

    public int getInt(String key) {
        Number v = (Number)this.get(key);
        if (v != null) {
            return v.intValue();
        }
        return 0;
    }

    public Date getDate(String key) {
        return (Date)this.get(key);
    }

    public double getDouble(String key) {
        Number number = (Number)this.get(key);
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    public List getList(String key) {
        return (List)this.get(key);
    }

    public JSONObject getJSONObject(String key) {
        Object object = this.get(key);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        String jsonString = JSON.toJSONString((Object)object);
        JSONObject jsonObject = null;
        try {
            jsonObject = JSON.parseObject((String)jsonString);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Invalid json string", exception);
        }
        return jsonObject;
    }

    public JSONArray getJSONArray(String key) {
        Object list = this.get(key);
        if (list == null) {
            return null;
        }
        if (list instanceof JSONArray) {
            return (JSONArray)list;
        }
        if (list instanceof Collection) {
            JSONArray array = new JSONArray(Arrays.asList((Collection)list));
            return array;
        }
        if (list instanceof Object[]) {
            JSONArray array = new JSONArray();
            for (Object obj : (Object[])list) {
                array.add(obj);
            }
            return array;
        }
        return null;
    }

    public Date getCreatedAt() {
        return StringUtil.dateFromString(this.createdAt);
    }

    public Date getUpdatedAt() {
        return StringUtil.dateFromString(this.updatedAt);
    }

    public static AVInstallation createWithoutData(String objectId) {
        AVInstallation result = new AVInstallation();
        result.setObjectId(objectId);
        return result;
    }

    public void refreshInBackground() {
        this.refreshInBackground(null);
    }

    public void refreshInBackground(AVCallback<AVInstallation> callback) {
        this.refreshInBackground(null, callback);
    }

    public void refreshInBackground(String includeKeys, final AVCallback<AVInstallation> callback) {
        if (StringUtil.isEmpty(this.objectId)) {
            throw new IllegalStateException("objectId is null.");
        }
        AVHttpClient.getInstance().findInstallation(this.objectId, new Callback<JSONObject>(){

            public void onResponse(Call<JSONObject> call, Response<JSONObject> response) {
                JSONObject result = (JSONObject)response.body();
                AVInstallation.this.mergeServerData(result);
                if (null != callback) {
                    callback.internalDone(AVInstallation.this, null);
                }
            }

            public void onFailure(Call<JSONObject> call, Throwable t) {
                if (null != callback) {
                    callback.internalDone(new AVException(t));
                }
            }
        });
    }

    public void fetchInBackground(AVCallback<AVInstallation> callback) {
        this.refreshInBackground(callback);
    }

    public void fetchInBackground(String includeKeys, AVCallback<AVInstallation> callback) {
        this.refreshInBackground(includeKeys, callback);
    }

    private void mergeServerData(JSONObject data) {
        if (null == data) {
            return;
        }
        this.serverData.putAll(data.getInnerMap());
        AVInstallation.saveCurrentInstalationToLocal(AVOSCloud.applicationContext);
    }

    public void saveInBackground() {
        this.saveInBackground(null);
    }

    public void saveInBackground(AVCallback<Void> callback) {
        this.saveInBackground(false, callback);
    }

    public void saveInBackground(boolean fetchWhenSave, final AVCallback<Void> callback) {
        JSONObject param = new JSONObject(this.serverData);
        if (param.containsKey((Object)UPDATED_AT)) {
            param.remove((Object)UPDATED_AT);
        }
        if (param.containsKey((Object)CREATED_AT)) {
            param.remove((Object)CREATED_AT);
        }
        if (param.containsKey((Object)OBJECT_ID)) {
            param.putAll(this.removedAttr);
        } else {
            this.removedAttr.clear();
        }
        AVHttpClient.getInstance().saveInstallation(param, fetchWhenSave, new Callback<JSONObject>(){

            public void onResponse(Call<JSONObject> call, Response<JSONObject> response) {
                JSONObject result = (JSONObject)response.body();
                AVInstallation.this.mergeServerData(result);
                AVInstallation.this.removedAttr.clear();
                if (null != callback) {
                    callback.internalDone(null);
                }
            }

            public void onFailure(Call<JSONObject> call, Throwable t) {
                if (null != callback) {
                    callback.internalDone(new AVException(t));
                }
            }
        });
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int i) {
        out.writeString(CLASSNAME);
        out.writeString(this.createdAt);
        out.writeString(this.updatedAt);
        out.writeString(this.objectId);
        out.writeString(JSON.toJSONString(this.serverData, (SerializeFilter)new ObjectValueFilter(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteRootClassName, SerializerFeature.NotWriteDefaultValue}));
    }

    static {
        CREATOR = new InstallationCreator();
    }

    public static class InstallationCreator
    implements Parcelable.Creator {
        public AVInstallation createFromParcel(Parcel source) {
            return new AVInstallation(source);
        }

        public AVInstallation[] newArray(int size) {
            return new AVInstallation[size];
        }
    }
}

