/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push.lite;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import cn.leancloud.push.lite.AVConnectivityListener;

public class AVConnectivityReceiver
extends BroadcastReceiver {
    private final AVConnectivityListener listener;

    public AVConnectivityReceiver(AVConnectivityListener listener) {
        this.listener = listener;
    }

    public void onReceive(Context context, Intent intent) {
        if (null == this.listener) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            if (null == activeNetwork || !activeNetwork.isConnected()) {
                this.listener.onNotConnected(context);
                return;
            }
            if (activeNetwork.getType() == 0) {
                this.listener.onMobile(context);
            } else if (activeNetwork.getType() == 1) {
                this.listener.onWifi(context);
            } else {
                this.listener.onOtherConnected(context);
            }
        }
        catch (Exception ex) {
            Log.w((String)"AVConnectivityReceiver", (String)("failed to call CONNECTIVITY_SERVICE, cause:" + ex.getMessage()));
        }
    }
}

