/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONObject;
import cn.leancloud.push.AndroidNotificationManager;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import io.reactivex.Observer;
import java.util.Map;

public class AVFirebaseMessagingService
extends FirebaseMessagingService {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVFirebaseMessagingService.class);
    private final String VENDOR = "fcm";

    public void onMessageReceived(RemoteMessage remoteMessage) {
        Map data = remoteMessage.getData();
        if (null == data) {
            return;
        }
        LOGGER.d("received message from: " + remoteMessage.getFrom() + ", payload: " + data.toString());
        if (remoteMessage.getNotification() == null) {
            return;
        }
        String title = remoteMessage.getNotification().getTitle();
        String alert = remoteMessage.getNotification().getBody();
        try {
            JSONObject jsonObject = JSON.parseObject((String)((String)data.get("payload")));
            if (null != jsonObject) {
                String channel = jsonObject.getString("_channel");
                String action = jsonObject.getString("action");
                if (!StringUtil.isEmpty((String)title)) {
                    jsonObject.put((Object)"title", (Object)title);
                }
                if (!StringUtil.isEmpty((String)alert)) {
                    jsonObject.put((Object)"alert", (Object)alert);
                }
                AndroidNotificationManager androidNotificationManager = AndroidNotificationManager.getInstance();
                androidNotificationManager.processFcmMessage(channel, action, jsonObject.toJSONString());
            }
        }
        catch (Exception ex) {
            LOGGER.e("failed to parse push data.", (Throwable)ex);
        }
    }

    public void onNewToken(String token) {
        LOGGER.d("refreshed token: " + token);
        this.sendRegistrationToServer(token);
    }

    private void sendRegistrationToServer(String refreshedToken) {
        if (StringUtil.isEmpty((String)refreshedToken)) {
            return;
        }
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        if (!"fcm".equals(installation.getString("vendor"))) {
            installation.put("vendor", (Object)"fcm");
        }
        if (!refreshedToken.equals(installation.getString("registrationId"))) {
            installation.put("registrationId", (Object)refreshedToken);
        }
        installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

            public void done(AVException e) {
                if (null != e) {
                    LOGGER.e("failed to update installation.", (Throwable)e);
                } else {
                    LOGGER.d("succeed to update installation.");
                }
            }
        }));
        LOGGER.d("FCM registration success! registrationId=" + refreshedToken);
    }

    public void onDeletedMessages() {
        super.onDeletedMessages();
    }
}

