/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.ops;

import com.avos.avoscloud.ops.AVOp;
import com.avos.avoscloud.ops.CompoundOp;
import com.avos.avoscloud.ops.NullOP;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseOp
implements AVOp {
    protected String key;
    protected AVOp.OpType type;
    protected LinkedList<AVOp> ops = null;

    public AVOp.OpType getType() {
        return this.type;
    }

    public void setType(AVOp.OpType type) {
        this.type = type;
    }

    public List<AVOp> getOps() {
        return this.ops;
    }

    public void setOps(LinkedList<AVOp> ops) {
        this.ops = ops;
    }

    public String getKey() {
        return this.key;
    }

    public BaseOp() {
    }

    public BaseOp(String key, AVOp.OpType type) {
        this.key = key;
        this.type = type;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public AVOp.OpType type() {
        return this.type;
    }

    @Override
    public <T extends AVOp> T cast(Class<T> clazz) {
        return (T)((AVOp)clazz.cast(this));
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public AVOp merge(AVOp other) {
        this.assertKeyEquals(other);
        if (this.ops == null) {
            this.ops = new LinkedList();
        }
        if (other.type() == AVOp.OpType.Compound) {
            this.ops.addAll(other.cast(CompoundOp.class).ops);
        } else {
            this.ops.add(other);
        }
        return this;
    }

    @Override
    public int size() {
        return this.ops == null ? 0 : this.ops.size();
    }

    @Override
    public AVOp remove(int idx) {
        if (this.ops != null && this.ops.size() > idx) {
            return this.ops.remove(idx);
        }
        return NullOP.INSTANCE;
    }

    @Override
    public Object apply(Object obj) {
        if (this.ops != null) {
            for (AVOp op : this.ops) {
                obj = op.apply(obj);
            }
        }
        return obj;
    }

    public void assertKeyEquals(AVOp other) {
        if (other != NullOP.INSTANCE && !other.key().equals(this.key)) {
            throw new IllegalArgumentException("invalid key");
        }
    }

    @Override
    public Iterator<AVOp> iterator() {
        if (this.ops != null) {
            return this.ops.iterator();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public AVOp get(int idx) {
        if (this.ops != null) {
            if (this.ops.size() > idx) {
                return this.ops.get(idx);
            }
            return NullOP.INSTANCE;
        }
        if (idx == 0) {
            return this;
        }
        return NullOP.INSTANCE;
    }
}

