/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.internal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSServices;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.FunctionCallback;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetHttpResponseHandler;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.internal.AppRouter;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.okhttp.Request;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultAppRouter
extends AppRouter {
    private static final String ROUTER_ADDRESS = " https://app-router.leancloud.cn/2/route?appId=";
    private static final String API_SERVER_KEY = "api_server";
    private static final String STATS_SERVER_KEY = "stats_server";
    private static final String RTM_ROUTER_SERVER_KEY = "rtm_router_server";
    private static final String PUSH_SERVER_KEY = "push_server";
    private static final String ENGINE_SERVER_KEY = "engine_server";
    private static final String TTL_KEY = "ttl";
    private static final String LATEST_UPDATE_TIME_KEY = "latest_update_time";
    public static DefaultAppRouter appRouter;

    public static synchronized DefaultAppRouter instance() {
        if (null == appRouter) {
            appRouter = new DefaultAppRouter();
        }
        return appRouter;
    }

    private DefaultAppRouter() {
    }

    @Override
    protected void fetchServerHosts(boolean sync, final FunctionCallback<Map<AVOSServices, String>> cb) {
        if (!InternalConfigurationController.globalInstance().getAppConfiguration().isUCloudApp()) {
            Map s = Collections.emptyMap();
            cb.done(s, null);
            return;
        }
        Long lastTime = InternalConfigurationController.globalInstance().getInternalPersistence().getPersistentSettingLong(this.getAppRouterSPName(), LATEST_UPDATE_TIME_KEY, 0L);
        int ttl = InternalConfigurationController.globalInstance().getInternalPersistence().getPersistentSettingInteger(this.getAppRouterSPName(), TTL_KEY, 0);
        if (System.currentTimeMillis() - lastTime > (long)(ttl * 1000)) {
            PaasClient.AVHttpClient client = new PaasClient.AVHttpClient();
            Request.Builder builder = new Request.Builder();
            builder.url(ROUTER_ADDRESS + InternalConfigurationController.globalInstance().getAppConfiguration().getApplicationId()).get();
            client.execute(builder.build(), sync, new GetHttpResponseHandler(new GenericObjectCallback(){

                @Override
                public void onSuccess(String content, AVException e) {
                    if (null == e) {
                        if (InternalConfigurationController.globalInstance().getInternalLogger().showInternalDebugLog()) {
                            LogUtil.avlog.d(" fetchRouter :" + content);
                        }
                        cb.done(DefaultAppRouter.this.parseRouterResult(content), null);
                    } else {
                        cb.done(null, e);
                    }
                }

                @Override
                public void onFailure(Throwable error, String content) {
                    LogUtil.log.e("get router error ", new AVException(error));
                }
            }));
        }
    }

    private Map<AVOSServices, String> parseRouterResult(String result) {
        JSONObject response = null;
        response = JSON.parseObject((String)result);
        if (null == response) {
            return Collections.emptyMap();
        }
        HashMap<AVOSServices, String> hosts = new HashMap<AVOSServices, String>();
        this.updateMap(hosts, response, AVOSServices.RTM, RTM_ROUTER_SERVER_KEY);
        this.updateMap(hosts, response, AVOSServices.PUSH, PUSH_SERVER_KEY);
        this.updateMap(hosts, response, AVOSServices.API, API_SERVER_KEY);
        this.updateMap(hosts, response, AVOSServices.STATS, STATS_SERVER_KEY);
        this.updateMap(hosts, response, AVOSServices.ENGINE, ENGINE_SERVER_KEY);
        if (response.containsKey((Object)TTL_KEY)) {
            InternalConfigurationController.globalInstance().getInternalPersistence().savePersistentSettingInteger(this.getAppRouterSPName(), TTL_KEY, response.getIntValue(TTL_KEY));
        }
        InternalConfigurationController.globalInstance().getInternalPersistence().savePersistentSettingLong(this.getAppRouterSPName(), LATEST_UPDATE_TIME_KEY, System.currentTimeMillis());
        return hosts;
    }

    private void updateMap(Map<AVOSServices, String> hosts, JSONObject jsonObject, AVOSServices service, String jsonKey) {
        if (jsonObject.containsKey((Object)jsonKey)) {
            String value = this.addHttpsPrefix(jsonObject.getString(jsonKey));
            hosts.put(service, value);
        }
    }

    private String addHttpsPrefix(String url) {
        if (!AVUtils.isBlankString(url) && !url.startsWith("http")) {
            return "https://" + url;
        }
        return url;
    }
}

