/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.internal;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVMobilePhoneVerifyCallback;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.RequestMobileCodeCallback;
import java.util.HashMap;
import java.util.Map;

public class InternalSMS {
    public static void requestSMSCode(String phone, String name, String op, int ttl) throws AVException {
        InternalSMS.requestSMSCodeInBackground(phone, null, InternalSMS.getSMSCodeEnv(name, op, ttl), true, new RequestMobileCodeCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    private static Map<String, Object> getSMSCodeEnv(String name, String op, int ttl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!AVUtils.isBlankString(op)) {
            map.put("op", op);
        }
        if (!AVUtils.isBlankString(name)) {
            map.put("name", name);
        }
        if (ttl > 0) {
            map.put("ttl", ttl);
        }
        return map;
    }

    private static Map<String, Object> getVoiceCodeEnv(String countryCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("smsType", "voice");
        if (!AVUtils.isBlankString(countryCode)) {
            map.put("IDD", countryCode);
        }
        return map;
    }

    @Deprecated
    public static void requestSMSCodeInBackgroud(String phone, String name, String op, int ttl, RequestMobileCodeCallback callback) {
        InternalSMS.requestSMSCodeInBackground(phone, null, InternalSMS.getSMSCodeEnv(name, op, ttl), false, callback);
    }

    public static void requestSMSCodeInBackground(String phone, String name, String op, int ttl, RequestMobileCodeCallback callback) {
        InternalSMS.requestSMSCodeInBackground(phone, null, InternalSMS.getSMSCodeEnv(name, op, ttl), false, callback);
    }

    public static void requestSMSCode(String phone, String templateName, Map<String, Object> env) throws AVException {
        InternalSMS.requestSMSCodeInBackground(phone, templateName, env, true, new RequestMobileCodeCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    @Deprecated
    public static void requestSMSCodeInBackgroud(String phone, String templateName, Map<String, Object> env, RequestMobileCodeCallback callback) {
        InternalSMS.requestSMSCodeInBackground(phone, templateName, env, false, callback);
    }

    public static void requestSMSCodeInBackground(String phone, String templateName, Map<String, Object> env, RequestMobileCodeCallback callback) {
        InternalSMS.requestSMSCodeInBackground(phone, templateName, env, false, callback);
    }

    private static void requestSMSCodeInBackground(String phone, String templateName, Map<String, Object> env, boolean sync, RequestMobileCodeCallback callback) {
        final RequestMobileCodeCallback internalCallback = callback;
        if (AVUtils.isBlankString(phone) || !AVUtils.checkMobilePhoneNumber(phone)) {
            callback.internalDone(new AVException(127, "Invalid Phone Number"));
        }
        if (env == null) {
            env = new HashMap<String, Object>();
        }
        env.put("mobilePhoneNumber", phone);
        if (!AVUtils.isBlankString(templateName)) {
            env.put("template", templateName);
        }
        String object = AVUtils.jsonStringFromMapWithNull(env);
        PaasClient.storageInstance().postObject("requestSmsCode", object, sync, false, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, null, null);
    }

    public static void requestSMSCode(String phone) throws AVException {
        InternalSMS.requestSMSCode(phone, null, null, 0);
    }

    @Deprecated
    public static void requestSMSCodeInBackgroud(String phone, RequestMobileCodeCallback callback) {
        InternalSMS.requestSMSCodeInBackgroud(phone, null, null, 0, callback);
    }

    public static void requestSMSCodeInBackground(String phone, RequestMobileCodeCallback callback) {
        InternalSMS.requestSMSCodeInBackgroud(phone, null, null, 0, callback);
    }

    public static void requestVoiceCode(String phoneNumber) throws AVException {
        InternalSMS.requestVoiceCode(phoneNumber, null);
    }

    public static void requestVoiceCode(String phoneNumber, String idd) throws AVException {
        InternalSMS.requestSMSCodeInBackground(phoneNumber, null, InternalSMS.getVoiceCodeEnv(idd), true, new RequestMobileCodeCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void requestVoiceCodeInBackground(String phoneNumber, RequestMobileCodeCallback callback) {
        InternalSMS.requestSMSCodeInBackground(phoneNumber, null, InternalSMS.getVoiceCodeEnv(null), callback);
    }

    private static void requestVoiceCodeInBackground(String phoneNumber, String idd, RequestMobileCodeCallback callback) {
        InternalSMS.requestSMSCodeInBackground(phoneNumber, null, InternalSMS.getVoiceCodeEnv(idd), callback);
    }

    public static void verifySMSCode(String code, String mobilePhoneNumber) throws AVException {
        InternalSMS.verifySMSCodeInBackground(code, mobilePhoneNumber, true, new AVMobilePhoneVerifyCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void verifyCode(String code, String mobilePhoneNumber) throws AVException {
        InternalSMS.verifySMSCode(code, mobilePhoneNumber);
    }

    public static void verifySMSCodeInBackground(String code, String mobilePhoneNumber, AVMobilePhoneVerifyCallback callback) {
        InternalSMS.verifySMSCodeInBackground(code, mobilePhoneNumber, false, callback);
    }

    public static void verifyCodeInBackground(String code, String mobilePhoneNumber, AVMobilePhoneVerifyCallback callback) {
        InternalSMS.verifySMSCodeInBackground(code, mobilePhoneNumber, false, callback);
    }

    private static void verifySMSCodeInBackground(String code, String mobilePhoneNumber, boolean sync, AVMobilePhoneVerifyCallback callback) {
        final AVMobilePhoneVerifyCallback internalCallback = callback;
        if (AVUtils.isBlankString(code) || !AVUtils.checkMobileVerifyCode(code)) {
            callback.internalDone(new AVException(127, "Invalid Verify Code"));
        }
        String endpointer = String.format("verifySmsCode/%s", code);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mobilePhoneNumber", mobilePhoneNumber);
        PaasClient.storageInstance().postObject(endpointer, AVUtils.restfulServerData(params), sync, false, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, null, null);
    }
}

