/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.internal;

import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVOSServices;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.FunctionCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.internal.InternalConfigurationController;
import java.util.HashMap;
import java.util.Map;

public abstract class AppRouter {
    protected abstract void fetchServerHosts(boolean var1, FunctionCallback<Map<AVOSServices, String>> var2);

    public void updateServerHosts() {
        final HashMap<AVOSServices, String> result = new HashMap<AVOSServices, String>();
        this.fetchServerHosts(true, new FunctionCallback<Map<AVOSServices, String>>(){

            @Override
            public void done(Map<AVOSServices, String> hosts, AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
                result.putAll(hosts);
            }
        });
        if (AVExceptionHolder.exists()) {
            throw new RuntimeException(AVExceptionHolder.remove());
        }
        this.updateMapAndSaveLocal(result, AVOSServices.RTM);
        this.updateMapAndSaveLocal(result, AVOSServices.PUSH);
        this.updateMapAndSaveLocal(result, AVOSServices.API);
        this.updateMapAndSaveLocal(result, AVOSServices.STATS);
        this.updateMapAndSaveLocal(result, AVOSServices.ENGINE);
    }

    public void updateServerHostsInBackground() {
        this.fetchServerHosts(false, new FunctionCallback<Map<AVOSServices, String>>(){

            @Override
            public void done(Map<AVOSServices, String> hosts, AVException e) {
                if (e != null) {
                    LogUtil.log.e("fetchServerHosts error ", e);
                    return;
                }
                AppRouter.this.updateMapAndSaveLocal(hosts, AVOSServices.RTM);
                AppRouter.this.updateMapAndSaveLocal(hosts, AVOSServices.PUSH);
                AppRouter.this.updateMapAndSaveLocal(hosts, AVOSServices.API);
                AppRouter.this.updateMapAndSaveLocal(hosts, AVOSServices.STATS);
                AppRouter.this.updateMapAndSaveLocal(hosts, AVOSServices.ENGINE);
            }
        });
    }

    private void updateMapAndSaveLocal(Map<AVOSServices, String> hosts, AVOSServices service) {
        String host = hosts.get((Object)service);
        if (AVUtils.isBlankString(host)) {
            return;
        }
        InternalConfigurationController.globalInstance().getInternalPersistence().savePersistentSettingString(this.getAppRouterSPName(), service.toString(), host);
        InternalConfigurationController.globalInstance().getAppConfiguration().setServerUrl(service, host);
    }

    protected String getAppRouterSPName() {
        return "com.avos.avoscloud.approuter." + InternalConfigurationController.globalInstance().getAppConfiguration().applicationId;
    }
}

