/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.internal;

import com.avos.avoscloud.AVOSServices;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.internal.InternalConfigurationController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class AppConfiguration {
    private static final String DEFAULT_QCLOUD_API_SERVER = "https://e1-api.leancloud.cn";
    private static final String DEFAULT_US_API_SERVER = "https://us-api.leancloud.cn";
    private static final String DEFAULT_QCLOUD_ROUTER_SERVER = "https://router-q0-push.leancloud.cn";
    private static final String DEFAULT_US_ROUTER_SERVER = "https://router-a0-push.leancloud.cn";
    private final String applicationIdField = "X-LC-Id";
    private final String apiKeyField = "X-LC-Key";
    String applicationId;
    String clientKey;
    private boolean isCN = true;
    private Map<AVOSServices, String> serviceHostMap = new ConcurrentHashMap<AVOSServices, String>();
    protected StorageType storageType = StorageType.StorageTypeQiniu;

    public void setStorageType(StorageType type) {
        this.storageType = type;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public String getServerUrl(AVOSServices type) {
        return this.serviceHostMap.get((Object)type);
    }

    public void setServerUrl(AVOSServices type, String host) {
        this.serviceHostMap.put(type, host);
    }

    public abstract boolean isConfigured();

    public abstract void setupThreadPoolExecutor(ThreadPoolExecutor var1);

    public abstract boolean isConnected();

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        if (this.isUsApp()) {
            this.serviceHostMap.put(AVOSServices.API, DEFAULT_US_API_SERVER);
            this.serviceHostMap.put(AVOSServices.RTM, DEFAULT_US_ROUTER_SERVER);
            this.serviceHostMap.put(AVOSServices.ENGINE, DEFAULT_US_API_SERVER);
            this.serviceHostMap.put(AVOSServices.STATS, DEFAULT_US_API_SERVER);
            return;
        }
        if (this.isQCloudApp()) {
            this.serviceHostMap.put(AVOSServices.API, DEFAULT_QCLOUD_API_SERVER);
            this.serviceHostMap.put(AVOSServices.RTM, DEFAULT_QCLOUD_ROUTER_SERVER);
            this.serviceHostMap.put(AVOSServices.ENGINE, DEFAULT_QCLOUD_API_SERVER);
            this.serviceHostMap.put(AVOSServices.STATS, DEFAULT_QCLOUD_API_SERVER);
            return;
        }
        this.serviceHostMap.put(AVOSServices.API, this.getUcloudDefaultServer(AVOSServices.API));
        this.serviceHostMap.put(AVOSServices.RTM, this.getUcloudDefaultServer(AVOSServices.RTM));
        this.serviceHostMap.put(AVOSServices.ENGINE, this.getUcloudDefaultServer(AVOSServices.ENGINE));
        this.serviceHostMap.put(AVOSServices.STATS, this.getUcloudDefaultServer(AVOSServices.STATS));
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public void setIsCN(boolean isCN) {
        this.isCN = isCN;
    }

    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("X-LC-Id", this.applicationId);
        return result;
    }

    public String dumpRequestHeaders() {
        return String.format("-H \"%s: %s\" -H \"%s: %s\"", "X-LC-Id", this.applicationId, "X-LC-Key", this.dumpKey(this.clientKey, "YourAppKey"));
    }

    protected String dumpKey(String key, String mask) {
        return InternalConfigurationController.globalInstance().getInternalLogger().showInternalDebugLog() ? key : mask;
    }

    private String getUcloudDefaultServer(AVOSServices type) {
        if (!AVUtils.isBlankString(this.applicationId)) {
            return String.format("https://%s.%s.lncld.net", this.applicationId.substring(0, 8), type.toString());
        }
        LogUtil.avlog.e("AppId is null, Please call AVOSCloud.initialize first");
        return "";
    }

    public boolean isUCloudApp() {
        return !this.isQCloudApp() && !this.isUsApp();
    }

    private boolean isQCloudApp() {
        return !AVUtils.isBlankString(this.applicationId) && this.applicationId.endsWith("9Nh9j0Va");
    }

    private boolean isUsApp() {
        return !this.isCN || !AVUtils.isBlankString(this.applicationId) && this.applicationId.endsWith("MdYXbMMI");
    }

    public static enum StorageType {
        StorageTypeQiniu,
        StorageTypeAV,
        StorageTypeS3;

    }
}

