/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.HttpClientUploader;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import java.util.HashMap;
import org.json.JSONObject;

class UrlDirectlyUploader
extends HttpClientUploader {
    AVFile parseFile;

    protected UrlDirectlyUploader(AVFile parseFile, SaveCallback saveCallback, ProgressCallback progressCallback) {
        super(saveCallback, progressCallback);
        this.parseFile = parseFile;
    }

    @Override
    public AVException doWork() {
        final AVException[] exceptionSaveFile = new AVException[1];
        PaasClient.storageInstance().postObject(AVPowerfulUtils.getEndpoint(this.parseFile), this.getFileRequestParameters(), true, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                if (e == null) {
                    try {
                        JSONObject jsonObject = new JSONObject(content);
                        UrlDirectlyUploader.this.parseFile.handleUploadedResponse(jsonObject.getString("objectId"), jsonObject.getString("objectId"), UrlDirectlyUploader.this.parseFile.getUrl());
                        UrlDirectlyUploader.this.publishProgress(100);
                    }
                    catch (Exception ex) {
                        exceptionSaveFile[0] = new AVException(ex);
                    }
                } else {
                    exceptionSaveFile[0] = AVErrorUtils.createException(e, content);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                exceptionSaveFile[0] = AVErrorUtils.createException(error, content);
            }
        });
        return exceptionSaveFile[0];
    }

    private String getFileRequestParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", this.parseFile.getName());
        parameters.put("mime_type", this.parseFile.mimeType());
        parameters.put("metaData", this.parseFile.getMetaData());
        parameters.put("__type", AVFile.className());
        parameters.put("url", this.parseFile.getUrl());
        if (this.parseFile.getACL() != null) {
            parameters.putAll(AVUtils.getParsedMap(this.parseFile.getACL().getACLMap()));
        }
        return AVUtils.restfulServerData(parameters);
    }
}

