/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.FileUploader;
import com.avos.avoscloud.HttpClientUploader;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.okhttp.Call;
import com.avos.avoscloud.okhttp.MediaType;
import com.avos.avoscloud.okhttp.Request;
import com.avos.avoscloud.okhttp.RequestBody;
import com.avos.avoscloud.okhttp.Response;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.CRC32;

class QiniuUploader
extends HttpClientUploader {
    private String token;
    private String[] uploadFileCtx;
    private int blockCount;
    private String fileKey;
    private static final String QINIU_HOST = "https://up.qbox.me";
    private static final String QINIU_CREATE_BLOCK_EP = "https://up.qbox.me/mkblk/%d";
    private static final String QINIU_BRICK_UPLOAD_EP = "https://up.qbox.me/bput/%s/%d";
    private static final String QINIU_MKFILE_EP = "https://up.qbox.me/mkfile/%d/key/%s";
    private static final int WIFI_CHUNK_SIZE = 262144;
    private static final int BLOCK_SIZE = 0x400000;
    private static final int NONWIFI_CHUNK_SIZE = 65536;
    private static final int DEFAULT_RETRY_TIMES = 6;
    private FileUploader.ProgressCalculator progressCalculator;
    private volatile Call mergeFileRequestCall;
    private volatile Future[] tasks;
    private AVFile parseFile;
    int uploadChunkSize = 262144;
    static final ExecutorService fileUploadExecutor = Executors.newFixedThreadPool(10);

    QiniuUploader(AVFile parseFile, String token, String fileKey, SaveCallback saveCallback, ProgressCallback progressCallback) {
        super(saveCallback, progressCallback);
        this.parseFile = parseFile;
        this.token = token;
        this.fileKey = fileKey;
    }

    @Override
    public AVException doWork() {
        if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
            LogUtil.avlog.d("uploading with chunk size:" + this.uploadChunkSize);
        }
        return this.uploadWithBlocks();
    }

    private Request.Builder addAuthHeader(Request.Builder builder) throws Exception {
        if (this.token != null) {
            builder.addHeader("Authorization", "UpToken " + this.token);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AVException uploadWithBlocks() {
        try {
            byte[] bytes = this.parseFile.getData();
            this.blockCount = bytes.length / 0x400000 + (bytes.length % 0x400000 > 0 ? 1 : 0);
            this.uploadFileCtx = new String[this.blockCount];
            Object respBlockData = null;
            CountDownLatch latch = new CountDownLatch(this.blockCount);
            this.progressCalculator = new FileUploader.ProgressCalculator(this.blockCount, new FileUploader.FileUploadProgressCallback(){

                @Override
                public void onProgress(int progress) {
                    QiniuUploader.this.publishProgress(progress);
                }
            });
            Future[] futureArray = this.tasks = new Future[this.blockCount];
            synchronized (this.tasks) {
                for (int blockOffset = 0; blockOffset < this.blockCount; ++blockOffset) {
                    this.tasks[blockOffset] = fileUploadExecutor.submit(new FileBlockUploadTask(bytes, blockOffset, latch, this.uploadChunkSize, this.progressCalculator, this.uploadFileCtx, this));
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                latch.await();
                if (AVExceptionHolder.exists()) {
                    for (Future task : this.tasks) {
                        if (task.isDone()) continue;
                        task.cancel(true);
                    }
                    throw AVExceptionHolder.remove();
                }
                QiniuMKFileResponseData mkfileResp = this.makeFile(bytes.length, this.fileKey, 6);
                if (!(this.isCancelled() || mkfileResp != null && mkfileResp.key.equals(this.fileKey))) {
                    return AVErrorUtils.createException(-1, "upload file failure");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AVException(e);
        }
        return null;
    }

    private QiniuMKFileResponseData makeFile(int dataSize, String key, int retry) throws Exception {
        try {
            String endPoint = String.format(QINIU_MKFILE_EP, dataSize, AVUtils.Base64Encode(key));
            LinkedList<String> list = new LinkedList<String>();
            Collections.addAll(list, this.uploadFileCtx);
            String joinedFileCtx = AVUtils.joinCollection(list, ",");
            Request.Builder builder = new Request.Builder();
            builder.url(endPoint);
            builder = builder.post(RequestBody.create((MediaType)MediaType.parse((String)"text"), (String)joinedFileCtx));
            builder = this.addAuthHeader(builder);
            this.mergeFileRequestCall = QiniuUploader.getOKHttpClient().newCall(builder.build());
            return QiniuUploader.parseQiniuResponse(this.mergeFileRequestCall.execute(), QiniuMKFileResponseData.class);
        }
        catch (Exception e) {
            if (retry-- > 0) {
                return this.makeFile(dataSize, key, retry);
            }
            LogUtil.log.e("Exception during file upload", e);
            return null;
        }
    }

    private static <T> T parseQiniuResponse(Response resp, Class<T> clazz) throws Exception {
        int code = resp.code();
        String phrase = resp.message();
        String h = resp.header("X-Log");
        if (code == 401) {
            throw new Exception("unauthorized to create Qiniu Block");
        }
        String responseData = AVUtils.stringFromBytes(resp.body().bytes());
        try {
            if (code / 100 == 2) {
                Object data = JSON.parseObject((String)responseData, clazz);
                return (T)data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (responseData.length() > 0) {
            throw new Exception(code + ":" + responseData);
        }
        if (!AVUtils.isBlankString(h)) {
            throw new Exception(h);
        }
        throw new Exception(phrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void interruptImmediately() {
        super.interruptImmediately();
        if (this.tasks != null && this.tasks.length > 0) {
            Future[] futureArray = this.tasks;
            // MONITORENTER : this.tasks
            for (int index = 0; index < this.tasks.length; ++index) {
                Future task = this.tasks[index];
                if (task == null || task.isDone() || task.isCancelled()) continue;
                task.cancel(true);
            }
            // MONITOREXIT : futureArray
        }
        if (this.mergeFileRequestCall == null) return;
        this.mergeFileRequestCall.cancel();
    }

    private static class FileBlockUploadTask
    implements Runnable {
        private byte[] bytes;
        private int blockOffset;
        CountDownLatch latch;
        final int uploadChunkSize;
        FileUploader.ProgressCalculator progressCalculator;
        String[] uploadFileCtx;
        QiniuUploader parent;

        public FileBlockUploadTask(byte[] bytes, int blockOffset, CountDownLatch latch, int uploadChunkSize, FileUploader.ProgressCalculator progressCalculator, String[] uploadFileCtx, QiniuUploader parent) {
            this.bytes = bytes;
            this.blockOffset = blockOffset;
            this.latch = latch;
            this.uploadChunkSize = uploadChunkSize;
            this.progressCalculator = progressCalculator;
            this.uploadFileCtx = uploadFileCtx;
            this.parent = parent;
        }

        @Override
        public void run() {
            int currentBlockSize = this.getCurrentBlockSize(this.bytes, this.blockOffset);
            QiniuBlockResponseData respBlockData = this.createBlockInQiniu(this.blockOffset, currentBlockSize, 6, this.bytes);
            if (respBlockData != null) {
                respBlockData = this.putFileBlocksToQiniu(this.blockOffset, this.bytes, respBlockData, 6);
            }
            if (respBlockData != null) {
                this.uploadFileCtx[this.blockOffset] = respBlockData.ctx;
                this.progressCalculator.publishProgress(this.blockOffset, 100);
            } else {
                AVExceptionHolder.add(new AVException(-1, "Upload File failure"));
                for (long count = this.latch.getCount(); count > 0L; --count) {
                    this.latch.countDown();
                }
            }
            this.latch.countDown();
        }

        private QiniuBlockResponseData createBlockInQiniu(int blockOffset, int blockSize, int retry, byte[] data) {
            try {
                if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
                    LogUtil.avlog.d("try to mkblk");
                }
                String endPoint = String.format(QiniuUploader.QINIU_CREATE_BLOCK_EP, blockSize);
                Request.Builder builder = new Request.Builder();
                builder.url(endPoint);
                int nextChunkSize = this.getNextChunkSize(blockOffset, data);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.parent.parseFile.mimeType()), (byte[])data, (int)(blockOffset * 0x400000), (int)nextChunkSize);
                builder = builder.post(requestBody);
                builder = this.parent.addAuthHeader(builder);
                return (QiniuBlockResponseData)QiniuUploader.parseQiniuResponse(HttpClientUploader.getOKHttpClient().newCall(builder.build()).execute(), QiniuBlockResponseData.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (retry-- > 0) {
                    return this.createBlockInQiniu(blockOffset, blockSize, retry, data);
                }
                LogUtil.log.e("Exception during file upload", e);
                return null;
            }
        }

        private QiniuBlockResponseData putFileBlocksToQiniu(int blockOffset, byte[] data, QiniuBlockResponseData lastChunk, int retry) {
            int currentBlockLength = this.getCurrentBlockSize(data, blockOffset);
            this.progressCalculator.publishProgress(blockOffset, 100 * lastChunk.offset / 0x400000);
            int remainingBlockLength = currentBlockLength - lastChunk.offset;
            if (remainingBlockLength > 0 && lastChunk.offset > 0) {
                try {
                    String endPoint = String.format(QiniuUploader.QINIU_BRICK_UPLOAD_EP, lastChunk.ctx, lastChunk.offset);
                    Request.Builder builder = new Request.Builder();
                    builder.url(endPoint);
                    builder.addHeader("Content-Type", "application/octet-stream");
                    QiniuBlockResponseData chunkData = lastChunk;
                    int nextChunkSize = remainingBlockLength > this.uploadChunkSize ? this.uploadChunkSize : remainingBlockLength;
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.parent.parseFile.mimeType()), (byte[])data, (int)(blockOffset * 0x400000 + chunkData.offset), (int)nextChunkSize);
                    builder = builder.post(requestBody);
                    builder = this.parent.addAuthHeader(builder);
                    QiniuBlockResponseData respData = (QiniuBlockResponseData)QiniuUploader.parseQiniuResponse(HttpClientUploader.getOKHttpClient().newCall(builder.build()).execute(), QiniuBlockResponseData.class);
                    this.validateCrc32Value(respData, data, blockOffset * 0x400000 + chunkData.offset, nextChunkSize);
                    if (respData != null) {
                        if (respData.offset < currentBlockLength) {
                            return this.putFileBlocksToQiniu(blockOffset, data, respData, 6);
                        }
                        return respData;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (retry-- > 0) {
                        return this.putFileBlocksToQiniu(blockOffset, data, lastChunk, retry);
                    }
                    LogUtil.log.e("Exception during file upload", e);
                }
            } else {
                return lastChunk;
            }
            return null;
        }

        private void validateCrc32Value(QiniuBlockResponseData respData, byte[] data, int offset, int nextChunkSize) throws AVException {
            CRC32 crc32 = new CRC32();
            crc32.update(data, offset, nextChunkSize);
            long localCRC32 = crc32.getValue();
            if (respData != null && respData.crc32 != localCRC32) {
                throw new AVException(-1, "CRC32 validation failure for chunk upload");
            }
        }

        private int getCurrentBlockSize(byte[] bytes, int blockOffset) {
            return bytes.length - blockOffset * 0x400000 > 0x400000 ? 0x400000 : bytes.length - blockOffset * 0x400000;
        }

        private int getNextChunkSize(int blockOffset, byte[] data) {
            return data.length - blockOffset * 0x400000 > this.uploadChunkSize ? this.uploadChunkSize : data.length - blockOffset * 0x400000;
        }
    }

    private static class QiniuMKFileResponseData {
        public String key;
        public String hash;

        private QiniuMKFileResponseData() {
        }
    }

    private static class QiniuBlockResponseData {
        public String ctx;
        public long crc32;
        public int offset;
        public String host;
        public String checksum;

        private QiniuBlockResponseData() {
        }
    }
}

