/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.FileUploader;
import com.avos.avoscloud.HttpClientUploader;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.okhttp.MediaType;
import com.avos.avoscloud.okhttp.MultipartBuilder;
import com.avos.avoscloud.okhttp.Request;
import com.avos.avoscloud.okhttp.RequestBody;
import com.avos.avoscloud.okhttp.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

class QCloudUploader
extends HttpClientUploader {
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String FILE_CONTENT = "filecontent";
    private static final String PARAM_OP = "op";
    private static final String PARAM_SHA = "sha";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String PARAM_FILE_SIZE = "filesize";
    private static final String PARAM_SLICE_SIZE = "slice_size";
    private static final String PARAM_OFFSET = "offset";
    private static final String PARAM_SESSION = "session";
    private static final String OP_UPLOAD_SLICE = "upload_slice";
    private static final String OP_UPLOAD = "upload";
    private static final String PARAM_ACCESS_URL = "access_url";
    private static final int RETRY_TIMES = 5;
    private volatile Future[] tasks;
    boolean SHOULD_UPLOAD_SLICE_PARALL = false;
    private String fileSha;
    private String uploadUrl;
    private String fileKey;
    private String token;
    private AVFile parseFile;
    private static final int DEFAULT_SLICE_LEN = 524288;

    protected QCloudUploader(AVFile parseFile, String fileKey, String token, String uploadUrl, SaveCallback saveCallback, ProgressCallback progressCallback) {
        super(saveCallback, progressCallback);
        this.parseFile = parseFile;
        this.uploadUrl = uploadUrl;
        this.token = token;
        this.fileKey = fileKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AVException doWork() {
        try {
            byte[] bytes = this.parseFile.getData();
            int sliceCount = bytes.length / 524288 + (bytes.length % 524288 == 0 ? 0 : 1);
            if (sliceCount > 1) {
                JSONObject result = this.uploadControlSlice(this.token, this.uploadUrl, bytes);
                if (null == result) {
                    return new AVException(new RuntimeException("Exception during file upload"));
                }
                if (result.containsKey((Object)PARAM_ACCESS_URL)) {
                    return null;
                }
                String sessionId = result.getString(PARAM_SESSION);
                FileUploader.ProgressCalculator progressCalculator = new FileUploader.ProgressCalculator(sliceCount, new FileUploader.FileUploadProgressCallback(){

                    @Override
                    public void onProgress(int progress) {
                        QCloudUploader.this.publishProgress(progress);
                    }
                });
                if (this.SHOULD_UPLOAD_SLICE_PARALL) {
                    CountDownLatch latch = new CountDownLatch(sliceCount);
                    Future[] futureArray = this.tasks = new Future[sliceCount];
                    synchronized (this.tasks) {
                        for (int sliceOffset = 0; sliceOffset < sliceCount; ++sliceOffset) {
                            this.tasks[sliceOffset - 1] = executor.submit(new SliceUploadTask(this, this.fileKey, this.token, this.uploadUrl, bytes, sliceOffset, sessionId, progressCalculator, latch));
                        }
                        // ** MonitorExit[var7_10] (shouldn't be in output)
                        latch.await();
                    }
                } else {
                    for (int sliceOffset = 0; sliceOffset < sliceCount && !AVExceptionHolder.exists(); ++sliceOffset) {
                        new SliceUploadTask(this, this.fileKey, this.token, this.uploadUrl, bytes, sliceOffset, sessionId, progressCalculator, null).upload();
                    }
                }
                {
                    if (!AVExceptionHolder.exists()) return null;
                    if (this.tasks == null) throw AVExceptionHolder.remove();
                    for (Future task : this.tasks) {
                        if (task.isDone()) continue;
                        task.cancel(true);
                    }
                    throw AVExceptionHolder.remove();
                }
            }
            this.uploadFile();
            return null;
        }
        catch (Exception e) {
            return new AVException(e);
        }
    }

    private void uploadFile() throws AVException {
        try {
            if (InternalConfigurationController.globalInstance().getInternalLogger().showInternalDebugLog()) {
                LogUtil.log.d("upload as whole file");
            }
            byte[] bytes = this.parseFile.getData();
            this.fileSha = AVUtils.SHA1(bytes);
            MultipartBuilder builder = new MultipartBuilder();
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)APPLICATION_OCTET_STREAM), (byte[])bytes, (int)0, (int)QCloudUploader.getCurrentSliceLength(0, bytes.length));
            builder.addFormDataPart(FILE_CONTENT, this.fileKey, fileBody);
            builder.addFormDataPart(PARAM_OP, OP_UPLOAD);
            builder.addFormDataPart(PARAM_SHA, this.fileSha);
            builder.type(MediaType.parse((String)MULTIPART_FORM_DATA));
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(this.uploadUrl);
            requestBuilder.header(HEADER_AUTHORIZATION, this.token);
            requestBuilder.header(HEADER_CONTENT_TYPE, MULTIPART_FORM_DATA);
            requestBuilder.post(builder.build());
            try {
                Request request = requestBuilder.build();
                Response response = this.executeWithRetry(request, 5);
                if (response.code() != 200) {
                    throw AVErrorUtils.createException(-1, AVUtils.stringFromBytes(response.body().bytes()));
                }
            }
            catch (IOException e) {
                throw AVErrorUtils.createException(e, "Exception during file upload");
            }
        }
        catch (AVException e) {
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            throw AVErrorUtils.createException(e, "Exception during file upload");
        }
        catch (UnsupportedEncodingException e) {
            throw AVErrorUtils.createException(e, "Exception during file upload");
        }
    }

    protected static JSONObject parseSliceUploadResponse(String resp) {
        if (!AVUtils.isBlankContent(resp)) {
            try {
                JSONObject object = JSON.parseObject((String)resp);
                JSONObject data = object.getJSONObject("data");
                return data;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static int getCurrentSliceLength(int sliceCount, int totalSize) {
        int leftSize = totalSize - sliceCount * 524288;
        return leftSize >= 524288 ? 524288 : leftSize;
    }

    private JSONObject uploadControlSlice(String token, String url, byte[] wholeFile) throws AVException {
        MultipartBuilder builder = new MultipartBuilder();
        try {
            String fileSha = AVUtils.SHA1(wholeFile);
            builder.addFormDataPart(PARAM_SHA, fileSha);
            builder.addFormDataPart(PARAM_OP, OP_UPLOAD_SLICE);
            builder.addFormDataPart(PARAM_FILE_SIZE, String.valueOf(wholeFile.length));
            builder.addFormDataPart(PARAM_SLICE_SIZE, String.valueOf(524288));
            builder.type(MediaType.parse((String)MULTIPART_FORM_DATA));
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(url);
            requestBuilder.header(HEADER_AUTHORIZATION, token);
            requestBuilder.header(HEADER_CONTENT_TYPE, MULTIPART_FORM_DATA);
            requestBuilder.post(builder.build());
            Request request = requestBuilder.build();
            Response response = this.executeWithRetry(request, 5);
            if (response != null) {
                byte[] responseBody = response.body().bytes();
                return QCloudUploader.parseSliceUploadResponse(AVUtils.stringFromBytes(responseBody));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AVException(-1, "Upload file failure");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void interruptImmediately() {
        super.interruptImmediately();
        if (this.tasks == null || this.tasks.length <= 0) return;
        Future[] futureArray = this.tasks;
        synchronized (this.tasks) {
            for (int index = 0; index < this.tasks.length; ++index) {
                Future task = this.tasks[index];
                if (task == null || task.isDone() || task.isCancelled()) continue;
                task.cancel(true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static class SliceUploadTask
    implements Runnable {
        byte[] data;
        int sliceOffset;
        FileUploader.ProgressCalculator progress;
        String session;
        CountDownLatch latch;
        String key;
        String token;
        String url;
        QCloudUploader parent;

        public SliceUploadTask(QCloudUploader parent, String key, String token, String url, byte[] wholeFile, int sliceOffset, String session, FileUploader.ProgressCalculator progressCalculator, CountDownLatch latch) {
            this.data = wholeFile;
            this.sliceOffset = sliceOffset;
            this.progress = progressCalculator;
            this.session = session;
            this.latch = latch;
            this.key = key;
            this.token = token;
            this.url = url;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.upload();
        }

        public String upload() {
            block5: {
                try {
                    MultipartBuilder builder = new MultipartBuilder();
                    RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)QCloudUploader.APPLICATION_OCTET_STREAM), (byte[])this.data, (int)(this.sliceOffset * 524288), (int)QCloudUploader.getCurrentSliceLength(this.sliceOffset, this.data.length));
                    builder.addFormDataPart(QCloudUploader.FILE_CONTENT, this.key, fileBody);
                    builder.addFormDataPart(QCloudUploader.PARAM_OP, QCloudUploader.OP_UPLOAD_SLICE);
                    builder.addFormDataPart(QCloudUploader.PARAM_OFFSET, String.valueOf(this.sliceOffset * 524288));
                    builder.addFormDataPart(QCloudUploader.PARAM_SESSION, this.session);
                    builder.type(MediaType.parse((String)QCloudUploader.MULTIPART_FORM_DATA));
                    Request.Builder requestBuilder = new Request.Builder();
                    requestBuilder.url(this.url);
                    requestBuilder.header(QCloudUploader.HEADER_AUTHORIZATION, this.token);
                    requestBuilder.header(QCloudUploader.HEADER_CONTENT_TYPE, QCloudUploader.MULTIPART_FORM_DATA);
                    requestBuilder.post(builder.build());
                    Request request = requestBuilder.build();
                    Response response = this.parent.executeWithRetry(request, 5);
                    if (response != null) {
                        byte[] responseBody = response.body().bytes();
                        if (this.progress != null) {
                            this.progress.publishProgress(this.sliceOffset, 100);
                        }
                        return AVUtils.stringFromBytes(responseBody);
                    }
                }
                catch (Exception e) {
                    AVExceptionHolder.add(new AVException(e));
                    if (this.latch == null) break block5;
                    for (long count = this.latch.getCount(); count > 0L; --count) {
                        this.latch.countDown();
                    }
                }
            }
            return null;
        }
    }
}

