/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONHelper {
    public static Object toJSON(Object object) throws JSONException {
        if (object instanceof Map) {
            JSONObject json = new JSONObject();
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                json.put(key.toString(), JSONHelper.toJSON(map.get(key)));
            }
            return json;
        }
        if (object instanceof Iterable) {
            JSONArray json = new JSONArray();
            for (Object value : (Iterable)object) {
                json.put(value);
            }
            return json;
        }
        return object;
    }

    public static boolean isEmptyObject(JSONObject object) {
        return object.names() == null;
    }

    public static Map<String, Object> getMap(JSONObject object, String key) throws JSONException {
        return JSONHelper.toMap(object.getJSONObject(key));
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, JSONHelper.fromJson(object.get(key)));
        }
        return map;
    }

    public static Map<String, Object> mapFromString(String content) throws JSONException {
        JSONObject jsonObject = new JSONObject(content);
        Map<String, Object> map = JSONHelper.toMap(jsonObject);
        return map;
    }

    public static List toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(JSONHelper.fromJson(array.get(i)));
        }
        return list;
    }

    private static Object fromJson(Object json) throws JSONException {
        if (json == JSONObject.NULL) {
            return null;
        }
        if (json instanceof JSONObject) {
            return JSONHelper.toMap((JSONObject)json);
        }
        if (json instanceof JSONArray) {
            return JSONHelper.toList((JSONArray)json);
        }
        return json;
    }

    public static String toJsonString(Map<String, Object> map) {
        JSONObject object = new JSONObject(map);
        String jsonString = object.toString();
        return jsonString;
    }
}

