/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.Uploader;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.okhttp.OkHttpClient;
import com.avos.avoscloud.okhttp.Request;
import com.avos.avoscloud.okhttp.Response;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class HttpClientUploader
implements Uploader {
    SaveCallback saveCallback;
    ProgressCallback progressCallback;
    static OkHttpClient client = new OkHttpClient();
    private volatile boolean cancelled = false;
    private volatile Future future;
    static ThreadPoolExecutor executor;
    private static final int CPU_COUNT;
    private static final int CORE_POOL_SIZE;
    private static final int MAX_POOL_SIZE;
    private static final long KEEP_ALIVE_TIME = 1L;

    public HttpClientUploader(SaveCallback saveCallback, ProgressCallback progressCallback) {
        this.saveCallback = saveCallback;
        this.progressCallback = progressCallback;
        this.cancelled = false;
        InternalConfigurationController.globalInstance().getAppConfiguration().setupThreadPoolExecutor(executor);
    }

    protected static synchronized OkHttpClient getOKHttpClient() {
        client.setReadTimeout(30L, TimeUnit.SECONDS);
        return client;
    }

    protected Response executeWithRetry(Request request, int retry) throws AVException {
        if (retry > 0 && !this.isCancelled()) {
            try {
                Response response = HttpClientUploader.getOKHttpClient().newCall(request).execute();
                if (response.code() / 100 == 2) {
                    return response;
                }
                if (InternalConfigurationController.globalInstance().getInternalLogger().showInternalDebugLog()) {
                    LogUtil.avlog.d(AVUtils.stringFromBytes(response.body().bytes()));
                }
                return this.executeWithRetry(request, retry - 1);
            }
            catch (IOException e) {
                return this.executeWithRetry(request, retry - 1);
            }
        }
        throw new AVException(-1, "Upload File failure");
    }

    @Override
    public void publishProgress(int progress) {
        if (this.progressCallback != null) {
            this.progressCallback.internalDone(progress, null);
        }
    }

    @Override
    public void execute() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AVException exception = HttpClientUploader.this.doWork();
                if (!HttpClientUploader.this.cancelled) {
                    if (HttpClientUploader.this.saveCallback != null) {
                        HttpClientUploader.this.saveCallback.internalDone(exception);
                    }
                } else if (HttpClientUploader.this.saveCallback != null) {
                    HttpClientUploader.this.saveCallback.internalDone(AVErrorUtils.createException(999, "Uploading file task is canceled."));
                }
            }
        };
        this.future = executor.submit(task);
    }

    @Override
    public boolean cancel(boolean interrupt) {
        if (this.cancelled) {
            return false;
        }
        this.cancelled = true;
        if (interrupt) {
            this.interruptImmediately();
        } else if (this.future != null) {
            this.future.cancel(false);
        }
        return true;
    }

    public void interruptImmediately() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    static {
        CPU_COUNT = Runtime.getRuntime().availableProcessors();
        CORE_POOL_SIZE = CPU_COUNT + 1;
        MAX_POOL_SIZE = CPU_COUNT * 2 + 1;
        executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }
}

