/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.AsyncHttpResponseHandler;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.okhttp.internal.framed.Header;

public class GetHttpResponseHandler
extends AsyncHttpResponseHandler {
    private String absoluteURLString;
    private AVQuery.CachePolicy policy = AVQuery.CachePolicy.IGNORE_CACHE;

    public GetHttpResponseHandler(GenericObjectCallback cb) {
        super(cb);
    }

    public GetHttpResponseHandler(GenericObjectCallback cb, AVQuery.CachePolicy policy, String absoluteURLString) {
        this(cb);
        this.policy = policy;
        this.absoluteURLString = absoluteURLString;
    }

    private boolean isNotModifiedStatus(int code) {
        return code == 304;
    }

    private boolean isUnAuthorize(int code) {
        return code == 401;
    }

    private void tryLastModifyCache(String lastModifiedValue) {
        if (this.getCallback() == null) {
            return;
        }
        if (lastModifiedValue == null) {
            LogUtil.log.d("null last-modified value");
        } else if (PaasClient.getLastModify(this.absoluteURLString) == null) {
            PaasClient.updateLastModify(this.absoluteURLString, lastModifiedValue);
        }
        InternalConfigurationController.globalInstance().getCache().get(this.absoluteURLString, Long.MAX_VALUE, lastModifiedValue, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                GetHttpResponseHandler.this.getCallback().onSuccess(content, null);
            }

            @Override
            public void onFailure(Throwable error, String content) {
                PaasClient.removeLastModifyForUrl(GetHttpResponseHandler.this.absoluteURLString);
                GetHttpResponseHandler.this.getCallback().onFailure(error, content);
            }
        });
    }

    @Override
    public void onSuccess(int statusCode, Header[] headers, byte[] body) {
        String content = AVUtils.stringFromBytes(body);
        if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
            LogUtil.avlog.d(content);
        }
        if (this.isNotModifiedStatus(statusCode)) {
            if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
                LogUtil.avlog.i("Last modify matched.");
            }
            String lastModifiedValue = PaasClient.lastModifyFromHeaders(headers);
            this.tryLastModifyCache(lastModifiedValue);
            return;
        }
        String contentType = AVUtils.extractContentType(headers);
        if (AVUtils.checkResponseType(statusCode, content, contentType, this.getCallback())) {
            return;
        }
        int code = AVErrorUtils.errorCode(content);
        if (code > 0) {
            if (this.getCallback() != null) {
                this.getCallback().onFailure(AVErrorUtils.createException(content), content);
            }
            return;
        }
        if (this.policy != AVQuery.CachePolicy.IGNORE_CACHE && !AVUtils.isBlankString(this.absoluteURLString)) {
            InternalConfigurationController.globalInstance().getCache().save(this.absoluteURLString, content, null);
        }
        if (!AVUtils.isBlankString(this.absoluteURLString) && PaasClient.isLastModifyEnabled()) {
            String lastModify = PaasClient.lastModifyFromHeaders(headers);
            if (InternalConfigurationController.globalInstance().getCache().save(this.absoluteURLString, content, lastModify)) {
                PaasClient.updateLastModify(this.absoluteURLString, lastModify);
            }
        }
        if (this.getCallback() != null) {
            this.getCallback().onSuccess(content, null);
        }
        InternalConfigurationController.globalInstance().getClientConfiguration().afterSuccess();
    }

    @Override
    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        String contentType;
        String content = AVUtils.stringFromBytes(responseBody);
        if (this.isUnAuthorize(statusCode)) {
            LogUtil.avlog.e(content + "\nerror:" + error + " for request:" + this.absoluteURLString);
        }
        if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
            LogUtil.avlog.e(content + "\nerror:" + error);
        }
        if (AVUtils.checkResponseType(statusCode, content, contentType = AVUtils.extractContentType(headers), this.getCallback())) {
            return;
        }
        if (this.getCallback() != null) {
            this.getCallback().onFailure(statusCode, error, content);
        }
    }
}

