/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.util.SparseArray;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.HttpClientUploader;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.QCloudUploader;
import com.avos.avoscloud.QiniuUploader;
import com.avos.avoscloud.S3Uploader;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.Uploader;
import java.util.HashMap;

class FileUploader
extends HttpClientUploader {
    protected AVFile parseFile;
    static final int PROGRESS_GET_TOKEN = 10;
    static final int PROGRESS_UPLOAD_FILE = 90;
    static final int PROGRESS_COMPLETE = 100;
    private String token;
    private String url;
    private String objectId;
    private String bucket;
    private String uploadUrl;
    private String provider;
    protected static final int defaultFileKeyLength = 40;

    protected FileUploader(AVFile parseFile, SaveCallback saveCallback, ProgressCallback progressCallback) {
        super(saveCallback, progressCallback);
        this.parseFile = parseFile;
    }

    @Override
    public AVException doWork() {
        AVException getBucketException;
        String fileKey = AVUtils.parseFileKey(this.parseFile.getName());
        if (AVUtils.isBlankString(this.uploadUrl) && (getBucketException = this.fetchUploadBucket("fileTokens", fileKey, true, new AVCallback<String>(){

            @Override
            protected void internalDone0(String s, AVException parseException) {
                if (null == parseException) {
                    FileUploader.this.handleGetBucketResponse(s);
                }
            }
        })) != null) {
            return getBucketException;
        }
        this.publishProgress(10);
        Uploader uploader = this.getUploaderImplementation(fileKey);
        AVException uploadException = uploader.doWork();
        if (uploadException == null) {
            this.parseFile.handleUploadedResponse(this.objectId, this.objectId, this.url);
            this.publishProgress(100);
            this.completeFileUpload(true);
            return null;
        }
        this.completeFileUpload(false);
        return uploadException;
    }

    private Uploader getUploaderImplementation(String fileKey) {
        if ("qcloud".equals(this.provider)) {
            return new QCloudUploader(this.parseFile, fileKey, this.token, this.uploadUrl, this.saveCallback, this.progressCallback);
        }
        if ("s3".equals(this.provider)) {
            return new S3Uploader(this.parseFile, this.uploadUrl, this.saveCallback, this.progressCallback);
        }
        return new QiniuUploader(this.parseFile, this.token, fileKey, this.saveCallback, this.progressCallback);
    }

    private AVException fetchUploadBucket(String path, String fileKey, boolean sync, final AVCallback<String> callback) {
        final AVException[] exceptionWhenGetBucket = new AVException[1];
        PaasClient.storageInstance().postObject(path, this.getGetBucketParameters(fileKey), sync, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                callback.internalDone0(content, e);
                exceptionWhenGetBucket[0] = e;
            }

            @Override
            public void onFailure(Throwable error, String content) {
                callback.internalDone0(null, AVErrorUtils.createException(error, content));
                exceptionWhenGetBucket[0] = AVErrorUtils.createException(error, content);
            }
        });
        if (null != exceptionWhenGetBucket[0]) {
            return exceptionWhenGetBucket[0];
        }
        return null;
    }

    private AVException handleGetBucketResponse(String responseStr) {
        if (!AVUtils.isBlankContent(responseStr)) {
            try {
                JSONObject jsonObject = JSON.parseObject((String)responseStr);
                this.bucket = jsonObject.getString("bucket");
                this.objectId = jsonObject.getString("objectId");
                this.uploadUrl = jsonObject.getString("upload_url");
                this.provider = jsonObject.getString("provider");
                this.token = jsonObject.getString("token");
                this.url = jsonObject.getString("url");
            }
            catch (JSONException e) {
                return new AVException(e);
            }
        }
        return null;
    }

    private String getGetBucketParameters(String fileKey) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("key", fileKey);
        parameters.put("name", this.parseFile.getName());
        parameters.put("mime_type", this.parseFile.mimeType());
        parameters.put("metaData", this.parseFile.getMetaData());
        parameters.put("__type", AVFile.className());
        if (this.parseFile.getACL() != null) {
            parameters.putAll(AVUtils.getParsedMap(this.parseFile.getACL().getACLMap()));
        }
        return AVUtils.restfulServerData(parameters);
    }

    private void completeFileUpload(boolean success) {
        if (!AVUtils.isBlankString(this.token)) {
            try {
                JSONObject completeResult = new JSONObject();
                completeResult.put("result", (Object)success);
                completeResult.put("token", (Object)this.token);
                PaasClient.storageInstance().postObject("fileCallback", completeResult.toJSONString(), false, new GenericObjectCallback(){});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface FileUploadProgressCallback {
        public void onProgress(int var1);
    }

    protected static class ProgressCalculator {
        SparseArray<Integer> blockProgress = new SparseArray();
        FileUploadProgressCallback callback;
        int fileBlockCount = 0;

        public ProgressCalculator(int blockCount, FileUploadProgressCallback callback) {
            this.callback = callback;
            this.fileBlockCount = blockCount;
        }

        public synchronized void publishProgress(int offset, int progress) {
            this.blockProgress.put(offset, (Object)progress);
            if (this.callback != null) {
                int progressSum = 0;
                for (int index = 0; index < this.blockProgress.size(); ++index) {
                    progressSum += ((Integer)this.blockProgress.valueAt(index)).intValue();
                }
                this.callback.onProgress(10 + 80 * progressSum / (100 * this.fileBlockCount));
            }
        }
    }
}

