/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVStatus;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.FindCallback;
import com.avos.avoscloud.InboxStatusFindCallback;
import java.util.Map;

public class AVStatusQuery
extends AVQuery<AVStatus> {
    private static final String END = "end";
    private long sinceId;
    private String inboxType;
    private long maxId;
    private boolean count;
    private AVUser owner;
    private boolean selfStatusQuery = false;

    public AVStatusQuery() {
        super("_Status", null);
        this.getInclude().add("source");
    }

    public void setSinceId(long sinceId) {
        this.sinceId = sinceId;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setInboxType(String inboxType) {
        this.inboxType = inboxType;
    }

    protected String getInboxType() {
        return this.inboxType;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void setMaxId(long maxId) {
        this.maxId = maxId;
    }

    public boolean isCount() {
        return this.count;
    }

    public void setCount(boolean count) {
        this.count = count;
    }

    public AVUser getOwner() {
        return this.owner;
    }

    public void setOwner(AVUser owner) {
        this.owner = owner;
    }

    protected void setSelfQuery(boolean isSelf) {
        this.selfStatusQuery = isSelf;
    }

    @Override
    public Map<String, String> assembleParameters() {
        if (this.selfStatusQuery && this.inboxType != null) {
            this.whereEqualTo("inboxType", this.inboxType);
        }
        super.assembleParameters();
        Map<String, String> p = this.getParameters();
        if (this.owner != null) {
            String ownerId = this.owner.getObjectId();
            Map<String, Object> ownerMap = AVUtils.mapFromUserObjectId(ownerId);
            p.put("owner", JSON.toJSONString(ownerMap));
        }
        if (this.sinceId > 0L) {
            p.put("sinceId", String.valueOf(this.sinceId));
        }
        if (!AVUtils.isBlankString(this.inboxType) && !this.selfStatusQuery) {
            p.put("inboxType", this.inboxType);
        }
        if (this.maxId > 0L) {
            p.put("maxId", String.valueOf(this.maxId));
        }
        if (this.count) {
            p.put("count", "1");
        }
        this.conditions.setParameters(p);
        return p;
    }

    @Override
    protected void processAdditionalInfo(String content, FindCallback<AVStatus> callback) {
        if (InboxStatusFindCallback.class.isAssignableFrom(callback.getClass())) {
            InboxStatusFindCallback statusCallback = (InboxStatusFindCallback)callback;
            boolean v = false;
            try {
                JSONObject results = JSON.parseObject((String)content);
                if (results.containsKey((Object)END)) {
                    v = results.getBoolean(END);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            statusCallback.setEnd(v);
        }
    }
}

