/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.okio.Buffer;
import java.util.HashMap;
import java.util.Map;

public class AVRequestParams {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String QUERY_COMPONENT_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    HashMap<String, ParameterValuePair> params = new HashMap();

    public AVRequestParams() {
    }

    public AVRequestParams(Map<String, String> params) {
        this();
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                this.put(param.getKey(), param.getValue());
            }
        }
    }

    public void put(String name, Object value) {
        this.params.put(AVRequestParams.canonicalize(name, QUERY_COMPONENT_ENCODE_SET, false, true), ParameterValuePair.getParameterValuePair(value.toString()));
    }

    public String getQueryString() {
        if (this.params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, ParameterValuePair> entry : this.params.entrySet()) {
            if (index > 0) {
                sb.append('&');
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue().encodedParam);
            ++index;
        }
        return sb.toString();
    }

    public String getWholeUrl(String url) {
        if (this.params.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        sb.append('?');
        int index = 0;
        for (Map.Entry<String, ParameterValuePair> entry : this.params.entrySet()) {
            if (index > 0) {
                sb.append('&');
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue().encodedParam);
            ++index;
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.params == null || this.params.isEmpty();
    }

    protected String getDumpQueryString() {
        if (this.params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, ParameterValuePair> entry : this.params.entrySet()) {
            if (index > 0) {
                sb.append('&');
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue().getParam());
            ++index;
        }
        return sb.toString();
    }

    static String canonicalize(String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean query) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (codePoint >= 32 && codePoint < 127 && encodeSet.indexOf(codePoint) == -1 && (codePoint != 37 || alreadyEncoded) && (!query || codePoint != 43)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(input, pos, i);
            AVRequestParams.canonicalize(out, input, i, limit, encodeSet, alreadyEncoded, query);
            return out.readUtf8();
        }
        return input.substring(pos, limit);
    }

    static void canonicalize(Buffer out, String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean query) {
        int codePoint;
        Buffer utf8Buffer = null;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (alreadyEncoded && (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13)) continue;
            if (query && codePoint == 43) {
                out.writeUtf8(alreadyEncoded ? "%20" : "%2B");
                continue;
            }
            if (codePoint < 32 || codePoint >= 127 || encodeSet.indexOf(codePoint) != -1 || codePoint == 37 && !alreadyEncoded) {
                if (utf8Buffer == null) {
                    utf8Buffer = new Buffer();
                }
                utf8Buffer.writeUtf8CodePoint(codePoint);
                while (!utf8Buffer.exhausted()) {
                    int b = utf8Buffer.readByte() & 0xFF;
                    out.writeByte(37);
                    out.writeByte((int)HEX_DIGITS[b >> 4 & 0xF]);
                    out.writeByte((int)HEX_DIGITS[b & 0xF]);
                }
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    static String canonicalize(String input, String encodeSet, boolean alreadyEncoded, boolean query) {
        return AVRequestParams.canonicalize(input, 0, input.length(), encodeSet, alreadyEncoded, query);
    }

    private static class ParameterValuePair {
        String encodedParam;
        String param;

        private ParameterValuePair() {
        }

        public String getEncodedParam() {
            return this.encodedParam;
        }

        public String getParam() {
            return this.param;
        }

        public static ParameterValuePair getParameterValuePair(String param, String encodedParam) {
            ParameterValuePair pair = new ParameterValuePair();
            pair.encodedParam = encodedParam;
            pair.param = param;
            return pair;
        }

        public static ParameterValuePair getParameterValuePair(String param) {
            ParameterValuePair pair = new ParameterValuePair();
            pair.encodedParam = AVRequestParams.canonicalize(param, AVRequestParams.QUERY_COMPONENT_ENCODE_SET, false, true);
            pair.param = param;
            return pair;
        }
    }
}

