/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVCloudQueryResult;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVGeoPoint;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVRequestParams;
import com.avos.avoscloud.AVResponse;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.CloudQueryCallback;
import com.avos.avoscloud.CountCallback;
import com.avos.avoscloud.DeleteCallback;
import com.avos.avoscloud.FindCallback;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetCallback;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.QueryConditions;
import com.avos.avoscloud.QueryOperation;
import com.avos.avoscloud.internal.InternalConfigurationController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AVQuery<T extends AVObject> {
    private static final String TAG = "com.parse.AVQuery";
    private Class<T> clazz;
    private String className;
    private Boolean isRunning;
    private CachePolicy cachePolicy = CachePolicy.IGNORE_CACHE;
    private long maxCacheAge = -1L;
    private String queryPath;
    private String externalQueryPath;
    private static final String CLOUD_QUERY_PATH = "cloudQuery";
    QueryConditions conditions;

    private AVQuery() {
    }

    Class<T> getClazz() {
        return this.clazz;
    }

    void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    List<String> getInclude() {
        return this.conditions.getInclude();
    }

    void setInclude(List<String> include) {
        this.conditions.setInclude(include);
    }

    Set<String> getSelectedKeys() {
        return this.conditions.getSelectedKeys();
    }

    void setSelectedKeys(Set<String> selectedKeys) {
        this.conditions.setSelectedKeys(selectedKeys);
    }

    Boolean getIsRunning() {
        return this.isRunning;
    }

    void setIsRunning(Boolean isRunning) {
        this.isRunning = isRunning;
    }

    Map<String, String> getParameters() {
        return this.conditions.getParameters();
    }

    void setParameters(Map<String, String> parameters) {
        this.conditions.setParameters(parameters);
    }

    String getQueryPath() {
        return this.queryPath;
    }

    void setQueryPath(String queryPath) {
        this.queryPath = queryPath;
    }

    String getExternalQueryPath() {
        return this.externalQueryPath;
    }

    void setExternalQueryPath(String path) {
        this.externalQueryPath = path;
    }

    static String getTag() {
        return TAG;
    }

    Map<String, List<QueryOperation>> getWhere() {
        return this.conditions.getWhere();
    }

    public String getClassName() {
        return this.className;
    }

    public AVQuery<T> setClassName(String className) {
        this.className = className;
        return this;
    }

    private void generateQueryPath() {
        if (AVUtils.isBlankString(this.queryPath)) {
            this.conditions.assembleParameters();
            this.queryPath = PaasClient.storageInstance().buildUrl(this.queryPath(), new AVRequestParams(this.getParameters()));
        }
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public AVQuery<T> setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy = cachePolicy;
        return this;
    }

    public CachePolicy getPolicy() {
        return this.cachePolicy;
    }

    @Deprecated
    public AVQuery<T> setPolicy(CachePolicy policy) {
        this.cachePolicy = policy;
        return this;
    }

    public long getMaxCacheAge() {
        return this.maxCacheAge;
    }

    public AVQuery<T> setMaxCacheAge(long maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
        return this;
    }

    public boolean isTrace() {
        return this.conditions.isTrace();
    }

    public AVQuery<T> setTrace(boolean trace) {
        this.conditions.setTrace(trace);
        return this;
    }

    public AVQuery(String theClassName) {
        this(theClassName, null);
    }

    AVQuery(String theClassName, Class<T> clazz) {
        AVUtils.checkClassName(theClassName);
        this.className = theClassName;
        this.clazz = clazz;
        this.conditions = new QueryConditions();
    }

    public static <T extends AVObject> AVQuery<T> getQuery(String theClassName) {
        return new AVQuery<T>(theClassName);
    }

    public static <T extends AVObject> AVQuery<T> getQuery(Class<T> clazz) {
        return new AVQuery<T>(AVObject.getSubClassName(clazz), clazz);
    }

    public void cancel() {
    }

    public static void clearAllCachedResults() {
        InternalConfigurationController.globalInstance().getCache().cleanAll();
    }

    public void clearCachedResult() {
        this.generateQueryPath();
        if (!AVUtils.isBlankString(this.queryPath)) {
            InternalConfigurationController.globalInstance().getCache().delete(this.queryPath);
        }
    }

    private String queryPath() {
        if (!AVUtils.isBlankString(this.externalQueryPath)) {
            return this.externalQueryPath;
        }
        return AVPowerfulUtils.getEndpoint(this.getClassName());
    }

    @Deprecated
    public static AVQuery<AVUser> getUserQuery() {
        return AVUser.getQuery();
    }

    public boolean hasCachedResult() {
        this.generateQueryPath();
        return !AVUtils.isBlankString(this.queryPath) && InternalConfigurationController.globalInstance().getCache().hasCache(this.queryPath);
    }

    public int getLimit() {
        return this.conditions.getLimit();
    }

    public AVQuery<T> setLimit(int limit) {
        this.conditions.setLimit(limit);
        return this;
    }

    public AVQuery<T> limit(int limit) {
        this.setLimit(limit);
        return this;
    }

    public AVQuery<T> skip(int skip) {
        this.setSkip(skip);
        return this;
    }

    public int getSkip() {
        return this.conditions.getSkip();
    }

    public AVQuery<T> setSkip(int skip) {
        this.conditions.setSkip(skip);
        return this;
    }

    public String getOrder() {
        return this.conditions.getOrder();
    }

    public AVQuery<T> setOrder(String order) {
        this.conditions.setOrder(order);
        return this;
    }

    public AVQuery<T> order(String order) {
        this.setOrder(order);
        return this;
    }

    public AVQuery<T> addAscendingOrder(String key) {
        this.conditions.addAscendingOrder(key);
        return this;
    }

    public AVQuery<T> addDescendingOrder(String key) {
        this.conditions.addDescendingOrder(key);
        return this;
    }

    public AVQuery<T> include(String key) {
        this.conditions.include(key);
        return this;
    }

    public AVQuery<T> selectKeys(Collection<String> keys) {
        this.conditions.selectKeys(keys);
        return this;
    }

    public AVQuery<T> orderByAscending(String key) {
        this.conditions.orderByAscending(key);
        return this;
    }

    public AVQuery<T> orderByDescending(String key) {
        this.conditions.orderByDescending(key);
        return this;
    }

    public AVQuery<T> whereContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.whereContainedIn(key, values);
        return this;
    }

    public AVQuery<T> whereContains(String key, String substring) {
        this.conditions.whereContains(key, substring);
        return this;
    }

    public AVQuery<T> whereSizeEqual(String key, int size) {
        this.conditions.whereSizeEqual(key, size);
        return this;
    }

    public AVQuery<T> whereContainsAll(String key, Collection<?> values) {
        this.conditions.whereContainsAll(key, values);
        return this;
    }

    public AVQuery<T> whereDoesNotExist(String key) {
        this.conditions.whereDoesNotExist(key);
        return this;
    }

    public AVQuery<T> whereEndsWith(String key, String suffix) {
        this.conditions.whereEndsWith(key, suffix);
        return this;
    }

    public AVQuery<T> whereEqualTo(String key, Object value) {
        this.conditions.whereEqualTo(key, value);
        return this;
    }

    private AVQuery<T> addWhereItem(QueryOperation op) {
        this.conditions.addWhereItem(op);
        return this;
    }

    private AVQuery<T> addOrItems(QueryOperation op) {
        this.conditions.addOrItems(op);
        return this;
    }

    private AVQuery<T> addAndItems(AVQuery query) {
        this.conditions.addAndItems(query.conditions);
        return this;
    }

    protected AVQuery<T> addWhereItem(String key, String op, Object value) {
        this.conditions.addWhereItem(key, op, value);
        return this;
    }

    public AVQuery<T> whereExists(String key) {
        this.conditions.whereExists(key);
        return this;
    }

    public AVQuery<T> whereGreaterThan(String key, Object value) {
        this.conditions.whereGreaterThan(key, value);
        return this;
    }

    public AVQuery<T> whereGreaterThanOrEqualTo(String key, Object value) {
        this.conditions.whereGreaterThanOrEqualTo(key, value);
        return this;
    }

    public AVQuery<T> whereLessThan(String key, Object value) {
        this.conditions.whereLessThan(key, value);
        return this;
    }

    public AVQuery<T> whereLessThanOrEqualTo(String key, Object value) {
        this.conditions.whereLessThanOrEqualTo(key, value);
        return this;
    }

    public AVQuery<T> whereMatches(String key, String regex) {
        this.conditions.whereMatches(key, regex);
        return this;
    }

    public AVQuery<T> whereMatches(String key, String regex, String modifiers) {
        this.conditions.whereMatches(key, regex, modifiers);
        return this;
    }

    public AVQuery<T> whereNear(String key, AVGeoPoint point) {
        this.conditions.whereNear(key, point);
        return this;
    }

    public AVQuery<T> whereNotContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.whereNotContainedIn(key, values);
        return this;
    }

    public AVQuery<T> whereNotEqualTo(String key, Object value) {
        this.conditions.whereNotEqualTo(key, value);
        return this;
    }

    public AVQuery<T> whereStartsWith(String key, String prefix) {
        this.conditions.whereStartsWith(key, prefix);
        return this;
    }

    public AVQuery<T> whereWithinGeoBox(String key, AVGeoPoint southwest, AVGeoPoint northeast) {
        this.conditions.whereWithinGeoBox(key, southwest, northeast);
        return this;
    }

    public AVQuery<T> whereWithinKilometers(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinKilometers(key, point, maxDistance);
        return this;
    }

    public AVQuery<T> whereWithinKilometers(String key, AVGeoPoint point, double maxDistance, double minDistance) {
        this.conditions.whereWithinKilometers(key, point, maxDistance, minDistance);
        return this;
    }

    public AVQuery<T> whereWithinMiles(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinMiles(key, point, maxDistance);
        return this;
    }

    public AVQuery<T> whereWithinMiles(String key, AVGeoPoint point, double maxDistance, double minDistance) {
        this.conditions.whereWithinMiles(key, point, maxDistance, minDistance);
        return this;
    }

    public AVQuery<T> whereWithinRadians(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinRadians(key, point, maxDistance);
        return this;
    }

    public AVQuery<T> whereWithinRadians(String key, AVGeoPoint point, double maxDistance, double minDistance) {
        this.conditions.whereWithinRadians(key, point, maxDistance, minDistance);
        return this;
    }

    public static <T extends AVObject> AVQuery<T> or(List<AVQuery<T>> queries) {
        String className = null;
        if (queries.size() > 0) {
            className = queries.get(0).getClassName();
        }
        AVQuery<T> result = new AVQuery<T>(className);
        if (queries.size() > 1) {
            for (AVQuery<T> query : queries) {
                if (!className.equals(query.getClassName())) {
                    throw new IllegalArgumentException("All queries must be for the same class");
                }
                super.addOrItems(new QueryOperation("$or", "$or", query.conditions.compileWhereOperationMap()));
            }
        } else {
            result.setWhere(queries.get((int)0).conditions.getWhere());
        }
        return result;
    }

    public static <T extends AVObject> AVQuery<T> and(List<AVQuery<T>> queries) {
        String className = null;
        if (queries.size() > 0) {
            className = queries.get(0).getClassName();
        }
        AVQuery<T> result = new AVQuery<T>(className);
        if (queries.size() > 1) {
            for (AVQuery<T> query : queries) {
                if (!className.equals(query.getClassName())) {
                    throw new IllegalArgumentException("All queries must be for the same class");
                }
                super.addAndItems(query);
            }
        } else {
            result.setWhere(queries.get((int)0).conditions.getWhere());
        }
        return result;
    }

    public AVQuery<T> whereMatchesKeyInQuery(String key, String keyInQuery, AVQuery<?> query) {
        HashMap<String, Object> inner = new HashMap<String, Object>();
        inner.put("className", query.getClassName());
        inner.put("where", query.conditions.compileWhereOperationMap());
        if (query.conditions.getSkip() > 0) {
            inner.put("skip", query.conditions.getSkip());
        }
        if (query.conditions.getLimit() > 0) {
            inner.put("limit", query.conditions.getLimit());
        }
        if (!AVUtils.isBlankContent(query.getOrder())) {
            inner.put("order", query.getOrder());
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("query", inner);
        queryMap.put("key", keyInQuery);
        return this.addWhereItem(key, "$select", queryMap);
    }

    public AVQuery<T> whereMatchesQuery(String key, AVQuery<?> query) {
        Map<String, Object> map = AVUtils.createMap("where", query.conditions.compileWhereOperationMap());
        map.put("className", query.className);
        if (query.conditions.getSkip() > 0) {
            map.put("skip", query.conditions.getSkip());
        }
        if (query.conditions.getLimit() > 0) {
            map.put("limit", query.conditions.getLimit());
        }
        if (!AVUtils.isBlankContent(query.getOrder())) {
            map.put("order", query.getOrder());
        }
        this.addWhereItem(key, "$inQuery", map);
        return this;
    }

    public AVQuery<T> whereDoesNotMatchKeyInQuery(String key, String keyInQuery, AVQuery<?> query) {
        Map<String, Object> map = AVUtils.createMap("className", query.className);
        map.put("where", query.conditions.compileWhereOperationMap());
        Map<String, Object> queryMap = AVUtils.createMap("query", map);
        queryMap.put("key", keyInQuery);
        this.addWhereItem(key, "$dontSelect", queryMap);
        return this;
    }

    public AVQuery<T> whereDoesNotMatchQuery(String key, AVQuery<?> query) {
        Map<String, Object> map = AVUtils.createMap("className", query.className);
        map.put("where", query.conditions.compileWhereOperationMap());
        this.addWhereItem(key, "$notInQuery", map);
        return this;
    }

    AVQuery<T> setWhere(Map<String, List<QueryOperation>> value) {
        this.conditions.setWhere(value);
        return this;
    }

    public static AVCloudQueryResult doCloudQuery(String cql, Object ... params) throws Exception {
        final AVCloudQueryResult returnValue = new AVCloudQueryResult();
        AVQuery.doCloudQueryInBackground(cql, new CloudQueryCallback<AVCloudQueryResult>(){

            @Override
            public void done(AVCloudQueryResult result, AVException parseException) {
                if (parseException != null) {
                    AVExceptionHolder.add(AVErrorUtils.createException(parseException, null));
                } else {
                    returnValue.setCount(result.getCount());
                    returnValue.setResults(result.getResults());
                }
            }
        }, AVObject.class, true, params);
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return returnValue;
    }

    public static AVCloudQueryResult doCloudQuery(String cql, Class<? extends AVObject> clazz, Object ... params) throws Exception {
        final AVCloudQueryResult returnValue = new AVCloudQueryResult();
        AVQuery.doCloudQueryInBackground(cql, new CloudQueryCallback<AVCloudQueryResult>(){

            @Override
            public void done(AVCloudQueryResult result, AVException parseException) {
                if (parseException != null) {
                    AVExceptionHolder.add(AVErrorUtils.createException(parseException, null));
                } else {
                    returnValue.setCount(result.getCount());
                    returnValue.setResults(result.getResults());
                }
            }
        }, clazz, true, params);
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return returnValue;
    }

    public static void doCloudQueryInBackground(String cql, CloudQueryCallback<AVCloudQueryResult> callback, Object ... params) {
        AVQuery.doCloudQueryInBackground(cql, callback, AVObject.class, false, params);
    }

    public static void doCloudQueryInBackground(String cql, CloudQueryCallback<AVCloudQueryResult> callback, Class<? extends AVObject> clazz, Object ... params) {
        AVQuery.doCloudQueryInBackground(cql, callback, clazz, false, params);
    }

    public static AVCloudQueryResult doCloudQuery(String cql) throws Exception {
        return AVQuery.doCloudQuery(cql, AVObject.class);
    }

    public static AVCloudQueryResult doCloudQuery(String cql, Class<? extends AVObject> clazz) throws Exception {
        final AVCloudQueryResult returnValue = new AVCloudQueryResult();
        AVQuery.doCloudQueryInBackground(cql, new CloudQueryCallback<AVCloudQueryResult>(){

            @Override
            public void done(AVCloudQueryResult result, AVException parseException) {
                if (parseException != null) {
                    AVExceptionHolder.add(AVErrorUtils.createException(parseException, null));
                } else {
                    returnValue.setCount(result.getCount());
                    returnValue.setResults(result.getResults());
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        }, clazz, true, null);
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return returnValue;
    }

    public static void doCloudQueryInBackground(String cql, CloudQueryCallback<AVCloudQueryResult> callback) {
        AVQuery.doCloudQueryInBackground(cql, callback, AVObject.class, false, null);
    }

    public static void doCloudQueryInBackground(String cql, CloudQueryCallback<AVCloudQueryResult> callback, Class<? extends AVObject> clazz) {
        AVQuery.doCloudQueryInBackground(cql, callback, clazz, false, null);
    }

    private static void doCloudQueryInBackground(String cql, final CloudQueryCallback<AVCloudQueryResult> callback, final Class<? extends AVObject> clazz, boolean sync, Object[] params) {
        LinkedList<Object> pvalue = new LinkedList<Object>();
        if (params != null) {
            for (Object o : params) {
                pvalue.add(o);
            }
        }
        AVRequestParams p = new AVRequestParams();
        p.put("cql", cql);
        if (!AVUtils.isEmptyList(pvalue)) {
            p.put("pvalues", AVUtils.jsonStringFromObjectWithNull(pvalue));
        }
        PaasClient.storageInstance().getObject(CLOUD_QUERY_PATH, p, sync, null, new GenericObjectCallback(){

            @Override
            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }

            @Override
            public void onSuccess(String content, AVException e) {
                block3: {
                    try {
                        AVCloudQueryResult result = AVQuery.processCloudResults(content, clazz);
                        if (callback != null) {
                            callback.internalDone(result, null);
                        }
                    }
                    catch (Exception processException) {
                        if (callback == null) break block3;
                        callback.internalDone(null, AVErrorUtils.createException(processException, null));
                    }
                }
            }
        });
    }

    private static <T extends AVObject> AVCloudQueryResult processCloudResults(String content, Class<T> clazz) throws Exception {
        AVCloudQueryResult result = new AVCloudQueryResult();
        if (AVUtils.isBlankContent(content)) {
            List emptyResult = Collections.emptyList();
            result.setResults(emptyResult);
            return result;
        }
        AVResponse resp = new AVResponse();
        resp = (AVResponse)JSON.parseObject((String)content, resp.getClass());
        LinkedList<AVObject> objects = new LinkedList<AVObject>();
        if (resp.results != null) {
            for (Map item : resp.results) {
                AVObject object;
                if (item == null || item.isEmpty()) continue;
                if (clazz != null) {
                    object = (AVObject)clazz.newInstance();
                    if (AVUtils.isBlankString(object.getClassName())) {
                        object.setClassName(resp.className);
                    }
                } else {
                    object = new AVObject(resp.className);
                }
                AVUtils.copyPropertiesFromMapToAVObject(item, object);
                objects.add(object);
            }
        }
        result.setCount(resp.count);
        result.setResults(objects);
        return result;
    }

    protected void processAdditionalInfo(String content, FindCallback<T> callback) {
    }

    protected List<T> processResults(String content) throws Exception {
        if (AVUtils.isBlankContent(content)) {
            return Collections.emptyList();
        }
        AVResponse resp = new AVResponse();
        resp = (AVResponse)JSON.parseObject((String)content, resp.getClass());
        LinkedList<AVObject> result = new LinkedList<AVObject>();
        for (Map item : resp.results) {
            if (item == null || item.isEmpty()) continue;
            AVObject object = this.clazz != null ? (AVObject)this.clazz.newInstance() : AVUtils.newAVObjectByClassName(resp.className, this.getClassName());
            AVUtils.copyPropertiesFromMapToAVObject(item, object);
            object.rebuildInstanceData();
            result.add(object);
        }
        return result;
    }

    public void findInBackground(FindCallback<T> callback) {
        this.assembleParameters();
        final FindCallback<T> internalCallback = callback;
        String path = this.queryPath();
        this.queryPath = PaasClient.storageInstance().getObject(path, new AVRequestParams(this.getParameters()), false, null, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                block3: {
                    try {
                        List result = AVQuery.this.processResults(content);
                        AVQuery.this.processAdditionalInfo(content, internalCallback);
                        if (internalCallback != null) {
                            internalCallback.internalDone(result, null);
                        }
                    }
                    catch (Exception ex) {
                        if (internalCallback == null) break block3;
                        internalCallback.internalDone(null, AVErrorUtils.createException(ex, null));
                    }
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, this.cachePolicy, this.maxCacheAge);
    }

    public T get(String theObjectId) throws AVException {
        final Object[] result = new Object[]{null};
        this.getInBackground(theObjectId, true, new GetCallback<T>(){

            @Override
            public void done(T object, AVException e) {
                if (e == null) {
                    result[0] = object;
                } else {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return (T)((AVObject)result[0]);
    }

    public T getFirst() throws AVException {
        final Object[] result = new Object[]{null};
        this.getFirstInBackground(true, new GetCallback<T>(){

            @Override
            public void done(AVObject object, AVException e) {
                if (e == null) {
                    result[0] = object;
                } else {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return (T)((AVObject)result[0]);
    }

    public void getFirstInBackground(GetCallback<T> callback) {
        this.getFirstInBackground(false, callback);
    }

    private void getFirstInBackground(boolean sync, GetCallback<T> callback) {
        this.assembleParameters();
        Map<String, String> parameters = this.getParameters();
        parameters.put("limit", Integer.toString(1));
        final GetCallback<T> internalCallback = callback;
        PaasClient.storageInstance().getObject(this.queryPath(), new AVRequestParams(this.getParameters()), sync, null, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                block3: {
                    try {
                        List result = AVQuery.this.processResults(content);
                        if (internalCallback != null) {
                            AVObject first = null;
                            AVException error = null;
                            first = result.size() > 0 ? (AVObject)result.get(0) : null;
                            internalCallback.internalDone(first, error);
                        }
                    }
                    catch (Exception ex) {
                        if (internalCallback == null) break block3;
                        internalCallback.internalDone(null, AVErrorUtils.createException(ex, null));
                    }
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    public void getInBackground(String objectId, GetCallback<T> callback) {
        final GetCallback<T> internalCallback = callback;
        this.getInBackground(objectId, false, new GetCallback<T>(){

            @Override
            public void done(T object, AVException e) {
                if (internalCallback != null) {
                    internalCallback.internalDone(object, e);
                }
            }
        });
    }

    private void getInBackground(String objectId, boolean sync, GetCallback<T> callback) {
        String path = AVPowerfulUtils.getEndpointByAVClassName(this.getClassName(), objectId);
        final GetCallback<T> internalCallback = callback;
        this.assembleParameters();
        PaasClient.storageInstance().getObject(path, new AVRequestParams(this.getParameters()), sync, null, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                AVException error;
                AVObject object;
                block9: {
                    object = null;
                    error = e;
                    if (AVUtils.isBlankContent(content)) {
                        object = null;
                        error = new AVException(101, "Object is not found.");
                    } else {
                        try {
                            if (AVQuery.this.clazz != null) {
                                try {
                                    object = (AVObject)AVQuery.this.clazz.newInstance();
                                }
                                catch (Exception er) {
                                    internalCallback.internalDone(AVErrorUtils.createException(er, "Please create non-params constructor"));
                                }
                            } else {
                                object = AVUtils.newAVObjectByClassName(AVQuery.this.getClassName());
                            }
                            AVUtils.copyPropertiesFromJsonStringToAVObject(content, object);
                            object.rebuildInstanceData();
                        }
                        catch (Exception exception) {
                            if (internalCallback == null) break block9;
                            internalCallback.internalDone(object, new AVException(exception));
                        }
                    }
                }
                if (internalCallback != null) {
                    internalCallback.internalDone(object, error);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    public int count() throws AVException {
        final int[] value = new int[]{0};
        this.countInBackground(true, new CountCallback(){

            @Override
            public void done(int count, AVException e) {
                if (e == null) {
                    value[0] = count;
                } else {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return value[0];
    }

    protected int count(boolean needsLock) {
        final int[] value = new int[]{0};
        this.countInBackground(true, new CountCallback(){

            @Override
            public void done(int count, AVException e) {
                value[0] = count;
            }
        });
        return value[0];
    }

    public void countInBackground(CountCallback callback) {
        this.countInBackground(false, callback);
    }

    private void countInBackground(boolean sync, CountCallback callback) {
        this.conditions.assembleParameters();
        Map<String, String> parameters = this.conditions.getParameters();
        parameters.put("count", "1");
        parameters.put("limit", "0");
        final CountCallback internalCallback = callback;
        String path = this.queryPath();
        this.queryPath = PaasClient.storageInstance().getObject(path, new AVRequestParams(this.getParameters()), sync, null, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                try {
                    AVResponse resp = (AVResponse)JSON.parseObject((String)content, AVResponse.class);
                    if (internalCallback != null) {
                        internalCallback.internalDone(resp.count, null);
                    }
                }
                catch (Exception jsonParseException) {
                    internalCallback.internalDone(AVErrorUtils.createException(jsonParseException, "Exception during response parse"));
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(0, AVErrorUtils.createException(error, content));
                }
            }
        }, this.cachePolicy, this.maxCacheAge);
    }

    public List<T> find() throws AVException {
        String path = this.queryPath();
        this.assembleParameters();
        final ArrayList result = new ArrayList();
        this.queryPath = PaasClient.storageInstance().getObject(path, new AVRequestParams(this.getParameters()), true, null, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                try {
                    result.addAll(AVQuery.this.processResults(content));
                }
                catch (Exception ex) {
                    AVExceptionHolder.add(AVErrorUtils.createException(ex, null));
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                AVExceptionHolder.add(AVErrorUtils.createException(error, content));
            }
        }, this.cachePolicy, this.maxCacheAge);
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return result;
    }

    public void deleteAll() throws AVException {
        AVObject.deleteAll(this.find());
    }

    public void deleteAllInBackground(final DeleteCallback cb) {
        this.findInBackground(new FindCallback<T>(){

            @Override
            public void done(List<T> parseObjects, AVException parseException) {
                if (parseException != null) {
                    cb.internalDone(null, parseException);
                } else {
                    AVObject.deleteAllInBackground(parseObjects, cb);
                }
            }
        });
    }

    protected Map<String, String> assembleParameters() {
        return this.conditions.assembleParameters();
    }

    public static enum CachePolicy {
        CACHE_ELSE_NETWORK,
        CACHE_ONLY,
        CACHE_THEN_NETWORK,
        IGNORE_CACHE,
        NETWORK_ELSE_CACHE,
        NETWORK_ONLY;

    }
}

