/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.FunctionCallback;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class AVCloud {
    public static void setProductionMode(boolean productionMode) {
        PaasClient.cloudInstance().setProduction(productionMode);
    }

    public static <T> T callFunction(String name, Map<String, ?> params) throws AVException {
        final AtomicReference reference = new AtomicReference();
        PaasClient.cloudInstance().postObject("functions/" + name, AVUtils.restfulServerData(params), true, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                reference.set(AVCloud.convertCloudResponse(content));
            }

            @Override
            public void onFailure(Throwable error, String content) {
                LogUtil.log.d(content + error);
                AVExceptionHolder.add(AVErrorUtils.createException(error, content));
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return (T)reference.get();
    }

    public static <T> void callFunctionInBackground(String name, Map<String, ?> params, final FunctionCallback<T> callback) {
        PaasClient.cloudInstance().postObject("functions/" + name, AVUtils.restfulServerData(params), false, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                if (callback != null) {
                    callback.internalDone(AVCloud.convertCloudResponse(content), e);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    public static Object convertCloudResponse(String response) {
        Object newResultValue = null;
        if (AVUtils.isBlankString(response)) {
            return null;
        }
        try {
            Map resultMap = AVUtils.getFromJSON(response, Map.class);
            Object resultValue = resultMap.get("result");
            newResultValue = resultValue instanceof Collection ? AVUtils.getObjectFrom((Collection)resultValue) : (resultValue instanceof Map ? AVUtils.getObjectFrom((Map)resultValue) : resultValue);
        }
        catch (Exception e) {
            LogUtil.log.e("Error during response parse", e);
        }
        return newResultValue;
    }

    public static <T> void rpcFunctionInBackground(String name, Object params, FunctionCallback<T> callback) {
        AVCloud.rpcFunctionInBackground(name, params, false, callback);
    }

    public static <T> T rpcFunction(String name, Object params) throws AVException {
        final AtomicReference reference = new AtomicReference();
        AVCloud.rpcFunctionInBackground(name, params, true, new FunctionCallback<T>(){

            @Override
            public void done(T object, AVException e) {
                if (e == null) {
                    reference.set(object);
                } else {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return (T)reference.get();
    }

    private static <T> void rpcFunctionInBackground(String name, Object params, boolean sync, final FunctionCallback<T> callback) {
        String paramString = AVUtils.restfulCloudData(params);
        PaasClient.cloudInstance().postObject("call/" + name, paramString, sync, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                callback.internalDone(AVCloud.convertCloudResponse(content), e);
            }

            @Override
            public void onFailure(Throwable error, String content) {
                LogUtil.log.d(content + error);
                callback.internalDone(null, AVErrorUtils.createException(error, content));
            }
        });
    }
}

