/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.ops;

import com.alibaba.fastjson.annotation.JSONType;
import com.avos.avoscloud.ops.AVOp;
import com.avos.avoscloud.ops.BaseOp;
import com.avos.avoscloud.ops.CompoundOp;
import com.avos.avoscloud.ops.SingleValueOp;
import java.util.HashMap;
import java.util.Map;

@JSONType(ignores={"amount"})
public class IncrementOp
extends BaseOp
implements SingleValueOp {
    protected Number amount;

    public IncrementOp() {
    }

    @Override
    public void setValues(Object values) {
        this.amount = (Number)values;
    }

    public Number getAmount() {
        return this.amount;
    }

    void setAmount(Number amount) {
        this.amount = amount;
    }

    public IncrementOp(String key, Number amount) {
        super(key, AVOp.OpType.Increment);
        this.amount = amount;
    }

    @Override
    public Map<String, Object> encodeOp() {
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        subMap.put("__op", "Increment");
        subMap.put("amount", this.amount.longValue());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(this.key, subMap);
        return hashMap;
    }

    @Override
    public AVOp merge(AVOp other) {
        this.assertKeyEquals(other);
        switch (other.type()) {
            case Set: 
            case Delete: {
                return other;
            }
            case Increment: {
                this.amount = this.amount.intValue() + other.cast(IncrementOp.class).amount.intValue();
                return this;
            }
            case Compound: {
                other.cast(CompoundOp.class).addFirst(this);
                return other;
            }
            case Add: 
            case AddUnique: 
            case Remove: {
                return new CompoundOp(this.key, this, other);
            }
            case AddRelation: 
            case RemoveRelation: {
                throw new UnsupportedOperationException("Could not add or remove relation on an numberic value.");
            }
            case Null: {
                return this;
            }
        }
        throw new IllegalStateException("Unknow op type " + (Object)((Object)other.type()));
    }

    @Override
    public Number getValues() {
        return this.amount;
    }

    @Override
    public Number apply(Object value) {
        Long result = 0L;
        if (value == null) {
            return this.amount;
        }
        if (value instanceof Double || value instanceof Float || this.amount instanceof Double || this.amount instanceof Float) {
            return ((Number)value).doubleValue() + this.amount.doubleValue();
        }
        return ((Number)value).longValue() + this.amount.longValue();
    }
}

