/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.internal;

import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GetDataCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.internal.AppConfiguration;
import com.avos.avoscloud.internal.InternalCache;
import com.avos.avoscloud.internal.InternalCallback;
import com.avos.avoscloud.internal.InternalClientConfiguration;
import com.avos.avoscloud.internal.InternalFileDownloader;
import com.avos.avoscloud.internal.InternalLogger;
import com.avos.avoscloud.internal.InternalPersistence;
import com.avos.avoscloud.internal.InternalRequestSign;
import com.avos.avoscloud.internal.impl.DefaultAppConfiguration;
import com.avos.avoscloud.internal.impl.DefaultClientConfiguration;
import com.avos.avoscloud.internal.impl.DefaultInternalCacheImpementation;
import com.avos.avoscloud.internal.impl.DefaultInternalCallback;
import com.avos.avoscloud.internal.impl.DefaultInternalRequestSign;
import com.avos.avoscloud.internal.impl.EmptyLogger;
import com.avos.avoscloud.internal.impl.EmptyPersistence;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class InternalConfigurationController {
    private static volatile InternalConfigurationController instance;
    private final InternalClientConfiguration clientConfiguration;
    private final AppConfiguration appConfiguration;
    private final InternalCache cacheImplmentation;
    private final InternalCallback internalCallback;
    private final InternalLogger internalLogger;
    private final InternalPersistence internalPersistence;
    private final InternalRequestSign internalRequestSign;
    private final Class<? extends InternalFileDownloader> downloadImplementation;

    private InternalConfigurationController() {
        this.clientConfiguration = DefaultClientConfiguration.instance();
        this.appConfiguration = DefaultAppConfiguration.instance();
        this.cacheImplmentation = DefaultInternalCacheImpementation.instance();
        this.internalCallback = DefaultInternalCallback.instance();
        this.internalLogger = EmptyLogger.instance();
        this.internalPersistence = EmptyPersistence.instance();
        this.internalRequestSign = DefaultInternalRequestSign.instance();
        this.downloadImplementation = null;
    }

    private InternalConfigurationController(Builder builder) {
        this.clientConfiguration = AVUtils.or(builder.clientConfiguration, DefaultClientConfiguration.instance());
        this.appConfiguration = AVUtils.or(builder.appConfiguration, DefaultAppConfiguration.instance());
        this.cacheImplmentation = AVUtils.or(builder.cacheImplmentation, DefaultInternalCacheImpementation.instance());
        this.internalCallback = AVUtils.or(builder.internalCallback, DefaultInternalCallback.instance());
        this.internalLogger = AVUtils.or(builder.internalLogger, EmptyLogger.instance());
        this.internalPersistence = AVUtils.or(builder.internalPersistence, EmptyPersistence.instance());
        this.internalRequestSign = AVUtils.or(builder.internalRequestSign, DefaultInternalRequestSign.instance());
        this.downloadImplementation = builder.downloadImplementation;
    }

    public static InternalConfigurationController globalInstance() {
        if (instance == null) {
            instance = new InternalConfigurationController();
        }
        return instance;
    }

    public InternalClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public AppConfiguration getAppConfiguration() {
        return this.appConfiguration;
    }

    public InternalCache getCache() {
        return this.cacheImplmentation;
    }

    public InternalCallback getInternalCallback() {
        return this.internalCallback;
    }

    public InternalLogger getInternalLogger() {
        return this.internalLogger;
    }

    public InternalPersistence getInternalPersistence() {
        return this.internalPersistence;
    }

    public InternalFileDownloader getDownloaderInstance(ProgressCallback progressCallback, GetDataCallback getDataCallback) {
        InternalFileDownloader downloader = null;
        if (this.downloadImplementation != null) {
            try {
                downloader = this.downloadImplementation.newInstance();
                return downloader;
            }
            catch (IllegalAccessException e) {
                try {
                    Constructor<? extends InternalFileDownloader> constructor = this.downloadImplementation.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    downloader = constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException | SecurityException constructor) {
                }
                catch (InstantiationException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        if (downloader != null) {
            downloader.setProgressCallback(progressCallback);
            downloader.setGetDataCallback(getDataCallback);
        }
        return downloader;
    }

    public InternalRequestSign getInternalRequestSign() {
        return this.internalRequestSign;
    }

    public static class Builder {
        InternalClientConfiguration clientConfiguration;
        AppConfiguration appConfiguration;
        InternalCache cacheImplmentation;
        InternalCallback internalCallback;
        InternalLogger internalLogger;
        InternalPersistence internalPersistence;
        InternalRequestSign internalRequestSign;
        Class<? extends InternalFileDownloader> downloadImplementation;

        public Builder setDownloaderImplementation(Class<? extends InternalFileDownloader> clazz) {
            this.downloadImplementation = clazz;
            return this;
        }

        public Builder setInternalRequestSign(InternalRequestSign internalRequestSign) {
            this.internalRequestSign = internalRequestSign;
            return this;
        }

        public Builder setClientConfiguration(InternalClientConfiguration config) {
            this.clientConfiguration = config;
            return this;
        }

        public Builder setInternalPersistence(InternalPersistence persistence) {
            this.internalPersistence = persistence;
            return this;
        }

        public Builder setAppConfiguration(AppConfiguration config) {
            this.appConfiguration = config;
            return this;
        }

        public Builder setCache(InternalCache cache) {
            this.cacheImplmentation = cache;
            return this;
        }

        public Builder setInternalCallback(InternalCallback callback) {
            this.internalCallback = callback;
            return this;
        }

        public Builder setInternalLogger(InternalLogger logger) {
            this.internalLogger = logger;
            return this;
        }

        public InternalConfigurationController build() {
            InternalConfigurationController configurationController = new InternalConfigurationController(this);
            if (instance != null) {
                LogUtil.log.e("Please call this method before initialize");
                return null;
            }
            instance = configurationController;
            instance.getAppConfiguration().setEnv();
            return configurationController;
        }
    }
}

